/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ClippedShader;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.KeySet;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.ShaderConfigKey;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SubrangeConfigKey;
import uk.ac.starlink.ttools.plot2.config.ToggleNullConfigKey;

public class RampKeySet
implements KeySet<Ramp> {
    private final ClippedShader[] shaders_;
    private final ConfigKey<Shader> shaderKey_;
    private final ConfigKey<Subrange> shadeclipKey_;
    private final ConfigKey<Boolean> flipKey_;
    private final ConfigKey<Double> quantiseKey_;
    private final OptionConfigKey<Scaling> scalingKey_;
    private final ConfigKey<Subrange> dataclipKey_;
    private final Map<Shader, Subrange> clipMap_;
    private final ConfigKey<?>[] keys_;

    public RampKeySet(String axname, String axName, ClippedShader[] shaders, Scaling dfltScaling, boolean hasDataclip) {
        this.shaders_ = shaders;
        this.clipMap_ = new LinkedHashMap<Shader, Subrange>();
        ArrayList<ConfigKey<Object>> keyList = new ArrayList<ConfigKey<Object>>();
        ArrayList<Shader> shaderList = new ArrayList<Shader>();
        for (ClippedShader cs : shaders) {
            Shader shader = cs.getShader();
            shaderList.add(shader);
            Subrange clip = cs.getSubrange();
            if (clip == null || Subrange.isIdentity(clip)) continue;
            this.clipMap_.put(shader, clip);
        }
        shaderList.addAll(Arrays.asList(Shaders.getCustomShaders()));
        ConfigMeta shaderMeta = ShaderConfigKey.createAxisMeta(axname + "map", "Shader", axName);
        this.shaderKey_ = new ShaderConfigKey(shaderMeta, shaderList.toArray(new Shader[0]), (Shader)shaderList.get(0)).appendShaderDescription();
        keyList.add(this.shaderKey_);
        ConfigMeta shadeclipMeta = SubrangeConfigKey.createShaderClipMeta(axname, axName).appendXmlDescription(new String[]{"<p>If the null (default) value is chosen,", "a default clip will be used.", "This generally covers most or all of the range 0-1", "but for colour maps which fade to white,", "a small proportion of the lower end may be excluded,", "to ensure that all the colours are visually distinguishable", "from a white background.", "This default is usually a good idea if the colour map", "is being used with something like a scatter plot,", "where markers are plotted against a white background.", "However, for something like a density map when the whole", "plotting area is tiled with colours from the map,", "it may be better to supply the whole range", "<code>0,1</code> explicitly.", "</p>"});
        this.shadeclipKey_ = new ToggleNullConfigKey<Subrange>(new SubrangeConfigKey(shadeclipMeta), "Default", true);
        keyList.add(this.shadeclipKey_);
        ConfigMeta flipMeta = new ConfigMeta(axname + "flip", "Shader Flip");
        flipMeta.setShortDescription("Flip " + axName + " colour ramp?");
        flipMeta.setXmlDescription(new String[]{"<p>If true, the colour map on the", axName, "axis will be reversed.", "</p>"});
        this.flipKey_ = new BooleanConfigKey(flipMeta);
        keyList.add(this.flipKey_);
        ConfigMeta quantiseMeta = new ConfigMeta(axname + "quant", "Shader Quantise");
        quantiseMeta.setShortDescription(axName + " colour map quantisation");
        quantiseMeta.setXmlDescription(new String[]{"<p>Allows the colour map used for the", axName, "axis to be quantised.", "If an integer value N is chosen", "then the colour map will be viewed as N discrete evenly-spaced", "levels,", "so that only N different colours will appear in the plot.", "This can be used to generate a contour-like effect,", "and may make it easier to trace the boundaries of", "regions of interest by eye.", "</p>", "<p>If left blank, the colour map is", "nominally continuous (though in practice it may be quantised", "to a medium-sized number like 256).", "</p>"});
        this.quantiseKey_ = new DoubleConfigKey(quantiseMeta, Double.NaN){
            final double LIMIT = 64.0;
            {
                this.LIMIT = 64.0;
            }

            @Override
            public Specifier<Double> createSpecifier() {
                return new SliderSpecifier(2.0, 64.0, true, 64.0, true, SliderSpecifier.TextOption.ENTER_ECHO){

                    @Override
                    public Double getSpecifiedValue() {
                        double v = super.getSpecifiedValue();
                        return v < 64.0 ? v : Double.NaN;
                    }

                    @Override
                    public void setSpecifiedValue(Double dval) {
                        super.setSpecifiedValue(dval < 64.0 ? dval : 64.0);
                    }
                };
            }
        };
        keyList.add(this.quantiseKey_);
        this.dataclipKey_ = new SubrangeConfigKey(SubrangeConfigKey.createAxisSubMeta(axname, axName));
        if (hasDataclip) {
            keyList.add(this.dataclipKey_);
        }
        ConfigMeta scalingMeta = new ConfigMeta(axname + "func", "Scaling");
        scalingMeta.setShortDescription(axName + " scaling function");
        this.scalingKey_ = new OptionConfigKey<Scaling>(scalingMeta, Scaling.class, Scaling.STRETCHES, dfltScaling){

            @Override
            public String getXmlDescription(Scaling scaling) {
                return scaling.getDescription();
            }
        };
        this.scalingKey_.setOptionUsage();
        scalingMeta.setXmlDescription(new String[]{"<p>Defines the way that values in the", axName, "range are mapped to the selected colour ramp.", "</p>", this.scalingKey_.getOptionsXml(), "<p>For all these options,", "the full range of valid data values is used,", "and displayed on the colour bar", hasDataclip ? "if applicable (though it can be restricted using the <code>" + this.dataclipKey_.getMeta().getShortName() + "</code> option)" : "if applicable.", "Note that logarithmic-based options", "<code>" + Scaling.LOG + "</code> and", "<code>" + Scaling.HISTOLOG + "</code>", "will ignore non-positive values.", "The <code>" + Scaling.LINEAR + "</code>,", "<code>" + Scaling.LOG + "</code>,", "<code>" + Scaling.SQUARE + "</code> and", "<code>" + Scaling.SQRT + "</code> options", "just apply the named function to the full data range.", "The histogram options on the other hand use a scaling function", "that corresponds to the actual distribution of the data, so that", "there are about the same number of points (or pixels, or whatever", "is being scaled) of each colour.", "The histogram options are somewhat more expensive,", "but can be a good choice if you are exploring data whose", "distribution is unknown or not well-behaved over", "its min-max range.", "The <code>" + Scaling.HISTO + "</code> and ", "<code>" + Scaling.HISTOLOG + "</code> options both", "assign the colours in the same way, but they display the colour", "ramp with linear or logarithmic annotation respectively;", "the <code>" + Scaling.HISTOLOG + "</code> option also ignores", "non-positive values.", "</p>"});
        keyList.add(this.scalingKey_);
        this.keys_ = keyList.toArray(new ConfigKey[0]);
    }

    @Override
    public ConfigKey<?>[] getKeys() {
        return this.keys_;
    }

    @Override
    public Ramp createValue(ConfigMap config) {
        Shader shader = config.get(this.shaderKey_);
        Subrange shadeclip = config.get(this.shadeclipKey_);
        if (shadeclip == null) {
            shadeclip = this.clipMap_.get(shader);
        }
        boolean isFlip = config.get(this.flipKey_);
        double quantise = config.get(this.quantiseKey_);
        if (shadeclip != null && !Subrange.isIdentity(shadeclip)) {
            shader = Shaders.stretch(shader, (float)shadeclip.getLow(), (float)shadeclip.getHigh());
        }
        if (isFlip) {
            shader = Shaders.invert(shader);
        }
        if (quantise > 1.0 && quantise < 256.0) {
            shader = Shaders.quantise(shader, quantise);
        }
        Scaling scaling = config.get(this.scalingKey_);
        Subrange dataclip = config.get(this.dataclipKey_);
        return RampKeySet.createRamp(shader, scaling, dataclip);
    }

    public ClippedShader[] getShaders() {
        return this.shaders_;
    }

    private static Ramp createRamp(final Shader shader, final Scaling scaling, final Subrange dataclip) {
        return new Ramp(){

            @Override
            public Shader getShader() {
                return shader;
            }

            @Override
            public Scaling getScaling() {
                return scaling;
            }

            @Override
            public Subrange getDataClip() {
                return dataclip;
            }
        };
    }

    public static ShadeAxisFactory createShadeAxisFactory(Ramp ramp, final Captioner captioner, final String label, final double crowding, final int rampWidth) {
        final Shader shader = ramp.getShader();
        final Scaling scaling = ramp.getScaling();
        final Subrange dataclip = ramp.getDataClip();
        final boolean isLog = scaling.isLogLike();
        return new ShadeAxisFactory(){

            @Override
            public boolean isLog() {
                return isLog;
            }

            @Override
            public ShadeAxis createShadeAxis(Span span) {
                if (span == null) {
                    span = PlotUtil.EMPTY_SPAN;
                }
                Scaler scaler = span.createScaler(scaling, dataclip);
                assert (scaler.hashCode() == span.createScaler(scaling, dataclip).hashCode());
                assert (scaler.equals(span.createScaler(scaling, dataclip)));
                return new ShadeAxis(shader, scaler, label, captioner, crowding, rampWidth);
            }
        };
    }

    public static interface Ramp {
        public Shader getShader();

        public Scaling getScaling();

        public Subrange getDataClip();
    }
}

