/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.TextFieldSpecifier;
import uk.ac.starlink.ttools.plot2.geom.TimeFormat;

public class TimeConfigKey
extends ConfigKey<Double> {
    public static final String FORMAT_XML = PlotUtil.concatLines(new String[]{"<p>The value may be set with a string that can be interpreted as", "a decimal year", "(e.g. \"<code>2007.521</code>\")", "or an ISO-8601 string", "(e.g. \"<code>2007-07-10T03:57:36</code>\",", "\"<code>2007-07-10T03</code>\"", "or \"<code>2007-07-10</code>\").", "Note however that the numeric value of this configuration item", "if accessed programmatically is seconds since 1 Jan 1970.", "</p>"});
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public TimeConfigKey(ConfigMeta meta) {
        this(meta, Double.NaN);
        if (meta.getStringUsage() == null) {
            meta.setStringUsage("<year-or-iso8601>");
        }
    }

    public TimeConfigKey(ConfigMeta meta, double dfltUnixSeconds) {
        super(meta, Double.class, dfltUnixSeconds);
    }

    @Override
    public String valueToString(Double value) {
        double stime = value == null ? Double.NaN : value;
        return Double.isNaN(stime) ? "" : this.formatTime(stime);
    }

    @Override
    public Double stringToValue(String txt) throws ConfigException {
        double mjd;
        double dval;
        if (txt == null || txt.trim().length() == 0) {
            return Double.NaN;
        }
        txt = txt.trim();
        try {
            dval = Double.parseDouble(txt);
        }
        catch (NumberFormatException e) {
            dval = Double.NaN;
        }
        if (!Double.isNaN(dval)) {
            return TimeFormat.decimalYearToUnixSeconds(dval);
        }
        try {
            mjd = Times.isoToMjd(txt);
        }
        catch (RuntimeException e) {
            mjd = Double.NaN;
        }
        if (!Double.isNaN(mjd)) {
            return (double)Times.mjdToUnixMillis(mjd) * 0.001;
        }
        String msg = "Can't parse \"" + txt + "\" as decimal year or ISO-8601 time";
        throw new ConfigException(this, msg);
    }

    @Override
    public Specifier<Double> createSpecifier() {
        return new TextFieldSpecifier<Double>(this, Double.NaN);
    }

    private String formatTime(double unixSec) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        fmt.setTimeZone(UTC);
        fmt.setCalendar(new GregorianCalendar(UTC, Locale.UK));
        String ftime = fmt.format(new Date(Math.round(unixSec * 1000.0)));
        while (ftime.endsWith(":00")) {
            ftime = ftime.substring(0, ftime.length() - 3);
        }
        if (ftime.endsWith("T")) {
            ftime = ftime.substring(0, ftime.length() - 1);
        }
        if (ftime.endsWith("-01-01")) {
            ftime = ftime.substring(0, ftime.length() - 6);
        }
        return ftime;
    }
}

