/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.VerticesAndPathComputer;
import uk.ac.starlink.ttools.cone.CdsHealpixUtil;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.LongCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkySys;

public abstract class HealpixDataGeom
implements DataGeom {
    public static final LongCoord HEALPIX_COORD = new LongCoord(new InputMeta("healpix", "HEALPix index").setShortDescription("HEALPix index").setXmlDescription(new String[]{"<p>HEALPix index indicating the sky position of the tile", "whose value is plotted.", "If not supplied, the assumption is that the supplied table", "contains one row for each HEALPix tile at a given level,", "in ascending order.", "</p>"}), false);
    public static final HealpixDataGeom DUMMY_INSTANCE = new UnitHealpixDataGeom("dummy", -1, true);
    private final String variantName_;
    private final boolean isNest_;
    private final int level_;
    private final VerticesAndPathComputer vpc_;
    private final HealpixNested ringer_;
    private final long nsky_;

    private HealpixDataGeom(String variantName, int level, boolean isNest) {
        this.variantName_ = variantName;
        this.level_ = level;
        this.isNest_ = isNest;
        this.vpc_ = level >= 0 ? Healpix.getNestedFast((int)level) : null;
        this.ringer_ = level >= 0 ? Healpix.getNested((int)level) : null;
        this.nsky_ = 12L << 2 * level;
    }

    @Override
    public int getDataDimCount() {
        return 3;
    }

    @Override
    public String getVariantName() {
        return this.variantName_;
    }

    @Override
    public Coord[] getPosCoords() {
        return new Coord[]{HEALPIX_COORD};
    }

    @Override
    public boolean readDataPos(Tuple tuple, int icol, double[] dpos) {
        long ipix = tuple.getLongValue(icol);
        if (ipix >= 0L && ipix < this.nsky_) {
            if (!this.isNest_) {
                ipix = this.ringer_.toNested(ipix);
            }
            this.vpc_.center(ipix, dpos);
            double lonRad = dpos[0];
            double latRad = dpos[1];
            CdsHealpixUtil.lonlatToVector(lonRad, latRad, dpos);
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof HealpixDataGeom) {
            HealpixDataGeom other = (HealpixDataGeom)o;
            return this.level_ == other.level_ && this.isNest_ == other.isNest_;
        }
        return false;
    }

    public int hashCode() {
        int code = 9932;
        code = 23 * code + this.level_;
        code = 23 * code + (this.isNest_ ? 11 : 29);
        return code;
    }

    public static HealpixDataGeom createGeom(int level, boolean isNest, SkySys userSys, SkySys viewSys) {
        if (userSys == null || viewSys == null) {
            return new UnitHealpixDataGeom("hpx:generic", level, isNest);
        }
        if (userSys == viewSys) {
            return new UnitHealpixDataGeom("hpx:" + userSys, level, isNest);
        }
        return new RotateHealpixDataGeom("hpx:" + userSys + "-" + viewSys, level, isNest, Rotation.createRotation(userSys, viewSys));
    }

    private static class RotateHealpixDataGeom
    extends HealpixDataGeom {
        private final Rotation rotation_;

        RotateHealpixDataGeom(String name, int level, boolean isNest, Rotation rotation) {
            super(name, level, isNest);
            this.rotation_ = rotation;
        }

        @Override
        public boolean readDataPos(Tuple tuple, int icol, double[] dpos) {
            if (super.readDataPos(tuple, icol, dpos)) {
                this.rotation_.rotate(dpos);
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof RotateHealpixDataGeom) {
                RotateHealpixDataGeom other = (RotateHealpixDataGeom)o;
                return super.equals(other) && this.rotation_.equals(other.rotation_);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code = 23 * code + this.rotation_.hashCode();
            return code;
        }
    }

    private static final class UnitHealpixDataGeom
    extends HealpixDataGeom {
        UnitHealpixDataGeom(String name, int level, boolean isNest) {
            super(name, level, isNest);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof UnitHealpixDataGeom && super.equals(o);
        }
    }
}

