/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.PerUnitConfigKey;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.geom.MatrixGangerFactory;
import uk.ac.starlink.ttools.plot2.geom.OrientationPolicy;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.PlanePlotType;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.layer.ContourPlotter;
import uk.ac.starlink.ttools.plot2.layer.DensogramPlotter;
import uk.ac.starlink.ttools.plot2.layer.FillPlotter;
import uk.ac.starlink.ttools.plot2.layer.FixedKernelDensityPlotter;
import uk.ac.starlink.ttools.plot2.layer.FunctionPlotter;
import uk.ac.starlink.ttools.plot2.layer.GridPlotter;
import uk.ac.starlink.ttools.plot2.layer.HistogramPlotter;
import uk.ac.starlink.ttools.plot2.layer.KnnKernelDensityPlotter;
import uk.ac.starlink.ttools.plot2.layer.LabelPlotter;
import uk.ac.starlink.ttools.plot2.layer.LinePlotter;
import uk.ac.starlink.ttools.plot2.layer.LinearFitPlotter;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.Stats1Plotter;
import uk.ac.starlink.ttools.plot2.layer.TracePlotter;
import uk.ac.starlink.ttools.plot2.layer.Unit;

public class MatrixPlotType
extends PlanePlotType {
    public static final PlaneSurfaceFactory.Config MATRIX_CONFIG = new PlaneSurfaceFactory.Config(){

        @Override
        public boolean has2dMetric() {
            return true;
        }

        @Override
        public boolean hasSecondaryAxes() {
            return false;
        }

        @Override
        public boolean labelFormattedPosition() {
            return true;
        }

        @Override
        public ConfigKey<OrientationPolicy> getOrientationsKey() {
            return PlaneSurfaceFactory.ORIENTATIONS_KEY_MATRIX;
        }
    };
    private static final MatrixPlotType INSTANCE = new MatrixPlotType(new PlaneSurfaceFactory(MATRIX_CONFIG), MatrixPlotType.createMatrixPlotters());

    public MatrixPlotType(PlaneSurfaceFactory surfFact, Plotter<?>[] plotters) {
        super(surfFact, plotters);
    }

    @Override
    public GangerFactory<PlaneSurfaceFactory.Profile, PlaneAspect> getGangerFactory() {
        return MatrixGangerFactory.instance();
    }

    @Override
    public String toString() {
        return "matrix";
    }

    public static MatrixPlotType getInstance() {
        return INSTANCE;
    }

    public static InputMeta getCoordMeta(int ic) {
        String suffix = Integer.toString(ic + 1);
        InputMeta meta = new InputMeta("x" + suffix, "X" + suffix);
        meta.setShortDescription("Coordinate for spatial vector element #" + suffix);
        return meta;
    }

    public static String getCoordName(int ic) {
        return MatrixPlotType.getCoordMeta(ic).getLongName();
    }

    private static Plotter<?>[] createMatrixPlotters() {
        ArrayList<Plotter> list = new ArrayList<Plotter>();
        ShapeForm[] forms = new ShapeForm[]{MarkForm.SINGLE};
        ShapePlotter[] shapePlotters = ShapePlotter.createShapePlotters(forms, ShapeMode.MODES_2D);
        list.addAll(Arrays.asList(shapePlotters));
        PerUnitConfigKey<Unit> unitKey = null;
        list.addAll(Arrays.asList(new LinePlotter(LinePlotter.PLANE_SORTAXIS_KEY), new LinearFitPlotter(true), LabelPlotter.POINT_INSTANCE, new ContourPlotter(true), new GridPlotter(true), new FillPlotter(true), TracePlotter.createPointsTracePlotter(true), new HistogramPlotter(PlaneDataGeom.X_COORD, true, unitKey), new FixedKernelDensityPlotter(PlaneDataGeom.X_COORD, true, unitKey), new KnnKernelDensityPlotter(PlaneDataGeom.X_COORD, true, unitKey), new DensogramPlotter(PlaneDataGeom.X_COORD, true), new Stats1Plotter(PlaneDataGeom.X_COORD, true, unitKey), FunctionPlotter.PLANE));
        return list.toArray(new Plotter[0]);
    }
}

