/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.NullCaptioner;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.TickLook;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.SideFlags;

public class PlaneAxisAnnotation
implements AxisAnnotation {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final Axis xaxis_;
    private final Axis yaxis_;
    private final Tick[] xticks_;
    private final Tick[] yticks_;
    private final Orientation xorient_;
    private final Orientation yorient_;
    private final String xlabel_;
    private final String ylabel_;
    private final Tick[] x2ticks_;
    private final Tick[] y2ticks_;
    private final Orientation x2orient_;
    private final Orientation y2orient_;
    private final String x2label_;
    private final String y2label_;
    private final Captioner captioner_;
    private final SideFlags annotateFlags_;
    private final int xoff_;
    private final int yoff_;
    private final int x2off_;
    private final int y2off_;
    public static final boolean INVERT_Y = true;

    public PlaneAxisAnnotation(int gxlo, int gxhi, int gylo, int gyhi, Axis xaxis, Axis yaxis, Tick[] xticks, Tick[] yticks, Orientation xorient, Orientation yorient, String xlabel, String ylabel, Tick[] x2ticks, Tick[] y2ticks, Orientation x2orient, Orientation y2orient, String x2label, String y2label, Captioner captioner, SideFlags annotateFlags) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.xaxis_ = xaxis;
        this.yaxis_ = yaxis;
        this.xticks_ = xticks;
        this.yticks_ = yticks;
        this.xorient_ = xorient;
        this.yorient_ = yorient;
        this.xlabel_ = xlabel;
        this.ylabel_ = ylabel;
        this.x2ticks_ = x2ticks == null ? new Tick[]{} : x2ticks;
        this.y2ticks_ = y2ticks == null ? new Tick[]{} : y2ticks;
        this.x2orient_ = x2orient;
        this.y2orient_ = y2orient;
        this.x2label_ = x2label;
        this.y2label_ = y2label;
        this.captioner_ = captioner;
        this.annotateFlags_ = annotateFlags;
        this.xoff_ = gxlo;
        this.yoff_ = gyhi;
        this.x2off_ = gxhi;
        this.y2off_ = gylo;
    }

    @Override
    public void drawLabels(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        TickLook tickLook = TickLook.STANDARD;
        AffineTransform trans0 = g2.getTransform();
        AffineTransform transX = new AffineTransform(trans0);
        transX.concatenate(PlaneAxisAnnotation.axisTransform(this.xoff_, this.yoff_, false));
        AffineTransform transY = new AffineTransform(trans0);
        transY.concatenate(PlaneAxisAnnotation.axisTransform(this.xoff_, this.yoff_, true));
        g2.setTransform(transX);
        this.xaxis_.drawLabels(this.xticks_, this.xlabel_, this.getCaptioner(this.annotateFlags_.isBottom()), tickLook, this.xorient_, false, g2);
        g2.setTransform(transY);
        this.yaxis_.drawLabels(this.yticks_, this.ylabel_, this.getCaptioner(this.annotateFlags_.isLeft()), tickLook, this.yorient_, true, g2);
        if (this.x2ticks_.length > 0 || this.x2label_ != null) {
            AffineTransform transX2 = new AffineTransform(trans0);
            transX2.concatenate(PlaneAxisAnnotation.axisTransform(this.xoff_, this.y2off_, false));
            g2.setTransform(transX2);
            this.xaxis_.drawLabels(this.x2ticks_, this.x2label_, this.getCaptioner(this.annotateFlags_.isTop()), tickLook, this.x2orient_, false, g2);
        }
        if (this.y2ticks_.length > 0 || this.y2label_ != null) {
            AffineTransform transY2 = new AffineTransform(trans0);
            transY2.concatenate(PlaneAxisAnnotation.axisTransform(this.x2off_, this.yoff_, true));
            g2.setTransform(transY2);
            this.yaxis_.drawLabels(this.y2ticks_, this.y2label_, this.getCaptioner(this.annotateFlags_.isRight()), tickLook, this.y2orient_, true, g2);
        }
        g2.setTransform(trans0);
    }

    @Override
    public Surround getSurround(boolean withScroll) {
        Rectangle bounds = new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        Surround surround = new Surround();
        Rectangle xrect = PlaneAxisAnnotation.getLabelBounds(this.xaxis_, this.xticks_, this.xlabel_, this.getCaptioner(this.annotateFlags_.isBottom()), this.xorient_, false, withScroll);
        Rectangle bottomRect = PlaneAxisAnnotation.axisTransform(this.xoff_, this.yoff_, false).createTransformedShape(xrect).getBounds();
        int bottomExtent = bottomRect.y + bottomRect.height - this.gyhi_;
        int bottomUnder = Math.max(0, this.gxlo_ - bottomRect.x);
        int bottomOver = Math.max(0, bottomRect.x + bottomRect.width - this.gxhi_);
        surround.bottom = new Surround.Block(bottomExtent, bottomUnder, bottomOver);
        Rectangle yrect = PlaneAxisAnnotation.getLabelBounds(this.yaxis_, this.yticks_, this.ylabel_, this.getCaptioner(this.annotateFlags_.isLeft()), this.yorient_, true, withScroll);
        Rectangle leftRect = PlaneAxisAnnotation.axisTransform(this.xoff_, this.yoff_, true).createTransformedShape(yrect).getBounds();
        int leftExtent = this.gxlo_ - leftRect.x;
        int leftUnder = Math.max(0, this.gylo_ - leftRect.y);
        int leftOver = Math.max(0, leftRect.y + leftRect.height - this.gyhi_);
        surround.left = new Surround.Block(leftExtent, leftUnder, leftOver);
        if (this.x2ticks_.length > 0 || this.x2label_ != null) {
            Rectangle x2rect = PlaneAxisAnnotation.getLabelBounds(this.xaxis_, this.x2ticks_, this.x2label_, this.getCaptioner(this.annotateFlags_.isTop()), this.x2orient_, false, withScroll);
            Rectangle topRect = PlaneAxisAnnotation.axisTransform(this.xoff_, this.y2off_, false).createTransformedShape(x2rect).getBounds();
            int topExtent = this.gylo_ - topRect.y;
            int topUnder = Math.max(0, this.gxlo_ - topRect.x);
            int topOver = Math.max(0, topRect.x + topRect.width - this.gxhi_);
            surround.top = new Surround.Block(topExtent, topUnder, topOver);
        }
        if (this.y2ticks_.length > 0 || this.y2label_ != null) {
            Rectangle y2rect = PlaneAxisAnnotation.getLabelBounds(this.yaxis_, this.y2ticks_, this.y2label_, this.getCaptioner(this.annotateFlags_.isRight()), this.y2orient_, true, withScroll);
            Rectangle rightRect = PlaneAxisAnnotation.axisTransform(this.x2off_, this.yoff_, true).createTransformedShape(y2rect).getBounds();
            int rightExtent = rightRect.x + rightRect.width - this.gxhi_;
            int rightUnder = Math.max(0, this.gylo_ - rightRect.y);
            int rightOver = Math.max(0, rightRect.y + rightRect.height - this.gyhi_);
            surround.right = new Surround.Block(rightExtent, rightUnder, rightOver);
        }
        return surround;
    }

    private Captioner getCaptioner(boolean isAnnotate) {
        return isAnnotate ? this.captioner_ : NullCaptioner.INSTANCE;
    }

    private static Rectangle getLabelBounds(Axis axis, Tick[] ticks, String label, Captioner captioner, Orientation orient, boolean invert, boolean withScroll) {
        Tick[] ticks1;
        if (withScroll) {
            int[] glims = axis.getGraphicsLimits();
            double d1 = axis.graphicsToData((double)glims[0] - 0.5);
            double d2 = axis.graphicsToData((double)glims[1] + 0.5);
            ArrayList<Tick> tickList = new ArrayList<Tick>(3 * ticks.length);
            for (Tick tick : ticks) {
                Caption caption = tick.getLabel();
                tickList.add(tick);
                tickList.add(new Tick(d1, caption));
                tickList.add(new Tick(d2, caption));
            }
            ticks1 = tickList.toArray(new Tick[0]);
        } else {
            ticks1 = ticks;
        }
        return axis.getLabelBounds(ticks1, label, captioner, orient, invert);
    }

    private static AffineTransform axisTransform(int x0, int y0, boolean isY) {
        AffineTransform trans = new AffineTransform();
        trans.translate(x0, y0);
        if (isY) {
            trans.rotate(-1.5707963267948966);
        }
        return trans;
    }
}

