/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Caption;

public class SkyDistance {
    private final double radians_;
    private final Caption caption_;
    private static final int[] SEX_NUMBERS = new int[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 40, 45, 50, 60, 90, 120, 180};
    private static final int[] DEC_NUMBERS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private static final Caption DEG_UNIT = Caption.createCaption("\u00b0", "^\\circ");
    private static final Caption MIN_UNIT = Caption.createCaption("'", "^\\prime");
    private static final Caption SEC_UNIT = Caption.createCaption("\"", "^{\\prime\\prime}");
    private static final Caption MAS_UNIT = Caption.createCaption("mas");
    private static final SkyDistance DEG_DISTANCE = new SkyDistance(Math.PI / 180, SkyDistance.unitCaption(1, DEG_UNIT));
    private static final SkyDistance MIN_DISTANCE = new SkyDistance(SkyDistance.DEG_DISTANCE.radians_ / 60.0, SkyDistance.unitCaption(1, MIN_UNIT));
    private static final SkyDistance SEC_DISTANCE = new SkyDistance(SkyDistance.MIN_DISTANCE.radians_ / 60.0, SkyDistance.unitCaption(1, SEC_UNIT));

    public SkyDistance(double radians, Caption caption) {
        this.radians_ = radians;
        this.caption_ = caption;
    }

    public double getRadians() {
        return this.radians_;
    }

    public Caption getCaption() {
        return this.caption_;
    }

    public String toString() {
        return "\"" + this.caption_.toText() + "\"(" + Float.toString((float)Math.toDegrees(this.radians_)) + "deg)";
    }

    public static SkyDistance getRoundDistance(double rad) {
        double deg = rad * 180.0 / Math.PI;
        if (deg >= 1.0) {
            return SkyDistance.fixedRoundDistance(rad, deg, DEG_UNIT, SEX_NUMBERS, null);
        }
        double min = deg * 60.0;
        if (min >= 1.0) {
            return SkyDistance.fixedRoundDistance(rad, min, MIN_UNIT, SEX_NUMBERS, DEG_DISTANCE);
        }
        double sec = min * 60.0;
        if (sec >= 1.0) {
            return SkyDistance.fixedRoundDistance(rad, sec, SEC_UNIT, SEX_NUMBERS, MIN_DISTANCE);
        }
        double mas = sec * 1000.0;
        return SkyDistance.floatRoundDistance(rad, mas, MAS_UNIT, DEC_NUMBERS, SEC_DISTANCE);
    }

    private static SkyDistance fixedRoundDistance(double rad, double quant, Caption unit, int[] numbers, SkyDistance maxDist) {
        for (int num : numbers) {
            if (!(quant < (double)num)) continue;
            double d = (double)num / quant * rad;
            return maxDist != null && d / maxDist.radians_ > 0.999 ? maxDist : new SkyDistance(d, SkyDistance.unitCaption(num, unit));
        }
        return null;
    }

    private static SkyDistance floatRoundDistance(double rad, double quant, Caption unit, int[] mantissas, SkyDistance maxDist) {
        int exp = (int)Math.floor(Math.log10(quant));
        double mult = Math.pow(10.0, exp);
        for (int mantissa : mantissas) {
            if (!((double)mantissa * mult >= quant)) continue;
            double d = (double)mantissa * mult / quant * rad;
            return maxDist != null && d / maxDist.radians_ >= 0.999 ? maxDist : new SkyDistance(d, BasicTicker.linearLabel(mantissa, exp).append(unit));
        }
        return null;
    }

    private static Caption unitCaption(int quantity, Caption unit) {
        return Caption.createCaption(Integer.toString(quantity)).append(unit);
    }
}

