/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Shape;
import java.awt.geom.Point2D;
import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import uk.ac.starlink.ttools.plot2.geom.Projection;

public abstract class SkyviewProjection
implements Projection {
    private final Projecter projecter_;
    private final Deprojecter deprojecter_;
    private final Shape shape_;
    private final String name_;
    private final String description_;

    protected SkyviewProjection(Projecter projecter, Shape shape, String name, String description) {
        this.projecter_ = projecter;
        this.deprojecter_ = projecter.inverse();
        this.shape_ = shape;
        this.name_ = name;
        this.description_ = description;
    }

    @Override
    public String getProjectionName() {
        return this.name_;
    }

    @Override
    public String getProjectionDescription() {
        return this.description_;
    }

    @Override
    public Shape getProjectionShape() {
        return this.shape_;
    }

    @Override
    public boolean project(double rx, double ry, double rz, Point2D.Double pos) {
        double[] r2 = this.projecter_.transform(new double[]{rx, ry, rz});
        if (Double.isNaN(r2[0])) {
            return false;
        }
        pos.x = r2[0];
        pos.y = r2[1];
        return true;
    }

    @Override
    public boolean unproject(Point2D.Double pos, double[] r3) {
        double[] xy = new double[]{pos.x, pos.y};
        if (this.projecter_.validPosition(xy)) {
            this.deprojecter_.transform(xy, r3);
            return true;
        }
        return false;
    }

    public Projecter getSkyviewProjecter() {
        return this.projecter_;
    }
}

