/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleFunction;
import javax.swing.Icon;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinMapper;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.PixelImage;
import uk.ac.starlink.ttools.plot2.layer.Unit;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public class GridPlotter
implements Plotter<GridStyle> {
    private final boolean transparent_;
    private final boolean reportAuxKeys_;
    private static final FloatingCoord WEIGHT_COORD = FloatingCoord.WEIGHT_COORD;
    public static final ReportKey<Double> XBINWIDTH_KEY = GridPlotter.createBinWidthReportKey('x');
    public static final ReportKey<Double> YBINWIDTH_KEY = GridPlotter.createBinWidthReportKey('y');
    public static final ReportKey<StarTable> GRIDTABLE_KEY = ReportKey.createTableKey(new ReportMeta("grid_map", "Grid Map"), true);
    public static final ConfigKey<BinSizer> XBINSIZER_KEY = GridPlotter.createBinSizerConfigKey('x', XBINWIDTH_KEY);
    public static final ConfigKey<BinSizer> YBINSIZER_KEY = GridPlotter.createBinSizerConfigKey('y', YBINWIDTH_KEY);
    public static final ConfigKey<Double> XPHASE_KEY = GridPlotter.createPhaseKey('x');
    public static final ConfigKey<Double> YPHASE_KEY = GridPlotter.createPhaseKey('y');
    public static final ConfigKey<Combiner> COMBINER_KEY = new OptionConfigKey<Combiner>(new ConfigMeta("combine", "Combine").setShortDescription("Value combination mode").setXmlDescription(new String[]{"<p>Defines how values contributing to the same grid cell", "are combined together to produce the value", "assigned to that cell, and hence its colour.", "The combined values are the weights, but if the", "<code>" + WEIGHT_COORD.getInput().getMeta().getShortName() + "</code> coordinate", "is left blank, a weighting of unity is assumed.", "</p>"}), Combiner.class, Combiner.getKnownCombiners(), Combiner.MEAN){

        @Override
        public String getXmlDescription(Combiner combiner) {
            return combiner.getDescription();
        }
    }.setOptionUsage().addOptionsXml();
    private static final AuxScale SCALE = AuxScale.COLOR;
    private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
    public static final ConfigKey<Double> TRANSPARENCY_KEY = StyleKeys.TRANSPARENCY;
    private static final CoordGroup COORD_GROUP = CoordGroup.createCoordGroup(1, new Coord[]{FloatingCoord.WEIGHT_COORD});
    private static final double PADDING = 0.8;

    public GridPlotter(boolean transparent) {
        this.transparent_ = transparent;
        this.reportAuxKeys_ = false;
    }

    @Override
    public String getPlotterName() {
        return "Grid";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_GRID;
    }

    @Override
    public CoordGroup getCoordGroup() {
        return COORD_GROUP;
    }

    @Override
    public boolean hasReports() {
        return true;
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer().append("<p>Plots 2-d data aggregated into rectangular cells.\n").append("You can optionally use a weighting for the points,\n").append("and you can configure how the values are combined\n").append("to produce the output pixel values (colours).\n").append("You can use this plotter in various ways,\n").append("including as a 2-d histogram or weighted density map,\n").append("or to plot gridded data.\n").append("</p>\n").append("<p>The X and Y dimensions of the\n").append("grid cells (or equivalently histogram bins)\n").append("can be configured either\n").append("in terms of the data coordinates\n").append("or relative to the plot dimensions.\n").append("</p>\n");
        sbuf.append("<p>");
        if (this.reportAuxKeys_) {
            sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
        } else {
            sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
        }
        sbuf.append("</p>\n");
        return sbuf.toString();
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList keyList = new ArrayList();
        keyList.add(XBINSIZER_KEY);
        keyList.add(YBINSIZER_KEY);
        keyList.add(COMBINER_KEY);
        if (this.reportAuxKeys_) {
            keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
        }
        if (this.transparent_) {
            keyList.add(TRANSPARENCY_KEY);
        }
        keyList.add(XPHASE_KEY);
        keyList.add(YPHASE_KEY);
        return keyList.toArray(new ConfigKey[0]);
    }

    @Override
    public GridStyle createStyle(ConfigMap config) {
        BinSizer xSizer = config.get(XBINSIZER_KEY);
        BinSizer ySizer = config.get(YBINSIZER_KEY);
        double xPhase = config.get(XPHASE_KEY);
        double yPhase = config.get(YPHASE_KEY);
        Combiner combiner = config.get(COMBINER_KEY);
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        Scaling scaling = ramp.getScaling();
        Subrange dataclip = ramp.getDataClip();
        float scaleAlpha = 1.0f - config.get(TRANSPARENCY_KEY).floatValue();
        Shader shader = Shaders.fade(ramp.getShader(), scaleAlpha);
        return new GridStyle(xSizer, ySizer, xPhase, yPhase, scaling, dataclip, shader, combiner);
    }

    @Override
    public Object getRangeStyleKey(GridStyle style) {
        return null;
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, GridStyle style) {
        return new GridLayer(this, geom, dataSpec, style);
    }

    private static ReportKey<Double> createBinWidthReportKey(char axname) {
        String sname = axname + "binwidth";
        String lname = GridPlotter.toUpperString(axname) + " Bin Width";
        return ReportKey.createDoubleKey(new ReportMeta(sname, lname), false);
    }

    private static ConfigKey<BinSizer> createBinSizerConfigKey(char axname, ReportKey<Double> widthRepKey) {
        String axName = GridPlotter.toUpperString(axname);
        ConfigMeta meta = new ConfigMeta(axname + "binsize", axName + " Bin Size");
        meta.setStringUsage("+<extent>|-<count>");
        meta.setShortDescription(axName + " bin size specification");
        meta.setXmlDescription(new String[]{"<p>Configures the extent of the density grid bins", "on the " + axName + " axis.", "</p>", "<p>If the supplied value is a positive number", "it is interpreted as a fixed size in data coordinates", "(if the " + axName + " axis is logarithmic,", "the value is a fixed factor).", "If it is a negative number, then it will be interpreted", "as the approximate number of bins to display across", "the plot in the " + axName + " direction", "(though an attempt is made to use only round numbers", "for bin sizes).", "</p>", "<p>When setting this value graphically,", "you can use either the slider to adjust the bin count", "or the numeric entry field to fix the bin size.", "</p>"});
        boolean allowZero = false;
        return BinSizer.createSizerConfigKey(meta, widthRepKey, 30, allowZero);
    }

    private static ConfigKey<Double> createPhaseKey(char axname) {
        String axName = GridPlotter.toUpperString(axname);
        ConfigMeta meta = new ConfigMeta(axname + "phase", axName + " Bin Phase");
        meta.setShortDescription(axName + " axis bin offset");
        meta.setXmlDescription(new String[]{"<p>Controls where the zero point on the " + axName + " axis", "is set.", "For instance if your bin size is 1,", "this value controls whether bin boundaries are at", "0, 1, 2, .. or 0.5, 1.5, 2.5, ... etc.", "</p>", "<p>A value of 0 (or any integer) will result in", "a bin boundary at X=0 (linear X axis)", "or X=1 (logarithmic X axis).", "A fractional value will give a bin boundary at", "that value multiplied by the bin width.", "</p>"});
        return DoubleConfigKey.createSliderKey(meta, 0.0, 0.0, 1.0, false, false, SliderSpecifier.TextOption.ENTER_ECHO);
    }

    private static String toUpperString(char axname) {
        return Character.valueOf(Character.toUpperCase(axname)).toString();
    }

    private static double getRoundedPixelScaleWidth(Axis axis) {
        int glo = axis.getGraphicsLimits()[0];
        Scale scale = axis.getScale();
        double d1 = axis.graphicsToData(glo);
        double d2 = axis.graphicsToData(glo + 1);
        double sextent = Math.abs(scale.dataToScale(d2) - scale.dataToScale(d1));
        return (float)sextent;
    }

    private static void paintBins(Graphics g, GridPixer pixer, BinList.Result binResult, Combiner.Type ctype, Scaler scaler, IndexColorModel colorModel, PlanarSurface surface) {
        int ncolor = colorModel.getMapSize() - 1;
        double binFactor = pixer.getBinFactor(ctype);
        Rectangle bounds = surface.getPlotBounds();
        int nx = bounds.width;
        int ny = bounds.height;
        int x0 = bounds.x;
        int y0 = bounds.y;
        Gridder gridder = new Gridder(nx, ny);
        int npix = gridder.getLength();
        int[] grid = new int[npix];
        Point2D.Double gp = new Point2D.Double();
        int ib0 = -1;
        int sval = -1;
        for (int ip = 0; ip < npix; ++ip) {
            gp.x = x0 + gridder.getX(ip);
            gp.y = y0 + gridder.getY(ip);
            double[] dpos = surface.graphicsToData(gp, null);
            int ib = pixer.getBinIndex(dpos);
            if (ib < 0) continue;
            if (ib != ib0) {
                ib0 = ib;
                double dval = binFactor * binResult.getBinValue(ib);
                sval = Double.isNaN(dval) ? 0 : Math.min(1 + (int)(scaler.scaleValue(dval) * (double)ncolor), ncolor - 1);
            }
            grid[ip] = sval;
        }
        new PixelImage(new Dimension(nx, ny), grid, colorModel).paintPixels(g, new Point(x0, y0));
    }

    private static int[] getGraphicsBounds(int ibin, BinMapper mapper, Axis axis) {
        int[] nArray;
        int g1;
        double[] dlimits = mapper.getBinLimits(ibin);
        int g0 = (int)Math.floor(axis.dataToGraphics(dlimits[0]));
        if (g0 <= (g1 = (int)Math.floor(axis.dataToGraphics(dlimits[1])))) {
            int[] nArray2 = new int[2];
            nArray2[0] = g0;
            nArray = nArray2;
            nArray2[1] = g1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = g1;
            nArray = nArray3;
            nArray3[1] = g0;
        }
        return nArray;
    }

    private static StarTable createExportTable(PlanarSurface surface, GridPlan gplan) {
        DoubleFunction<Number> dataFunc;
        final GridPixer pixer = gplan.pixer_;
        double[][] dataLimits = surface.getDataLimits();
        final int ixlo = ((GridPixer)pixer).xgrid_.mapper_.getBinIndex(dataLimits[0][0]);
        int ixhi = ((GridPixer)pixer).xgrid_.mapper_.getBinIndex(dataLimits[0][1]);
        final int iylo = ((GridPixer)pixer).ygrid_.mapper_.getBinIndex(dataLimits[1][0]);
        int iyhi = ((GridPixer)pixer).ygrid_.mapper_.getBinIndex(dataLimits[1][1]);
        final int tw = ixhi - ixlo + 1;
        int th = iyhi - iylo + 1;
        int nrow = tw * th;
        final XYMapper xyMapper = new XYMapper(){

            @Override
            public int getGridX(int irow) {
                return irow % tw + ixlo;
            }

            @Override
            public int getGridY(int irow) {
                return irow / tw + iylo;
            }
        };
        DataSpec dspec = gplan.dataSpec_;
        int icPos = COORD_GROUP.getPosCoordIndex(0, gplan.geom_);
        int icWeight = COORD_GROUP.getExtraCoordIndex(0, gplan.geom_);
        ValueInfo[] xInfos = dspec.getUserCoordInfos(icPos + 0);
        ValueInfo[] yInfos = dspec.getUserCoordInfos(icPos + 1);
        String xlabel = xInfos.length == 1 ? xInfos[0].getName() : "X";
        String ylabel = yInfos.length == 1 ? yInfos[0].getName() : "Y";
        final BinList.Result binResult = gplan.result_;
        ValueInfo dataInfo = GridPlotter.getCombinedInfo(dspec, icWeight, gplan.combiner_);
        Class dataClazz = dataInfo.getContentClass();
        if (Integer.class.equals((Object)dataClazz)) {
            dataFunc = d -> (int)d;
        } else if (Short.class.equals((Object)dataClazz)) {
            dataFunc = d -> (short)d;
        } else if (Long.class.equals((Object)dataClazz)) {
            dataFunc = d -> (long)d;
        } else {
            assert (Double.class.equals((Object)dataClazz));
            dataFunc = d -> d;
        }
        ColumnData[] cdatas = new ColumnData[]{GridPlotter.createCoordColumn(xyMapper, pixer, false, 0.5, xlabel, "X bin central value"), GridPlotter.createCoordColumn(xyMapper, pixer, true, 0.5, ylabel, "Y bin central value"), new ColumnData(dataInfo){

            public Number readValue(long lrow) {
                int irow = (int)lrow;
                int ibin = pixer.getBinIndex(xyMapper.getGridX(irow), xyMapper.getGridY(irow));
                double val = ibin >= 0 ? binResult.getBinValue(ibin) : Double.NaN;
                return Double.isNaN(val) ? (Number)null : (Number)((Number)dataFunc.apply(val));
            }
        }, GridPlotter.createCoordColumn(xyMapper, pixer, false, 0.0, "LO_" + xlabel, "X bin lower bound"), GridPlotter.createCoordColumn(xyMapper, pixer, false, 1.0, "HI_" + xlabel, "X bin upper bound"), GridPlotter.createCoordColumn(xyMapper, pixer, true, 0.0, "LO_" + ylabel, "Y bin lower bound"), GridPlotter.createCoordColumn(xyMapper, pixer, true, 1.0, "HI_" + ylabel, "Y bin upper bound")};
        ColumnStarTable table = ColumnStarTable.makeTableWithRows((long)nrow);
        for (ColumnData cdata : cdatas) {
            table.addColumn(cdata);
        }
        return table;
    }

    private static ColumnData createCoordColumn(final XYMapper xyMapper, GridPixer pixer, final boolean isY, final double frac, String name, String descrip) {
        final GridSpec tgrid = isY ? pixer.ygrid_ : pixer.xgrid_;
        return new ColumnData(new ColumnInfo(name, Double.class, descrip)){

            public Double readValue(long lrow) {
                int irow = (int)lrow;
                double[] limits = tgrid.mapper_.getBinLimits(isY ? xyMapper.getGridY(irow) : xyMapper.getGridX(irow));
                double dval = PlotUtil.scaleValue(limits[0], limits[1], frac, tgrid.scale_);
                return dval;
            }
        };
    }

    private static ValueInfo getCombinedInfo(DataSpec dataSpec, int icWeight, Combiner combiner) {
        ValueInfo[] winfos;
        Object weightInfo = icWeight < 0 || dataSpec.isCoordBlank(icWeight) ? new DefaultValueInfo("1", Double.class, "Weight unspecified, taken as unity") : ((winfos = dataSpec.getUserCoordInfos(icWeight)) != null && winfos.length == 1 ? winfos[0] : new DefaultValueInfo("Weight", Double.class));
        Unit unit = new Unit("unit", "unit area", "area", 1.0, "X axis unit * Y axis unit");
        return combiner.createCombinedInfo((ValueInfo)weightInfo, unit);
    }

    private static interface XYMapper {
        public int getGridX(int var1);

        public int getGridY(int var1);
    }

    private static class GridSpec {
        final Scale scale_;
        final double binWidth_;
        final double phase_;
        final double dlo_;
        final double dhi_;
        final BinMapper mapper_;
        final int ilo_;
        final int ihi_;

        GridSpec(Scale scale, double binWidth, double phase, double[] drange) {
            this.scale_ = scale;
            this.binWidth_ = binWidth;
            this.phase_ = phase;
            this.mapper_ = new BinMapper(scale, binWidth, phase, drange[0]);
            int i0 = this.mapper_.getBinIndex(drange[0]);
            int i1 = this.mapper_.getBinIndex(drange[1]);
            double[] dlimits0 = this.mapper_.getBinLimits(i0);
            double[] dlimits1 = this.mapper_.getBinLimits(i1);
            this.ilo_ = Math.min(i0, i1);
            this.ihi_ = Math.max(i0, i1);
            this.dlo_ = Math.min(dlimits0[0], dlimits1[0]);
            this.dhi_ = Math.max(dlimits0[1], dlimits1[1]);
        }

        boolean contains(GridSpec other) {
            return this.binWidth_ == other.binWidth_ && this.phase_ == other.phase_ && this.dlo_ <= other.dlo_ && this.dhi_ >= other.dhi_;
        }

        boolean containsDataPoint(double d) {
            return d >= this.dlo_ && d < this.dhi_;
        }

        boolean containsBin(int ibin) {
            return ibin >= this.ilo_ && ibin <= this.ihi_;
        }

        boolean nearlyContainsBin(int ibin) {
            return ibin >= this.ilo_ - 1 && ibin <= this.ihi_ + 1;
        }

        int getBinOffset(int ibin) {
            return ibin - this.ilo_;
        }

        int[] getBinRange(double[] dataRange) {
            int i0 = this.mapper_.getBinIndex(dataRange[0]);
            int i1 = this.mapper_.getBinIndex(dataRange[1]);
            return new int[]{Math.min(i0, i1), Math.max(i0, i1)};
        }
    }

    private static class GridPixer {
        private final GridSpec xgrid_;
        private final GridSpec ygrid_;
        private final Gridder gridder_;

        GridPixer(GridSpec xgrid, GridSpec ygrid) {
            this.xgrid_ = xgrid;
            this.ygrid_ = ygrid;
            this.gridder_ = new Gridder(xgrid.ihi_ - xgrid.ilo_ + 1, ygrid.ihi_ - ygrid.ilo_ + 1);
        }

        public int getBinCount() {
            return this.gridder_.getLength();
        }

        public int getBinIndex(double[] dpos) {
            double dx = dpos[0];
            double dy = dpos[1];
            if (this.xgrid_.containsDataPoint(dx) && this.ygrid_.containsDataPoint(dy)) {
                int ix = this.xgrid_.mapper_.getBinIndex(dx);
                int iy = this.ygrid_.mapper_.getBinIndex(dy);
                assert (this.xgrid_.nearlyContainsBin(ix) && this.ygrid_.nearlyContainsBin(iy));
                return this.getBinIndex(ix, iy);
            }
            return -1;
        }

        int getBinIndex(int ix, int iy) {
            return this.xgrid_.containsBin(ix) && this.ygrid_.containsBin(iy) ? this.gridder_.getIndex(this.xgrid_.getBinOffset(ix), this.ygrid_.getBinOffset(iy)) : -1;
        }

        double getBinFactor(Combiner.Type ctype) {
            return ctype.getBinFactor(this.xgrid_.binWidth_ * this.ygrid_.binWidth_);
        }

        boolean contains(GridPixer other) {
            return this.xgrid_.contains(other.xgrid_) && this.ygrid_.contains(other.ygrid_);
        }
    }

    private static class GridPlan {
        final GridPixer pixer_;
        final Combiner combiner_;
        final DataSpec dataSpec_;
        final DataGeom geom_;
        final BinList.Result result_;

        GridPlan(GridPixer pixer, Combiner combiner, DataSpec dataSpec, DataGeom geom, BinList.Result result) {
            this.pixer_ = pixer;
            this.combiner_ = combiner;
            this.dataSpec_ = dataSpec;
            this.geom_ = geom;
            this.result_ = result;
        }

        public boolean matches(GridPixer pixer, Combiner combiner, DataSpec dataSpec, DataGeom geom) {
            return this.pixer_.contains(pixer) && this.combiner_.equals(combiner) && this.dataSpec_.equals(dataSpec) && this.geom_.equals(geom);
        }
    }

    private static class BinCollector
    implements SplitCollector<TupleSequence, ArrayBinList> {
        private final Combiner combiner_;
        private final GridPixer pixer_;
        private final DataGeom geom_;
        private final int icPos_;
        private final int icWeight_;

        BinCollector(Combiner combiner, GridPixer pixer, DataGeom geom, int icPos, int icWeight) {
            this.combiner_ = combiner;
            this.pixer_ = pixer;
            this.geom_ = geom;
            this.icPos_ = icPos;
            this.icWeight_ = icWeight;
        }

        public ArrayBinList createAccumulator() {
            return this.combiner_.createArrayBinList(this.pixer_.getBinCount());
        }

        public void accumulate(TupleSequence tseq, ArrayBinList binList) {
            double[] dpos = new double[this.geom_.getDataDimCount()];
            if (this.icWeight_ < 0) {
                while (tseq.next()) {
                    int ibin;
                    if (!this.geom_.readDataPos(tseq, this.icPos_, dpos) || (ibin = this.pixer_.getBinIndex(dpos)) < 0) continue;
                    binList.submitToBin(ibin, 1.0);
                }
            } else {
                while (tseq.next()) {
                    double w;
                    int ibin;
                    if (!this.geom_.readDataPos(tseq, this.icPos_, dpos) || (ibin = this.pixer_.getBinIndex(dpos)) < 0 || Double.isNaN(w = WEIGHT_COORD.readDoubleCoord(tseq, this.icWeight_))) continue;
                    binList.submitToBin(ibin, w);
                }
            }
        }

        public ArrayBinList combine(ArrayBinList binList1, ArrayBinList binList2) {
            binList1.addBins(binList2);
            return binList1;
        }
    }

    private static class GridLayer
    extends AbstractPlotLayer {
        private final GridStyle gstyle_;
        private final int icPos_;
        private final int icWeight_;

        GridLayer(GridPlotter plotter, DataGeom geom, DataSpec dataSpec, GridStyle style) {
            super(plotter, geom, dataSpec, style, LayerOpt.NO_SPECIAL);
            this.gstyle_ = style;
            this.icPos_ = COORD_GROUP.getPosCoordIndex(0, geom);
            this.icWeight_ = COORD_GROUP.getExtraCoordIndex(0, geom);
        }

        @Override
        public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType ptype) {
            return new GridDrawing((PlanarSurface)surface, auxSpans.get(SCALE), ptype);
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers() {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            map.put(SCALE, new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return icWeight_;
                }

                @Override
                public ValueInfo getAxisInfo(DataSpec dataSpec) {
                    return GridPlotter.getCombinedInfo(dataSpec, icWeight_, gstyle_.combiner_);
                }

                @Override
                public Scaling getScaling() {
                    return gstyle_.scaling_;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Ranger ranger) {
                    GridPixer pixer;
                    BinList.Result binResult;
                    PlanarSurface psurf = (PlanarSurface)surface;
                    GridPixer pixer0 = this.createGridPixer(psurf, 0.0);
                    GridPlan gridPlan = this.getGridPlan(plans, pixer0);
                    if (gridPlan != null) {
                        binResult = gridPlan.result_;
                        pixer = gridPlan.pixer_;
                    } else {
                        binResult = this.readBins(pixer0, dataSpec, dataStore).getResult();
                        pixer = pixer0;
                    }
                    this.extendRange(ranger, psurf, pixer, binResult);
                }
            });
            return map;
        }

        GridPixer createGridPixer(PlanarSurface surface, double fpad) {
            Subrange padder = new Subrange(0.0 - fpad, 1.0 + fpad);
            GridSpec[] grids = new GridSpec[2];
            BinSizer[] sizers = new BinSizer[]{this.gstyle_.xSizer_, this.gstyle_.ySizer_};
            double[] phases = new double[]{this.gstyle_.xPhase_, this.gstyle_.yPhase_};
            Axis[] axes = surface.getAxes();
            double[][] dataLimits = surface.getDataLimits();
            for (int i = 0; i < 2; ++i) {
                Axis axis = axes[i];
                Scale scale = axis.getScale();
                double dlo = dataLimits[i][0];
                double dhi = dataLimits[i][1];
                double[] drange = PlotUtil.scaleRange(dlo, dhi, padder, scale);
                double reqWidth = sizers[i].getScaleWidth(scale, dlo, dhi, true);
                double binWidth = Math.max(reqWidth, GridPlotter.getRoundedPixelScaleWidth(axis));
                double phase = phases[i];
                grids[i] = new GridSpec(scale, binWidth, phase, drange);
            }
            return new GridPixer(grids[0], grids[1]);
        }

        private BinList readBins(GridPixer pixer, DataSpec dataSpec, DataStore dataStore) {
            Combiner combiner = this.gstyle_.combiner_;
            DataGeom geom = this.getDataGeom();
            int icw = dataSpec.isCoordBlank(this.icWeight_) ? -1 : this.icWeight_;
            BinCollector collector = new BinCollector(combiner, pixer, geom, this.icPos_, icw);
            return PlotUtil.tupleCollect(collector, dataSpec, dataStore);
        }

        private GridPlan getGridPlan(Object[] knownPlans, GridPixer pixer) {
            Combiner combiner = this.gstyle_.combiner_;
            DataSpec dataSpec = this.getDataSpec();
            DataGeom geom = this.getDataGeom();
            for (Object plan : knownPlans) {
                GridPlan gplan;
                if (!(plan instanceof GridPlan) || !(gplan = (GridPlan)plan).matches(pixer, combiner, dataSpec, geom)) continue;
                return gplan;
            }
            return null;
        }

        private void extendRange(Ranger ranger, PlanarSurface surface, GridPixer pixer, BinList.Result binResult) {
            double[][] dlims = surface.getDataLimits();
            double binFactor = pixer.getBinFactor(this.gstyle_.combiner_.getType());
            int[] ixRange = pixer.xgrid_.getBinRange(dlims[0]);
            int[] iyRange = pixer.ygrid_.getBinRange(dlims[1]);
            int ixlo = ixRange[0];
            int ixhi = ixRange[1];
            int iylo = iyRange[0];
            int iyhi = iyRange[1];
            for (int iy = iylo; iy <= iyhi; ++iy) {
                for (int ix = ixlo; ix <= ixhi; ++ix) {
                    int ibin = pixer.getBinIndex(ix, iy);
                    assert (ibin >= 0);
                    ranger.submitDatum(binFactor * binResult.getBinValue(ibin));
                }
            }
        }

        private class GridDrawing
        implements Drawing {
            private final PlanarSurface surface_;
            private final Span auxSpan_;
            private final PaperType ptype_;

            GridDrawing(PlanarSurface surface, Span auxSpan, PaperType ptype) {
                this.surface_ = surface;
                this.auxSpan_ = auxSpan;
                this.ptype_ = ptype;
            }

            @Override
            public GridPlan calculatePlan(Object[] knownPlans, DataStore dataStore) {
                GridPlan knownPlan = GridLayer.this.getGridPlan(knownPlans, GridLayer.this.createGridPixer(this.surface_, 0.0));
                if (knownPlan != null) {
                    return knownPlan;
                }
                DataSpec dataSpec = GridLayer.this.getDataSpec();
                GridPixer pixer1 = GridLayer.this.createGridPixer(this.surface_, 0.8);
                BinList.Result binResult = GridLayer.this.readBins(pixer1, dataSpec, dataStore).getResult();
                return new GridPlan(pixer1, GridLayer.this.gstyle_.combiner_, dataSpec, GridLayer.this.getDataGeom(), binResult);
            }

            @Override
            public void paintData(Object plan, Paper paper, DataStore dataStore) {
                final GridPlan gplan = (GridPlan)plan;
                final Combiner.Type ctype = GridLayer.this.gstyle_.combiner_.getType();
                this.ptype_.placeDecal(paper, new Decal(){

                    @Override
                    public void paintDecal(Graphics g) {
                        Scaler scaler = GridDrawing.this.auxSpan_.createScaler(GridLayer.this.gstyle_.scaling_, GridLayer.this.gstyle_.dataclip_);
                        IndexColorModel colorModel = PixelImage.createColorModel(GridLayer.this.gstyle_.shader_, true);
                        GridPlotter.paintBins(g, gplan.pixer_, gplan.result_, ctype, scaler, colorModel, GridDrawing.this.surface_);
                    }

                    @Override
                    public boolean isOpaque() {
                        return false;
                    }
                });
            }

            @Override
            public ReportMap getReport(Object plan) {
                ReportMap report = new ReportMap();
                GridPixer pixer = GridLayer.this.createGridPixer(this.surface_, 0.0);
                report.put(XBINWIDTH_KEY, ((GridPixer)pixer).xgrid_.binWidth_);
                report.put(YBINWIDTH_KEY, ((GridPixer)pixer).ygrid_.binWidth_);
                if (plan instanceof GridPlan) {
                    report.put(GRIDTABLE_KEY, GridPlotter.createExportTable(this.surface_, (GridPlan)plan));
                }
                return report;
            }
        }
    }

    public static class GridStyle
    implements Style {
        private final BinSizer xSizer_;
        private final BinSizer ySizer_;
        private final double xPhase_;
        private final double yPhase_;
        private final Scaling scaling_;
        private final Subrange dataclip_;
        private final Shader shader_;
        private final Combiner combiner_;

        public GridStyle(BinSizer xSizer, BinSizer ySizer, double xPhase, double yPhase, Scaling scaling, Subrange dataclip, Shader shader, Combiner combiner) {
            this.xSizer_ = xSizer;
            this.ySizer_ = ySizer;
            this.xPhase_ = xPhase;
            this.yPhase_ = yPhase;
            this.scaling_ = scaling;
            this.dataclip_ = dataclip;
            this.shader_ = shader;
            this.combiner_ = combiner;
        }

        @Override
        public Icon getLegendIcon() {
            return Shaders.createShaderIcon(this.shader_, null, true, 16, 8, 2, 2);
        }

        public int hashCode() {
            int code = 27441;
            code = 23 * code + this.xSizer_.hashCode();
            code = 23 * code + this.ySizer_.hashCode();
            code = 23 * code + Float.floatToIntBits((float)this.xPhase_);
            code = 23 * code + Float.floatToIntBits((float)this.yPhase_);
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + this.dataclip_.hashCode();
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.combiner_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof GridStyle) {
                GridStyle other = (GridStyle)o;
                return this.xSizer_.equals(other.xSizer_) && this.ySizer_.equals(other.ySizer_) && this.xPhase_ == other.xPhase_ && this.yPhase_ == other.yPhase_ && this.scaling_.equals(other.scaling_) && this.dataclip_.equals(other.dataclip_) && this.shader_.equals(other.shader_) && this.combiner_.equals(other.combiner_);
            }
            return false;
        }
    }
}

