/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.layer.XYShape;

public class LineXYShape
extends XYShape {
    private final int pixSkip_;
    public static final LineXYShape INSTANCE = new LineXYShape(0);
    public static final LineXYShape INSTANCE_SKIP1 = new LineXYShape(1);
    public static BasicStroke STROKE = new BasicStroke(1.0f, 1, 1);

    private LineXYShape(int pixSkip) {
        super("Line");
        this.pixSkip_ = pixSkip;
    }

    @Override
    protected Glyph createGlyph(short x, short y) {
        int yhi;
        int ylo;
        if (x == 0 && y == 0) {
            return this.pixSkip_ == 0 ? POINT : null;
        }
        if (y == 0) {
            int xhi;
            int xlo;
            if (x >= 0) {
                xlo = 0;
                xhi = x - this.pixSkip_;
            } else {
                xlo = x + this.pixSkip_;
                xhi = 0;
            }
            return new LineGlyph(x, y){

                @Override
                public Pixer createPixer(Rectangle clip) {
                    if (clip.y <= 0 && clip.y + clip.height >= 1) {
                        int xmax;
                        int xmin = Math.max(xlo, clip.x);
                        return xmin <= (xmax = Math.min(xhi, clip.x + clip.width - 1)) ? new HorizontalPixer(xmin, xmax) : null;
                    }
                    return null;
                }
            };
        }
        if (x == 0) {
            int yhi2;
            int ylo2;
            if (y >= 0) {
                ylo2 = 0;
                yhi2 = y - this.pixSkip_;
            } else {
                ylo2 = y + this.pixSkip_;
                yhi2 = 0;
            }
            return new LineGlyph(x, y){

                @Override
                public Pixer createPixer(Rectangle clip) {
                    if (clip.x <= 0 && clip.x + clip.width >= 1) {
                        int ymax;
                        int ymin = Math.max(ylo2, clip.y);
                        return ymin <= (ymax = Math.min(yhi2, clip.y + clip.height - 1)) ? new VerticalPixer(ymin, ymax) : null;
                    }
                    return null;
                }
            };
        }
        if (Math.abs(x) > Math.abs(y)) {
            int xhi;
            int xlo;
            if (x >= 0) {
                xlo = 0;
                xhi = x - this.pixSkip_;
            } else {
                xlo = x + this.pixSkip_;
                xhi = 0;
            }
            final double slope = (double)y / (double)x;
            return new LineGlyph(x, y){

                @Override
                public Pixer createPixer(Rectangle clip) {
                    int xmax;
                    int xmin = Math.max(xlo, clip.x);
                    return xmin <= (xmax = Math.min(xhi, clip.x + clip.width - 1)) ? Pixers.clip(new ShallowPixer(xmin, xmax, slope), clip) : null;
                }
            };
        }
        assert (Math.abs(x) <= Math.abs(y));
        if (y >= 0) {
            ylo = 0;
            yhi = y - this.pixSkip_;
        } else {
            ylo = y + this.pixSkip_;
            yhi = 0;
        }
        final double slope = (double)x / (double)y;
        return new LineGlyph(x, y){

            @Override
            public Pixer createPixer(Rectangle clip) {
                int ymax;
                int ymin = Math.max(ylo, clip.y);
                return ymin <= (ymax = Math.min(yhi, clip.y + clip.height - 1)) ? Pixers.clip(new SteepPixer(ymin, ymax, slope), clip) : null;
            }
        };
    }

    private static class SteepPixer
    implements Pixer {
        private final int ymax_;
        private final double slope_;
        private int y_;

        SteepPixer(int ymin, int ymax, double slope) {
            this.ymax_ = ymax;
            this.slope_ = slope;
            this.y_ = ymin - 1;
        }

        @Override
        public boolean next() {
            return ++this.y_ <= this.ymax_;
        }

        @Override
        public int getX() {
            return (int)Math.round((double)this.y_ * this.slope_);
        }

        @Override
        public int getY() {
            return this.y_;
        }
    }

    private static class ShallowPixer
    implements Pixer {
        private final int xmax_;
        private final double slope_;
        private int x_;

        ShallowPixer(int xmin, int xmax, double slope) {
            this.xmax_ = xmax;
            this.slope_ = slope;
            this.x_ = xmin - 1;
        }

        @Override
        public boolean next() {
            return ++this.x_ <= this.xmax_;
        }

        @Override
        public int getX() {
            return this.x_;
        }

        @Override
        public int getY() {
            return (int)Math.round((double)this.x_ * this.slope_);
        }
    }

    private static class VerticalPixer
    implements Pixer {
        private int y_;
        private final int ymax_;

        VerticalPixer(int ymin, int ymax) {
            this.y_ = ymin - 1;
            this.ymax_ = ymax;
        }

        @Override
        public boolean next() {
            return ++this.y_ <= this.ymax_;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return this.y_;
        }
    }

    private static class HorizontalPixer
    implements Pixer {
        private int x_;
        private final int xmax_;

        HorizontalPixer(int xmin, int xmax) {
            this.x_ = xmin - 1;
            this.xmax_ = xmax;
        }

        @Override
        public boolean next() {
            return ++this.x_ <= this.xmax_;
        }

        @Override
        public int getX() {
            return this.x_;
        }

        @Override
        public int getY() {
            return 0;
        }
    }

    private static abstract class LineGlyph
    implements Glyph {
        private final short x_;
        private final short y_;

        protected LineGlyph(short x, short y) {
            this.x_ = x;
            this.y_ = y;
        }

        @Override
        public void paintGlyph(Graphics g) {
            g.drawLine(0, 0, this.x_, this.y_);
        }
    }
}

