/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.Pixers;

public class MarkerStyle
implements Style {
    private final MarkerShape shapeId_;
    private final Color color_;
    private final int size_;
    private final Consumer<Graphics> drawShape_;
    private final PixerFactory pixerFact_;
    public static final int LEGEND_ICON_WIDTH = 20;
    public static final int LEGEND_ICON_HEIGHT = 12;
    private static final RenderingHints PIX_HINTS = MarkerStyle.createPixerRenderingHints();

    public MarkerStyle(MarkerShape shapeId, Color color, int size, int maxr, Consumer<Graphics> drawShape) {
        this(shapeId, color, size, drawShape, MarkerStyle.shapeToPixer(drawShape, maxr));
    }

    public MarkerStyle(MarkerShape shapeId, Color color, int size, Consumer<Graphics> drawShape, Pixer pixer) {
        this.color_ = color;
        this.shapeId_ = shapeId;
        this.size_ = size;
        this.drawShape_ = drawShape;
        this.pixerFact_ = Pixers.createPixerCopier(pixer);
    }

    public void drawShape(Graphics g) {
        this.drawShape_.accept(g);
    }

    public PixerFactory getPixerFactory() {
        return this.pixerFact_;
    }

    public void drawLegendShape(Graphics g) {
        if (TablePlot.isVectorContext(g)) {
            this.drawShape(g);
        } else {
            Pixer pixer = this.pixerFact_.createPixer();
            while (pixer.next()) {
                g.fillRect(pixer.getX(), pixer.getY(), 1, 1);
            }
        }
    }

    @Override
    public Icon getLegendIcon() {
        return this.getLegendIcon(20, 12);
    }

    public Icon getLegendIcon(final int width, final int height) {
        return new Icon(){

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color color0 = g.getColor();
                g.setColor(MarkerStyle.this.color_);
                int xoff = x + width / 2;
                int yoff = y + height / 2;
                g.translate(xoff, yoff);
                MarkerStyle.this.drawLegendShape(g);
                g.translate(-xoff, -yoff);
                g.setColor(color0);
            }
        };
    }

    public int hashCode() {
        int code = 668097;
        code = 23 * code + this.shapeId_.hashCode();
        code = 23 * code + this.color_.hashCode();
        code = 23 * code + this.size_;
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof MarkerStyle) {
            MarkerStyle other = (MarkerStyle)o;
            return this.shapeId_.equals(other.shapeId_) && this.color_.equals(other.color_) && this.size_ == other.size_;
        }
        return false;
    }

    private static RenderingHints createPixerRenderingHints() {
        RenderingHints hints = new RenderingHints(null);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        return hints;
    }

    private static Pixer shapeToPixer(Consumer<Graphics> drawShape, int maxr) {
        int xdim = 2 * maxr + 1;
        int ydim = 2 * maxr + 1;
        int xoff = maxr;
        int yoff = maxr;
        BufferedImage im = new BufferedImage(xdim, ydim, 2);
        Graphics2D g = im.createGraphics();
        g.setRenderingHints(PIX_HINTS);
        g.translate(xoff, yoff);
        drawShape.accept(g);
        Raster raster = im.getData();
        ArrayList<Point> pointList = new ArrayList<Point>(xdim * ydim);
        for (int ix = 0; ix < xdim; ++ix) {
            for (int iy = 0; iy < ydim; ++iy) {
                int alpha = raster.getSample(ix, iy, 3);
                if (alpha <= 0) continue;
                assert (alpha == 255) : alpha;
                pointList.add(new Point(ix - xoff, iy - yoff));
            }
        }
        Point[] points = pointList.toArray(new Point[0]);
        return Pixers.createPointsPixer(points);
    }
}

