/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.func.Strings;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.GangContext;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.LegendEntry;
import uk.ac.starlink.ttools.plot2.LegendIcon;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotCaching;
import uk.ac.starlink.ttools.plot2.PlotFrame;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PlotScene;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.ShadeAxisKit;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.CaptionerKeySet;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.LoggingConfigMap;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.CompositorParameter;
import uk.ac.starlink.ttools.plot2.task.ConfigParameter;
import uk.ac.starlink.ttools.plot2.task.ConfigParameterFactory;
import uk.ac.starlink.ttools.plot2.task.CoordValue;
import uk.ac.starlink.ttools.plot2.task.DataStoreParameter;
import uk.ac.starlink.ttools.plot2.task.JELDataSpec;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.LayerTypeParameter;
import uk.ac.starlink.ttools.plot2.task.PaddingParameter;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;
import uk.ac.starlink.ttools.plot2.task.PlotConfiguration;
import uk.ac.starlink.ttools.plot2.task.PlotContext;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;
import uk.ac.starlink.ttools.plot2.task.ShapeFamilyLayerType;
import uk.ac.starlink.ttools.plottask.PaintMode;
import uk.ac.starlink.ttools.plottask.PaintModeParameter;
import uk.ac.starlink.ttools.plottask.Painter;
import uk.ac.starlink.ttools.plottask.SwingPainter;
import uk.ac.starlink.ttools.server.ServerPainter;
import uk.ac.starlink.ttools.task.AddEnvironment;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.DoubleArrayParameter;
import uk.ac.starlink.ttools.task.DynamicTask;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.util.Bi;

public abstract class AbstractPlot2Task
implements Task,
DynamicTask {
    private final boolean allowAnimate_;
    private final boolean hasZoneSuffixes_;
    private final IntegerParameter xpixParam_;
    private final IntegerParameter ypixParam_;
    private final PaddingParameter paddingParam_;
    private final PaintModeParameter painterParam_;
    private final DataStoreParameter dstoreParam_;
    private final StringMultiParameter seqParam_;
    private final BooleanParameter legendParam_;
    private final BooleanParameter legborderParam_;
    private final BooleanParameter legopaqueParam_;
    private final StringMultiParameter legseqParam_;
    private final BooleanParameter bitmapParam_;
    private final Parameter<Compositor> compositorParam_;
    private final InputTableParameter animateParam_;
    private final FilterParameter animateFilterParam_;
    private final IntegerParameter parallelParam_;
    private final Parameter<?>[] basicParams_;
    public static final String LAYER_PREFIX = "layer";
    public static final String ZONE_PREFIX = "zone";
    private static final String TABLE_PREFIX = "in";
    private static final String FILTER_PREFIX = "icmd";
    public static final String DOMAINMAPPER_SUFFIX = "type";
    public static final String EXAMPLE_LAYER_SUFFIX = "N";
    public static final String EXAMPLE_ZONE_SUFFIX = "Z";
    public static final String DOC_ZONE_SUFFIX = "";
    private static final GraphicExporter[] EXPORTERS = GraphicExporter.getKnownExporters(PlotUtil.LATEX_PDF_EXPORTER);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.task");

    protected AbstractPlot2Task(boolean allowAnimate, boolean hasZoneSuffixes) {
        this.allowAnimate_ = allowAnimate;
        this.hasZoneSuffixes_ = hasZoneSuffixes;
        ArrayList<Object> plist = new ArrayList<Object>();
        this.paddingParam_ = new PaddingParameter("insets");
        this.xpixParam_ = new IntegerParameter("xpix");
        this.xpixParam_.setPrompt("Total horizontal size in pixels");
        this.xpixParam_.setDescription(new String[]{"<p>Size of the output image in the X direction in pixels.", "This includes space for any axis labels, padding", "and other decoration outside the plot area itself.", "See also <code>" + this.paddingParam_.getName() + "</code>.", "</p>"});
        this.xpixParam_.setIntDefault(500);
        this.xpixParam_.setMinimum(1);
        plist.add(this.xpixParam_);
        this.ypixParam_ = new IntegerParameter("ypix");
        this.ypixParam_.setPrompt("Total vertical size in pixels");
        this.ypixParam_.setDescription(new String[]{"<p>Size of the output image in the Y direction in pixels.", "This includes space for any axis labels, padding", "and other decoration outside the plot area itself.", "See also <code>" + this.paddingParam_.getName() + "</code>.", "</p>"});
        this.ypixParam_.setIntDefault(400);
        this.ypixParam_.setMinimum(1);
        plist.add(this.ypixParam_);
        this.paddingParam_.setPrompt("Space outside plotting area");
        this.paddingParam_.setDescription(new String[]{"<p>Defines the amount of space in pixels around the", "actual plotting area.", "This space is used for axis labels, and other decorations", "and any left over forms an empty border.", "</p>", "<p>The size and position of the actual plotting area", "is determined by this parameter along with", "<code>" + this.xpixParam_ + "</code> and", "<code>" + this.ypixParam_ + "</code>.", "</p>", "<p>The value of this parameter is 4 comma separated integers:", "<code>&lt;top&gt;,&lt;left&gt;,&lt;bottom&gt;,&lt;right&gt;</code>.", "Any or all of these values may be left blank,", "in which case the corresponding margin will be calculated", "automatically according to how much space is required.", "</p>"});
        plist.add((Object)this.paddingParam_);
        this.painterParam_ = AbstractPlot2Task.createPaintModeParameter();
        plist.add((Object)this.painterParam_);
        this.dstoreParam_ = new DataStoreParameter("storage");
        this.dstoreParam_.setDescription(new String[]{this.dstoreParam_.getDescription(), "<p>The default value is", "<code>" + this.dstoreParam_.getName(this.dstoreParam_.getDefaultForCaching(true)) + "</code>", "if a live plot is being generated", "(<code>" + this.painterParam_.getName() + "=" + this.painterParam_.getName(PaintMode.SWING_MODE) + "</code>),", "since in that case the plot needs to be redrawn every time", "the user performs plot navigation actions or resizes the window,", "or if animations are being produced.", "Otherwise (e.g. output to a graphics file) the default is", "<code>" + this.dstoreParam_.getName(this.dstoreParam_.getDefaultForCaching(false)) + "</code>.", "</p>"});
        plist.add((Object)this.dstoreParam_);
        this.seqParam_ = new StringMultiParameter("seq", ',');
        this.seqParam_.setUsage("<suffix>[,...]");
        this.seqParam_.setPrompt("Order in which to plot layers");
        String osfix = "&lt;N&gt;";
        this.seqParam_.setDescription(new String[]{"<p>Contains a comma-separated list of layer suffixes", "to determine the order in which layers are drawn on the plot.", "This can affect which symbol are plotted on top of,", "and so potentially obscure, which other ones.", "</p>", "<p>When specifying a plot, multiple layers may be specified,", "each introduced by a parameter", "<code>layer" + osfix + "</code>,", "where <code>" + osfix + "</code> is a different (arbitrary)", "suffix labelling the layer,", "and is appended to all the parameters", "specific to defining that layer.", "</p>", "<p>By default the layers are drawn on the plot in the order", "in which the <code>layer*</code> parameters", "appear on the command line.", "However if this parameter is specified, each comma-separated", "element is interpreted as a layer suffix,", "giving the ordered list of layers to plot.", "Every element of the list must be a suffix with a corresponding", "<code>layer</code> parameter,", "but missing or repeated elements are allowed.", "</p>"});
        this.seqParam_.setNullPermitted(true);
        plist.add((Object)this.seqParam_);
        this.legendParam_ = new BooleanParameter("legend");
        this.legendParam_.setPrompt("Show legend?");
        this.legendParam_.setDescription(new String[]{"<p>Whether to draw a legend or not.", "If no value is supplied, the decision is made automatically:", "a legend is drawn only if it would have more than one entry.", "</p>"});
        this.legendParam_.setNullPermitted(true);
        plist.add(this.legendParam_);
        this.legborderParam_ = new BooleanParameter("legborder");
        this.legborderParam_.setPrompt("Border around legend?");
        this.legborderParam_.setDescription(new String[]{"<p>If true, a line border is drawn around the legend.", "</p>"});
        this.legborderParam_.setBooleanDefault(true);
        plist.add(this.legborderParam_);
        this.legopaqueParam_ = new BooleanParameter("legopaque");
        this.legopaqueParam_.setPrompt("Legend background opaque?");
        this.legopaqueParam_.setDescription(new String[]{"<p>If true, the background of the legend is opaque,", "and the legend obscures any plot components behind it.", "Otherwise, it's transparent.", "</p>"});
        this.legopaqueParam_.setBooleanDefault(true);
        plist.add(this.legopaqueParam_);
        this.legseqParam_ = new StringMultiParameter("legseq", ',');
        this.legseqParam_.setUsage("<suffix>[,...]");
        this.legseqParam_.setPrompt("Order in which to add layers to legend");
        this.legseqParam_.setDescription(new String[]{"<p>Determines which layers are represented in the legend", "(if present) and in which order they appear.", "The legend has a line for each layer label", "(as determined by the", "<code>" + AbstractPlot2Task.createLabelParameter(EXAMPLE_LAYER_SUFFIX) + "</code>", "parameter).", "If multiple layers have the same label,", "they will contribute to the same entry in the legend,", "with style icons plotted over each other.", "The value of this parameter is a comma-separated sequence", "of layer suffixes,", "which determines the order in which the legend entries appear.", "Layers with suffixes missing from this list", "do not show up in the legend at all.", "</p>", "<p>If no value is supplied (the default),", "the sequence is the same as the layer plotting sequence", "(see <code>" + this.seqParam_.getName() + "</code>).", "</p>"});
        this.legseqParam_.setNullPermitted(true);
        plist.add((Object)this.legseqParam_);
        plist.add((Object)this.createLegendPositionParameter(DOC_ZONE_SUFFIX));
        plist.add(this.createTitleParameter(DOC_ZONE_SUFFIX));
        plist.addAll(this.getZoneKeyParams(StyleKeys.AUX_RAMP.getKeys()));
        plist.addAll(this.getZoneKeyParams(new ConfigKey[]{StyleKeys.SHADE_LOW, StyleKeys.SHADE_HIGH}));
        plist.add(this.createAuxLabelParameter(DOC_ZONE_SUFFIX));
        plist.add(this.createAuxCrowdParameter(DOC_ZONE_SUFFIX));
        plist.add(this.createAuxWidthParameter(DOC_ZONE_SUFFIX));
        plist.add(this.createAuxVisibleParameter(DOC_ZONE_SUFFIX));
        this.bitmapParam_ = new BooleanParameter("forcebitmap");
        this.bitmapParam_.setPrompt("Force non-vector graphics output?");
        this.bitmapParam_.setDescription(new String[]{"<p>Affects whether rendering of the data contents of a plot", "(though not axis labels etc) is always done to", "an intermediate bitmap rather than, where possible,", "being painted using graphics primitives.", "This is a rather arcane setting that may nevertheless", "have noticeable effects on the appearance and", "size of an output graphics file, as well as plotting time.", "For some types of plot", "(e.g. <code>shadingN=" + ShapeMode.AUTO.getModeName() + "</code>", "or    <code>shadingN=" + ShapeMode.DENSITY.getModeName() + "</code>)", "it will have no effect, since this kind of rendering", "happens in any case.", "</p>", "<p>When writing to vector graphics formats (PDF and PostScript),", "setting it true will force the data contents to be bitmapped.", "This may make the output less beautiful", "(round markers will no longer be perfectly round),", "but it may result in a much smaller file", "if there are very many data points.", "</p>", "<p>When writing to bitmapped output formats", "(PNG, GIF, JPEG, ...),", "it fixes shapes to be the same as seen on the screen", "rather than be rendered at the mercy of the graphics system,", "which sometimes introduces small distortions.", "</p>"});
        this.bitmapParam_.setBooleanDefault(false);
        plist.add(this.bitmapParam_);
        this.compositorParam_ = new CompositorParameter("compositor");
        plist.add(this.compositorParam_);
        if (allowAnimate) {
            this.animateParam_ = new InputTableParameter("animate");
            this.animateParam_.setNullPermitted(true);
            this.animateParam_.setTableDescription("the animation control table");
            this.animateParam_.setDescription(new String[]{"<p>If not null, this parameter causes the command", "to create a sequence of plots instead of just one.", "The parameter value is a table with one row for each", "frame to be produced.", "Columns in the table are interpreted as parameters", "which may take different values for each frame;", "the column name is the parameter name,", "and the value for a given frame is its value from that row.", "Animating like this is considerably more efficient", "than invoking the STILTS command in a loop.", "</p>", this.animateParam_.getDescription()});
            plist.add((Object)this.animateParam_);
            plist.add(this.animateParam_.getFormatParameter());
            plist.add(this.animateParam_.getStreamParameter());
            this.animateFilterParam_ = new FilterParameter("acmd");
            this.animateFilterParam_.setTableDescription("the animation control table", this.animateParam_, Boolean.TRUE);
            plist.add(this.animateFilterParam_);
            this.parallelParam_ = new IntegerParameter("parallel");
            this.parallelParam_.setPrompt("Parallelism for animation frames");
            this.parallelParam_.setDescription(new String[]{"<p>Determines how many threads will run in parallel", "if animation output is being produced.", "Only used if the <code>" + this.animateParam_.getName() + "</code>", "parameter is supplied.", "The default value is the number of processors apparently", "available to the JVM.", "</p>"});
            this.parallelParam_.setMinimum(1);
            this.parallelParam_.setIntDefault(Runtime.getRuntime().availableProcessors());
            plist.add(this.parallelParam_);
        } else {
            this.animateParam_ = null;
            this.animateFilterParam_ = null;
            this.parallelParam_ = null;
        }
        this.basicParams_ = plist.toArray(new Parameter[0]);
    }

    public abstract PlotContext<?, ?> getPlotContext(Environment var1) throws TaskException;

    protected abstract <T> String getConfigParamDefault(Environment var1, ConfigKey<T> var2, String[] var3) throws TaskException;

    public final Parameter<?>[] getBasicParameters() {
        return this.basicParams_;
    }

    public Executable createExecutable(final Environment env) throws TaskException {
        Environment env0;
        Row0Table animateTable;
        final PlotContext<?, ?> context = this.getPlotContext(env);
        final Painter painter = this.painterParam_.painterValue(env);
        final boolean isSwing = painter instanceof SwingPainter;
        final boolean isServer = painter instanceof ServerPainter;
        TableProducer animateProducer = this.allowAnimate_ ? ConsumerTask.createProducer(env, this.animateFilterParam_, this.animateParam_) : null;
        boolean isAnimate = animateProducer != null;
        this.dstoreParam_.setDefaultCaching(isSwing || isServer || isAnimate);
        if (!isAnimate) {
            final PlotConfiguration<?, ?> plotConfig = this.createPlotConfiguration(env, context);
            return new Executable(){

                public void execute() throws IOException {
                    DataStore dataStore;
                    try {
                        dataStore = plotConfig.createDataStore(null);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().isInterrupted();
                        return;
                    }
                    if (isSwing) {
                        PlotCaching caching = PlotCaching.createFullyCached();
                        final PlotDisplay panel = AbstractPlot2Task.createPlotComponent(plotConfig, dataStore, caching);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((SwingPainter)painter).postComponent(panel);
                            }
                        });
                    } else if (isServer) {
                        ((ServerPainter)painter).setPlotConfiguration(plotConfig);
                    } else {
                        Icon plot = plotConfig.createPlotIcon(dataStore);
                        painter.paintPicture(PlotUtil.toPicture(plot));
                    }
                }
            };
        }
        try {
            Row0Table atable;
            animateTable = atable = new Row0Table(animateProducer.getTable());
            ColumnInfo[] infos = Tables.getColumnInfos((StarTable)animateTable);
            long nrow = animateTable.getRowCount();
            Object[] row0 = atable.getRow0();
            env0 = this.createFrameEnvironment(env, infos, row0, 0L, nrow);
        }
        catch (IOException e) {
            throw new ExecutionException("Error reading animation table: " + e, (Throwable)e);
        }
        this.createPlotConfiguration(env0, context);
        if (isSwing) {
            return new Executable((StarTable)animateTable){
                final /* synthetic */ StarTable val$animateTable;
                {
                    this.val$animateTable = starTable;
                }

                public void execute() throws IOException, TaskException {
                    try {
                        AbstractPlot2Task.this.animateSwing(env, context, this.val$animateTable);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().isInterrupted();
                        return;
                    }
                }
            };
        }
        if (isServer) {
            throw new TaskException("Server-side animation is not currently supported");
        }
        String out0 = this.getPainterOutputName(env0);
        int parallel = this.parallelParam_.intValue(env);
        return new Executable((StarTable)animateTable, parallel, out0){
            final /* synthetic */ StarTable val$animateTable;
            final /* synthetic */ int val$parallel;
            final /* synthetic */ String val$out0;
            {
                this.val$animateTable = starTable;
                this.val$parallel = n;
                this.val$out0 = string;
            }

            public void execute() throws IOException, TaskException {
                try {
                    AbstractPlot2Task.this.animateOutput(env, context, this.val$animateTable, this.val$parallel, this.val$out0);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().isInterrupted();
                    return;
                }
            }
        };
    }

    public boolean hasZoneSuffixes() {
        return this.hasZoneSuffixes_;
    }

    public IntegerParameter getXpixParameter() {
        return this.xpixParam_;
    }

    public IntegerParameter getYpixParameter() {
        return this.ypixParam_;
    }

    public Parameter<String[]> getSequenceParameter() {
        return this.seqParam_;
    }

    public Parameter<Boolean> getLegendParameter() {
        return this.legendParam_;
    }

    public Parameter<Boolean> getLegendBorderParameter() {
        return this.legborderParam_;
    }

    public Parameter<Boolean> getLegendOpaqueParameter() {
        return this.legopaqueParam_;
    }

    public Parameter<String[]> getLegendSequenceParameter() {
        return this.legseqParam_;
    }

    public Parameter<Padding> getPaddingParameter() {
        return this.paddingParam_;
    }

    public Parameter<DataStoreFactory> getDataStoreParameter() {
        return this.dstoreParam_;
    }

    public BooleanParameter getBitmapParameter() {
        return this.bitmapParam_;
    }

    public Parameter<Compositor> getCompositorParameter() {
        return this.compositorParam_;
    }

    public ConfigMap createCustomConfigMap(Environment env) throws TaskException {
        return new ConfigMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void animateOutput(Environment baseEnv, PlotContext<?, ?> context, StarTable animateTable, int parallel, String out0) throws TaskException, IOException, InterruptedException {
        ColumnInfo[] infos = Tables.getColumnInfos((StarTable)animateTable);
        long nrow = animateTable.getRowCount();
        int nthr = parallel;
        ThreadPoolExecutor paintService = new ThreadPoolExecutor(nthr, nthr, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(nthr), new ThreadPoolExecutor.CallerRunsPolicy());
        RowSequence aseq = animateTable.getRowSequence();
        DataStore lastDataStore = null;
        String lastOutName = null;
        try {
            long irow = 0L;
            while (aseq.next()) {
                Environment frameEnv = this.createFrameEnvironment(baseEnv, infos, aseq.getRow(), irow, nrow);
                final PlotConfiguration<?, ?> plotConfig = this.createPlotConfiguration(frameEnv, context);
                final Painter painter = this.getPainter(frameEnv);
                final DataStore dstore = plotConfig.createDataStore(lastDataStore);
                final String outName = this.getPainterOutputName(frameEnv);
                paintService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws IOException {
                        long start = System.currentTimeMillis();
                        Icon plot = plotConfig.createPlotIcon(dstore);
                        painter.paintPicture(PlotUtil.toPicture(plot));
                        PlotUtil.logTimeFromStart(logger_, "Plot " + outName, start);
                        return null;
                    }
                });
                lastOutName = outName;
                lastDataStore = dstore;
                ++irow;
            }
        }
        finally {
            aseq.close();
        }
        paintService.shutdown();
        paintService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        logger_.warning("Wrote " + nrow + " frames, " + out0 + " .. " + lastOutName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void animateSwing(Environment baseEnv, PlotContext<?, ?> context, StarTable animateTable) throws TaskException, IOException, InterruptedException {
        final SwingPainter painter = (SwingPainter)AbstractPlot2Task.createPaintModeParameter().painterValue(baseEnv);
        ColumnInfo[] infos = Tables.getColumnInfos((StarTable)animateTable);
        long nrow = animateTable.getRowCount();
        RowSequence aseq = animateTable.getRowSequence();
        final JPanel holder = new JPanel(new BorderLayout());
        PlotCaching caching = PlotCaching.createFullyCached();
        DataStore dataStore = null;
        try {
            long irow = 0L;
            while (aseq.next()) {
                Environment frameEnv = this.createFrameEnvironment(baseEnv, infos, aseq.getRow(), irow, nrow);
                PlotConfiguration<?, ?> plotConfig = this.createPlotConfiguration(frameEnv, context);
                dataStore = plotConfig.createDataStore(dataStore);
                final PlotDisplay<?, ?> panel = AbstractPlot2Task.createPlotComponent(plotConfig, dataStore, caching);
                final boolean init = irow == 0L;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            holder.removeAll();
                            holder.add((Component)panel, "Center");
                            holder.revalidate();
                            holder.repaint();
                            if (init) {
                                painter.postComponent(holder);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    throw new TaskException("Painting error: " + e, (Throwable)e);
                }
                ++irow;
            }
        }
        finally {
            aseq.close();
        }
    }

    private Environment createFrameEnvironment(Environment baseEnv, ColumnInfo[] colInfos, Object[] row, long irow, long nrow) throws IOException, TaskException {
        OutputStreamParameter outParam = this.painterParam_.getOutputParameter();
        boolean hasPaintout = false;
        HashMap<String, String> map = new HashMap<String, String>();
        int ncol = colInfos.length;
        for (int ic = 0; ic < ncol; ++ic) {
            String pname = colInfos[ic].getName();
            hasPaintout = hasPaintout || pname.equals(outParam.getName());
            Object cell = row[ic];
            if (cell == null) continue;
            map.put(pname, cell.toString());
        }
        if (!hasPaintout && !(this.painterParam_.painterValue(baseEnv) instanceof SwingPainter)) {
            String baseOut = outParam.stringValue(baseEnv);
            int numpos = baseOut.lastIndexOf(46);
            if (numpos < 0) {
                numpos = baseOut.length() - 1;
            }
            StringBuffer frameOut = new StringBuffer(baseOut);
            int ndigit = nrow > 0L ? (int)Math.ceil(Math.log10(nrow + 1L)) : 3;
            String snum = "-" + Strings.padWithZeros(irow + 1L, ndigit);
            frameOut.insert(numpos, snum);
            map.put(outParam.getName(), frameOut.toString());
        }
        return AddEnvironment.createAddEnvironment(baseEnv, map);
    }

    public Icon createPlotIcon(Environment env) throws TaskException, IOException, InterruptedException {
        this.dstoreParam_.setDefaultCaching(false);
        PlotConfiguration<?, ?> plotConfig = this.createPlotConfiguration(env, this.getPlotContext(env));
        return plotConfig.createPlotIcon(plotConfig.createDataStore(null));
    }

    public void testEnv(Environment env) throws TaskException {
        this.createPlotConfiguration(env, this.getPlotContext(env));
    }

    public PlotDisplay<?, ?> createPlotComponent(Environment env, boolean caching) throws TaskException, IOException, InterruptedException {
        this.dstoreParam_.setDefaultCaching(caching);
        PlotConfiguration<?, ?> plotConfig = this.createPlotConfiguration(env, this.getPlotContext(env));
        PlotCaching plotCaching = caching ? PlotCaching.createFullyCached() : PlotCaching.createUncached();
        DataStore dataStore = plotConfig.createDataStore(null);
        return AbstractPlot2Task.createPlotComponent(plotConfig, dataStore, plotCaching);
    }

    @Override
    public Parameter<?>[] getContextParameters(Environment env) throws TaskException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.addAll(Arrays.asList(this.getParameters()));
        PlotContext<?, ?> context = this.getPlotContext(env);
        for (Map.Entry<String, LayerType> entry : AbstractPlot2Task.getLayers(env, context).entrySet()) {
            String suffix = entry.getKey();
            LayerType layer = entry.getValue();
            LayerTypeParameter layerParam = AbstractPlot2Task.createLayerTypeParameter(suffix, context);
            layerParam.setUsage(layerParam.stringifyOption(layer));
            paramList.add(layerParam);
            for (ParameterFinder<Parameter<?>> finder : this.getLayerParameterFinders(env, context, layer, suffix)) {
                paramList.add(finder.createParameter(suffix));
            }
        }
        return paramList.toArray(new Parameter[0]);
    }

    @Override
    public Parameter<?> getParameterByName(Environment env, String paramName) throws TaskException {
        PlotContext<?, ?> context = this.getPlotContext(env);
        if (paramName.toLowerCase().startsWith(LAYER_PREFIX.toLowerCase())) {
            String suffix = paramName.substring(LAYER_PREFIX.length());
            return AbstractPlot2Task.createLayerTypeParameter(suffix, context);
        }
        for (Map.Entry<String, LayerType> entry : AbstractPlot2Task.getLayers(env, context).entrySet()) {
            String suffix = entry.getKey();
            LayerType layer = entry.getValue();
            for (ParameterFinder<Parameter<?>> finder : this.getLayerParameterFinders(env, context, layer, suffix)) {
                Parameter<?> p = finder.findParameterByName(paramName, suffix);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    private List<ParameterFinder<Parameter<?>>> getLayerParameterFinders(Environment env, final PlotContext<?, ?> context, final LayerType layer, String suffix) throws TaskException {
        ConfigKey<?>[] styleKeys;
        ArrayList finderList = new ArrayList();
        int nassoc = layer.getAssociatedParameters("dummy").length;
        int ia = 0;
        while (ia < nassoc) {
            final int iassoc = ia++;
            finderList.add(new ParameterFinder<Parameter<?>>(){

                @Override
                public Parameter<?> createParameter(String sfix) {
                    return layer.getAssociatedParameters(sfix)[iassoc];
                }
            });
        }
        int npos = layer.getCoordGroup().getBasicPositionCount();
        DataGeom geom = context.getGeom(env, suffix);
        Coord[] posCoords = geom.getPosCoords();
        for (int ipos = 0; ipos < npos; ++ipos) {
            final String posSuffix = npos > 1 ? PlotUtil.getIndexSuffix(ipos) : DOC_ZONE_SUFFIX;
            for (Coord coord : posCoords) {
                for (final Input input : coord.getInputs()) {
                    finderList.add(new ParameterFinder<Parameter<?>>(){

                        @Override
                        public Parameter<?> createParameter(String sfix) {
                            return AbstractPlot2Task.createDataParameter(input, posSuffix + sfix, true);
                        }
                    });
                    if (!AbstractPlot2Task.hasDomainMappers(input)) continue;
                    finderList.add(new ParameterFinder<Parameter<?>>(){

                        @Override
                        public Parameter<?> createParameter(String sfix) {
                            return AbstractPlot2Task.createDomainMapperParameter(input, posSuffix + sfix);
                        }
                    });
                }
            }
        }
        Parameter<?> geomParam = context.getGeomParameter(suffix);
        if (geomParam != null) {
            finderList.add(new ParameterFinder<Parameter<?>>(){

                @Override
                public Parameter<?> createParameter(String sfix) {
                    return context.getGeomParameter(sfix);
                }
            });
        }
        Coord[] extraCoords = layer.getExtraCoords();
        for (Coord coord : extraCoords) {
            for (final Input input : coord.getInputs()) {
                finderList.add(new ParameterFinder<Parameter<?>>(){

                    @Override
                    public Parameter<?> createParameter(String sfix) {
                        return AbstractPlot2Task.createDataParameter(input, sfix, true);
                    }
                });
                if (!AbstractPlot2Task.hasDomainMappers(input)) continue;
                finderList.add(new ParameterFinder<Parameter<?>>(){

                    @Override
                    public Parameter<?> createParameter(String sfix) {
                        return AbstractPlot2Task.createDomainMapperParameter(input, sfix);
                    }
                });
            }
        }
        for (final ConfigKey<?> configKey : styleKeys = layer.getStyleKeys()) {
            finderList.add(new ParameterFinder<Parameter<?>>(){

                @Override
                public Parameter<?> createParameter(String sfix) {
                    return ConfigParameter.createLayerSuffixedParameter(configKey, sfix, true);
                }
            });
        }
        if (layer instanceof ShapeFamilyLayerType) {
            ConfigKey<?>[] configKeyArray;
            Coord[] shadeCoords;
            final ShapeFamilyLayerType shadeLayer = (ShapeFamilyLayerType)layer;
            ShapeMode shapeMode = (ShapeMode)new ParameterFinder<Parameter<ShapeMode>>(){

                @Override
                public Parameter<ShapeMode> createParameter(String sfix) {
                    return shadeLayer.createShapeModeParameter(sfix);
                }
            }.getParameter(env, suffix).objectValue(env);
            for (Coord coord : shadeCoords = shapeMode.getExtraCoords()) {
                for (final Input input : coord.getInputs()) {
                    finderList.add(new ParameterFinder<Parameter<?>>(){

                        @Override
                        public Parameter<?> createParameter(String sfix) {
                            return AbstractPlot2Task.createDataParameter(input, sfix, true);
                        }
                    });
                }
            }
            for (final ConfigKey<?> key : configKeyArray = shapeMode.getConfigKeys()) {
                finderList.add(new ParameterFinder<Parameter<?>>(){

                    @Override
                    public Parameter<?> createParameter(String sfix) {
                        return ConfigParameter.createLayerSuffixedParameter(key, sfix, true);
                    }
                });
            }
        }
        return finderList;
    }

    private Painter getPainter(Environment env) throws TaskException {
        PaintModeParameter paintModeParam = AbstractPlot2Task.createPaintModeParameter();
        env.acquireValue((Parameter)paintModeParam.getOutputParameter());
        return paintModeParam.painterValue(env);
    }

    private String getPainterOutputName(Environment env) throws TaskException {
        OutputStreamParameter outParam = AbstractPlot2Task.createPaintModeParameter().getOutputParameter();
        env.acquireValue((Parameter)outParam);
        return outParam.stringValue(env);
    }

    protected <P, A> PlotConfiguration<P, A> createPlotConfiguration(Environment env, PlotContext<P, A> context) throws TaskException {
        Plotter[] plotters;
        GangContext gangContext;
        ConfigMap gangConfig;
        String[] legendSeq;
        PlotType<P, A> plotType = context.getPlotType();
        final SurfaceFactory<P, A> surfFact = plotType.getSurfaceFactory();
        final PaperTypeSelector ptSel = plotType.getPaperTypeSelector();
        GangerFactory<P, A> gangerFact = plotType.getGangerFactory();
        final int xpix = this.xpixParam_.intValue(env);
        final int ypix = this.ypixParam_.intValue(env);
        final boolean forceBitmap = this.bitmapParam_.booleanValue(env);
        final DataStoreFactory storeFact = (DataStoreFactory)this.dstoreParam_.objectValue(env);
        final Compositor compositor = (Compositor)this.compositorParam_.objectValue(env);
        Map<String, PlotLayer> layerMap = this.createLayerMap(env, context);
        String[] layerSeq = this.seqParam_.stringsValue(env);
        if (layerSeq.length == 0) {
            layerSeq = layerMap.keySet().toArray(new String[0]);
        }
        if ((legendSeq = this.legseqParam_.stringsValue(env)).length == 0) {
            legendSeq = layerSeq;
        }
        PlotLayer[] layers = this.getLayerSequence(layerMap, layerSeq);
        int nl = layers.length;
        final DataSpec[] dataSpecs = new DataSpec[nl];
        for (int il = 0; il < nl; ++il) {
            dataSpecs[il] = layers[il] == null ? null : layers[il].getDataSpec();
        }
        ConfigKey<?>[] profileKeys = surfFact.getProfileKeys();
        ConfigKey<?>[] aspectKeys = surfFact.getAspectKeys();
        ConfigKey[] shadeKeys = new ConfigKey[]{StyleKeys.SHADE_LOW, StyleKeys.SHADE_HIGH};
        final ConfigMap navConfig = AbstractPlot2Task.createBasicConfigMap(env, surfFact.getNavigatorKeys());
        Map<String, String[]> zoneSuffixMap = this.getZoneSuffixMap(env, layerSeq);
        String[] zoneSuffixes = zoneSuffixMap.keySet().toArray(new String[0]);
        Padding padding = (Padding)this.paddingParam_.objectValue(env);
        final Ganger<P, A> ganger = gangerFact.createGanger(padding, gangConfig = AbstractPlot2Task.createBasicConfigMap(env, gangerFact.getGangerKeys()), gangContext = new GangContext(plotters = (Plotter[])Arrays.stream(layers).map(PlotLayer::getPlotter).toArray(Plotter[]::new), zoneSuffixes){
            final /* synthetic */ Plotter[] val$plotters;
            final /* synthetic */ String[] val$zoneSuffixes;
            {
                this.val$plotters = plotterArray;
                this.val$zoneSuffixes = stringArray;
            }

            @Override
            public Plotter<?>[] getPlotters() {
                return this.val$plotters;
            }

            @Override
            public String[] getRequestedZoneNames() {
                return this.val$zoneSuffixes;
            }
        });
        if (ganger.getZoneCount() > 1 && ganger.isTrimmingGlobal() || ganger.isShadingGlobal()) {
            throw new IllegalStateException("Can't cope with this ganger");
        }
        final int nz = zoneSuffixes.length;
        final PlotLayer[][] layerArrays = new PlotLayer[nz][];
        P[] initialProfiles = PlotUtil.createProfileArray(surfFact, nz);
        final Trimming[] trimmings = new Trimming[nz];
        final ConfigMap[] aspectConfigs = new ConfigMap[nz];
        final ShadeAxisKit[] shadeKits = new ShadeAxisKit[nz];
        for (int iz = 0; iz < nz; ++iz) {
            String zoneSuffix = zoneSuffixes[iz];
            String[] zoneLayerSuffixes = zoneSuffixMap.get(zoneSuffix);
            int nzl = zoneLayerSuffixes.length;
            PlotLayer[] zoneLayers = new PlotLayer[nzl];
            for (int il = 0; il < nzl; ++il) {
                zoneLayers[il] = layerMap.get(zoneLayerSuffixes[il]);
            }
            ArrayList<String> zoneLegendList = new ArrayList<String>();
            for (String l : legendSeq) {
                if (!Arrays.asList(zoneLayerSuffixes).contains(l)) continue;
                zoneLegendList.add(l);
            }
            Icon legend = this.createLegend(env, layerMap, zoneSuffix, zoneLegendList.toArray(new String[0]));
            ConfigMap profileConfig = this.createZoneConfigMap(env, profileKeys, zoneSuffix, zoneLayerSuffixes);
            P profile = surfFact.createProfile(profileConfig);
            ConfigMap aspectConfig = AbstractPlot2Task.createZoneSuffixedConfigMap(env, aspectKeys, zoneSuffix);
            ConfigMap shadeConfig = AbstractPlot2Task.createZoneSuffixedConfigMap(env, shadeKeys, zoneSuffix);
            Span shadeFixSpan = PlotUtil.createSpan(shadeConfig.get(StyleKeys.SHADE_LOW), shadeConfig.get(StyleKeys.SHADE_HIGH));
            ShadeAxisFactory shadeFact = this.createShadeAxisFactory(env, zoneLayers, zoneSuffix);
            Subrange shadeSubrange = null;
            ShadeAxisKit shadeKit = new ShadeAxisKit(shadeFact, shadeFixSpan, shadeSubrange);
            float[] legPos = legend == null ? null : ((DoubleArrayParameter)((Object)new ParameterFinder<DoubleArrayParameter>(){

                @Override
                public DoubleArrayParameter createParameter(String sfix) {
                    return AbstractPlot2Task.this.createLegendPositionParameter(sfix);
                }
            }.getParameter(env, zoneSuffix))).floatsValue(env);
            String title = new ParameterFinder<Parameter<String>>(){

                @Override
                public Parameter<String> createParameter(String sfix) {
                    return AbstractPlot2Task.this.createTitleParameter(sfix);
                }
            }.getParameter(env, zoneSuffix).stringValue(env);
            layerArrays[iz] = zoneLayers;
            initialProfiles[iz] = profile;
            aspectConfigs[iz] = aspectConfig;
            trimmings[iz] = new Trimming(legend, legPos, title);
            shadeKits[iz] = shadeKit;
        }
        final Object[] profiles = ganger.adjustProfiles(initialProfiles);
        return new PlotConfiguration<P, A>(){

            @Override
            public DataStore createDataStore(DataStore prevStore) throws IOException, InterruptedException {
                long t0 = System.currentTimeMillis();
                DataStore store = storeFact.readDataStore(dataSpecs, prevStore);
                PlotUtil.logTimeFromStart(logger_, "Data", t0);
                return store;
            }

            @Override
            public Dimension getPlotSize() {
                return new Dimension(xpix, ypix);
            }

            @Override
            public Navigator<A> createNavigator() {
                return surfFact.createNavigator(navConfig);
            }

            @Override
            public PlotScene<P, A> createPlotScene(DataStore dataStore, PlotCaching caching) {
                return PlotScene.createGangScene(ganger, surfFact, layerArrays, profiles, aspectConfigs, trimmings, shadeKits, ptSel, compositor, dataStore, caching);
            }

            @Override
            public Icon createPlotIcon(DataStore dataStore) {
                ZoneContent<P, A>[] contents = PlotUtil.createZoneContentArray(surfFact, nz);
                long t0 = System.currentTimeMillis();
                for (int iz = 0; iz < nz; ++iz) {
                    Object profile = profiles[iz];
                    ConfigMap config = aspectConfigs[iz];
                    PlotLayer[] layers = layerArrays[iz];
                    Range[] ranges = surfFact.useRanges(profile, config) ? surfFact.readRanges(profile, layers, dataStore) : null;
                    Object aspect = surfFact.createAspect(profile, config, ranges);
                    contents[iz] = new ZoneContent(profile, aspect, layers);
                }
                return AbstractPlot2Task.createPlotIcon(ganger, surfFact, contents, trimmings, shadeKits, ptSel, compositor, dataStore, xpix, ypix, forceBitmap);
            }
        };
    }

    private Map<String, PlotLayer> createLayerMap(Environment env, PlotContext<?, ?> context) throws TaskException {
        Map<String, Plotter<?>> plotterMap = AbstractPlot2Task.getPlotters(env, context);
        LinkedHashMap<String, PlotLayer> layerMap = new LinkedHashMap<String, PlotLayer>();
        for (Map.Entry<String, Plotter<?>> entry : plotterMap.entrySet()) {
            String suffix = entry.getKey();
            Plotter<?> plotter = entry.getValue();
            CoordGroup cgrp = plotter.getCoordGroup();
            DataGeom geom = cgrp.getBasicPositionCount() + cgrp.getExtraPositionCount() > 0 ? context.getGeom(env, suffix) : null;
            PlotLayer layer = this.createPlotLayer(env, suffix, plotter, context, geom);
            layerMap.put(suffix, layer);
        }
        return layerMap;
    }

    private PlotLayer[] getLayerSequence(Map<String, PlotLayer> layerMap, String[] suffixSeq) throws TaskException {
        int nl = suffixSeq.length;
        PlotLayer[] layers = new PlotLayer[nl];
        for (int il = 0; il < nl; ++il) {
            String suffix = suffixSeq[il];
            PlotLayer layer = layerMap.get(suffix);
            if (layer == null) {
                if (layerMap.containsKey(suffix)) {
                    String msg = "No plot produced for layer \"" + suffix + "\" (underspecified?)";
                    throw new ExecutionException(msg);
                }
                String msg = new StringBuffer().append("No specification for layer \"").append(suffix).append("\"").append("; known layers: ").append(layerMap.keySet()).toString();
                throw new ParameterValueException((Parameter)this.seqParam_, msg);
            }
            layers[il] = layerMap.get(suffix);
        }
        return layers;
    }

    private Map<String, String[]> getZoneSuffixMap(Environment env, String[] layerSuffixes) throws TaskException {
        if (!this.hasZoneSuffixes_ || layerSuffixes.length == 0) {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(DOC_ZONE_SUFFIX, layerSuffixes);
            return map;
        }
        LinkedHashMap zoneMap = new LinkedHashMap();
        for (String layerSuffix : layerSuffixes) {
            String zoneSuffix = AbstractPlot2Task.getZoneSuffix(env, layerSuffix);
            if (!zoneMap.containsKey(zoneSuffix)) {
                zoneMap.put(zoneSuffix, new ArrayList());
            }
            ((List)zoneMap.get(zoneSuffix)).add(layerSuffix);
        }
        LinkedHashMap<String, String[]> zmap = new LinkedHashMap<String, String[]>();
        for (Map.Entry entry : zoneMap.entrySet()) {
            zmap.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        return zmap;
    }

    public Icon createLegend(Environment env, Map<String, PlotLayer> layerMap, String zoneSuffix, String[] layerSuffixSeq) throws TaskException {
        boolean hasLegend;
        LinkedHashMap<List<SubCloud>, String> cloudMap = new LinkedHashMap<List<SubCloud>, String>();
        LinkedHashMap labelMap = new LinkedHashMap();
        for (String suffix : layerSuffixSeq) {
            PlotLayer layer = layerMap.get(suffix);
            if (layer == null) {
                String msg = new StringBuffer().append("No specification for layer \"").append(suffix).append("\"").append("; known layers: ").append(layerMap.keySet()).toString();
                throw new ParameterValueException((Parameter)this.legseqParam_, msg);
            }
            String label = (String)new ParameterFinder<Parameter<String>>(){

                @Override
                public Parameter<String> createParameter(String sfix) {
                    return AbstractPlot2Task.createLabelParameter(sfix);
                }
            }.getParameter(env, suffix).objectValue(env);
            if (label == null) {
                List<SubCloud> dataClouds = AbstractPlot2Task.getPointClouds(layer);
                if (!cloudMap.containsKey(dataClouds)) {
                    String suffixLabel = suffix.length() == 0 ? "data" : suffix;
                    cloudMap.put(dataClouds, suffixLabel);
                }
                label = (String)cloudMap.get(dataClouds);
            }
            if (!labelMap.containsKey(label)) {
                labelMap.put(label, new ArrayList());
            }
            ((List)labelMap.get(label)).add(layer.getStyle());
        }
        ArrayList<LegendEntry> entryList = new ArrayList<LegendEntry>();
        for (Map.Entry entry : labelMap.entrySet()) {
            String label = (String)entry.getKey();
            Style[] styles = ((List)entry.getValue()).toArray(new Style[0]);
            entryList.add(new LegendEntry(label, styles));
        }
        LegendEntry[] legEntries = entryList.toArray(new LegendEntry[0]);
        Boolean hasLegObj = (Boolean)this.legendParam_.objectValue(env);
        boolean bl = hasLegObj == null ? legEntries.length > 1 : (hasLegend = hasLegObj.booleanValue());
        if (hasLegend) {
            Captioner captioner = this.createCaptioner(env, zoneSuffix);
            boolean hasBorder = this.legborderParam_.booleanValue(env);
            boolean isOpaque = this.legopaqueParam_.booleanValue(env);
            Color bgColor = isOpaque ? Color.WHITE : null;
            return new LegendIcon(legEntries, captioner, hasBorder, bgColor);
        }
        return null;
    }

    private static List<SubCloud> getPointClouds(PlotLayer layer) {
        int iposCoord;
        int ipos;
        DataSpec dataSpec = layer.getDataSpec();
        DataGeom geom = layer.getDataGeom();
        CoordGroup cgrp = layer.getPlotter().getCoordGroup();
        ArrayList<SubCloud> cloudList = new ArrayList<SubCloud>();
        for (ipos = 0; ipos < cgrp.getBasicPositionCount(); ++ipos) {
            iposCoord = cgrp.getPosCoordIndex(ipos, geom);
            cloudList.add(new SubCloud(geom, dataSpec, iposCoord));
        }
        for (ipos = 0; ipos < cgrp.getExtraPositionCount(); ++ipos) {
            iposCoord = cgrp.getExtraCoordIndex(ipos, geom);
            cloudList.add(new SubCloud(geom, dataSpec, iposCoord));
        }
        return cloudList;
    }

    private static String getZoneSuffix(Environment env, String layerSuffix) throws TaskException {
        String zoneSuffix = (String)new ParameterFinder<Parameter<String>>(){

            @Override
            public Parameter<String> createParameter(String sfix) {
                return AbstractPlot2Task.createZoneParameter(sfix);
            }
        }.getParameter(env, layerSuffix).objectValue(env);
        return zoneSuffix == null ? DOC_ZONE_SUFFIX : zoneSuffix;
    }

    private static Map<String, LayerType> getLayers(Environment env, PlotContext<?, ?> context) throws TaskException {
        String prefix = LAYER_PREFIX;
        LinkedHashMap<String, LayerType> map = new LinkedHashMap<String, LayerType>();
        for (String pname : env.getNames()) {
            if (pname == null || !pname.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            String suffix = pname.substring(prefix.length());
            LayerType ltype = (LayerType)AbstractPlot2Task.createLayerTypeParameter(suffix, context).objectValue(env);
            map.put(suffix, ltype);
        }
        return map;
    }

    private static <P, A> PlotDisplay<P, A> createPlotComponent(PlotConfiguration<P, A> plotConfig, DataStore dataStore, PlotCaching caching) {
        PlotScene<P, A> scene = plotConfig.createPlotScene(dataStore, caching);
        Navigator<A> navigator = plotConfig.createNavigator();
        PlotDisplay<P, A> panel = new PlotDisplay<P, A>(scene, navigator, dataStore);
        panel.setPreferredSize(plotConfig.getPlotSize());
        return panel;
    }

    public static Map<String, Plotter<?>> getPlotters(Environment env, PlotContext<?, ?> context) throws TaskException {
        LinkedHashMap plotterMap = new LinkedHashMap();
        for (Map.Entry<String, LayerType> entry : AbstractPlot2Task.getLayers(env, context).entrySet()) {
            String suffix = entry.getKey();
            LayerType ltype = entry.getValue();
            plotterMap.put(suffix, ltype.getPlotter(env, suffix));
        }
        return plotterMap;
    }

    public Captioner createCaptioner(Environment env, String zoneSuffix) throws TaskException {
        CaptionerKeySet capKeys = StyleKeys.CAPTIONER;
        ConfigMap capConfig = this.createZoneConfigMap(env, capKeys.getKeys(), zoneSuffix, new String[0]);
        return (Captioner)capKeys.createValue(capConfig);
    }

    public ShadeAxisFactory createShadeAxisFactory(Environment env, PlotLayer[] layers, String zoneSuffix) throws TaskException {
        boolean hasAux;
        AuxScale scale = AuxScale.COLOR;
        PlotLayer scaleLayer = AbstractPlot2Task.getFirstAuxLayer(layers, scale);
        Boolean auxvis = (Boolean)((BooleanParameter)new ParameterFinder<BooleanParameter>(){

            @Override
            public BooleanParameter createParameter(String sfix) {
                return AbstractPlot2Task.this.createAuxVisibleParameter(sfix);
            }
        }.getParameter(env, zoneSuffix)).objectValue(env);
        boolean bl = auxvis == null ? scaleLayer != null : (hasAux = auxvis.booleanValue());
        if (!hasAux) {
            return null;
        }
        StringParameter auxlabelParam = (StringParameter)new ParameterFinder<StringParameter>(){

            @Override
            public StringParameter createParameter(String sfix) {
                return AbstractPlot2Task.this.createAuxLabelParameter(sfix);
            }
        }.getParameter(env, zoneSuffix);
        if (scaleLayer != null) {
            auxlabelParam.setStringDefault(PlotUtil.getScaleAxisLabel(layers, scale));
        }
        String label = (String)auxlabelParam.objectValue(env);
        double crowd = ((DoubleParameter)new ParameterFinder<DoubleParameter>(){

            @Override
            public DoubleParameter createParameter(String sfix) {
                return AbstractPlot2Task.this.createAuxCrowdParameter(sfix);
            }
        }.getParameter(env, zoneSuffix)).doubleValue(env);
        int rampWidth = ((IntegerParameter)new ParameterFinder<IntegerParameter>(){

            @Override
            public IntegerParameter createParameter(String sfix) {
                return AbstractPlot2Task.this.createAuxWidthParameter(sfix);
            }
        }.getParameter(env, zoneSuffix)).intValue(env);
        RampKeySet rampKeys = StyleKeys.AUX_RAMP;
        Captioner captioner = this.createCaptioner(env, zoneSuffix);
        ConfigMap auxConfig = AbstractPlot2Task.createZoneSuffixedConfigMap(env, rampKeys.getKeys(), zoneSuffix);
        RampKeySet.Ramp ramp = rampKeys.createValue(auxConfig);
        return RampKeySet.createShadeAxisFactory(ramp, captioner, label, crowd, rampWidth);
    }

    public static ConfigMap createBasicConfigMap(Environment env, ConfigKey<?>[] keys) throws TaskException {
        ConfigParameterFactory cpFact = new ConfigParameterFactory(){

            @Override
            public <T> ConfigParameter<T> getParameter(Environment env, ConfigKey<T> key) {
                return new ConfigParameter<T>(key);
            }
        };
        return AbstractPlot2Task.createConfigMap(env, keys, cpFact);
    }

    private <S extends Style> PlotLayer createPlotLayer(Environment env, String suffix, Plotter<S> plotter, PlotContext<?, ?> context, DataGeom geom) throws TaskException {
        S style;
        CoordGroup cgrp = plotter.getCoordGroup();
        DataSpec dataSpec = this.createDataSpec(env, suffix, geom, cgrp.getBasicPositionCount(), cgrp.getExtraCoords());
        ConfigMap profileConfig = AbstractPlot2Task.createBasicConfigMap(env, context.getPlotType().getSurfaceFactory().getProfileKeys());
        ConfigMap captionConfig = AbstractPlot2Task.createBasicConfigMap(env, StyleKeys.CAPTIONER.getKeys());
        ConfigMap layerConfig = AbstractPlot2Task.createLayerSuffixedConfigMap(env, plotter.getStyleKeys(), suffix);
        ConfigMap auxConfig = AbstractPlot2Task.createZoneSuffixedConfigMap(env, StyleKeys.AUX_RAMP.getKeys(), AbstractPlot2Task.getZoneSuffix(env, suffix));
        ConfigMap otherConfig = this.createCustomConfigMap(env);
        ConfigMap config = new ConfigMap();
        config.putAll(profileConfig);
        config.putAll(captionConfig);
        config.putAll(auxConfig);
        config.putAll(layerConfig);
        config.putAll(otherConfig);
        try {
            style = plotter.createStyle(config);
            assert (style.equals(plotter.createStyle(config)));
        }
        catch (ConfigException e) {
            throw new UsageException(e.getConfigKey().getMeta().getShortName() + ": " + e.getMessage(), (Throwable)e);
        }
        return plotter.createLayer(geom, dataSpec, style);
    }

    private DataSpec createDataSpec(Environment env, String suffix, DataGeom geom, int npos, Coord[] extraCoords) throws TaskException {
        if (npos == 0 && extraCoords.length == 0) {
            return null;
        }
        StarTable table = AbstractPlot2Task.getInputTable(env, suffix);
        ArrayList<CoordValue> cvlist = new ArrayList<CoordValue>();
        Coord[] posCoords = geom == null ? new Coord[]{} : geom.getPosCoords();
        for (int ipos = 0; ipos < npos; ++ipos) {
            String posSuffix = npos > 1 ? PlotUtil.getIndexSuffix(ipos) : DOC_ZONE_SUFFIX;
            for (int ic = 0; ic < posCoords.length; ++ic) {
                cvlist.add(AbstractPlot2Task.getCoordValue(env, posCoords[ic], posSuffix + suffix));
            }
        }
        for (int ic = 0; ic < extraCoords.length; ++ic) {
            cvlist.add(AbstractPlot2Task.getCoordValue(env, extraCoords[ic], suffix));
        }
        CoordValue[] coordVals = cvlist.toArray(new CoordValue[0]);
        return new JELDataSpec(table, null, coordVals);
    }

    public static CoordValue getCoordValue(Environment env, Coord coord, String suffix) throws TaskException {
        Input[] inputs = coord.getInputs();
        int ni = inputs.length;
        String[] exprs = new String[ni];
        DomainMapper[] dms = new DomainMapper[ni];
        for (int ii = 0; ii < ni; ++ii) {
            DomainMapper dm;
            final Input input = inputs[ii];
            Object exprParam = new ParameterFinder<Parameter<String>>(){

                @Override
                public Parameter<String> createParameter(String sfix) {
                    return AbstractPlot2Task.createDataParameter(input, sfix, true);
                }
            }.getParameter(env, suffix);
            exprParam.setNullPermitted(!coord.isRequired());
            exprs[ii] = exprParam.stringValue(env);
            if (AbstractPlot2Task.hasDomainMappers(input)) {
                Object mapperParam = new ParameterFinder<Parameter<DomainMapper>>(){

                    @Override
                    public Parameter<DomainMapper> createParameter(String sfix) {
                        return AbstractPlot2Task.createDomainMapperParameter(input, sfix);
                    }
                }.getParameter(env, suffix);
                dm = (DomainMapper)mapperParam.objectValue(env);
            } else {
                dm = null;
            }
            dms[ii] = dm;
        }
        return new CoordValue(coord, exprs, dms);
    }

    public static ConfigMap createLayerSuffixedConfigMap(Environment env, ConfigKey<?>[] configKeys, String layerSuffix) throws TaskException {
        return AbstractPlot2Task.createSuffixedConfigMap(env, configKeys, layerSuffix, false);
    }

    private static ConfigMap createZoneSuffixedConfigMap(Environment env, ConfigKey<?>[] configKeys, String zoneSuffix) throws TaskException {
        return AbstractPlot2Task.createSuffixedConfigMap(env, configKeys, zoneSuffix, true);
    }

    private static ConfigMap createSuffixedConfigMap(Environment env, ConfigKey<?>[] configKeys, final String suffix, final boolean isZone) throws TaskException {
        ConfigParameterFactory cpFact = new ConfigParameterFactory(){

            @Override
            public <T> ConfigParameter<T> getParameter(Environment env, final ConfigKey<T> key) {
                return (ConfigParameter)((Object)new ParameterFinder<ConfigParameter<T>>(){

                    @Override
                    public ConfigParameter<T> createParameter(String sfix) {
                        return isZone ? ConfigParameter.createZoneSuffixedParameter(key, sfix, true) : ConfigParameter.createLayerSuffixedParameter(key, sfix, true);
                    }
                }.getParameter(env, suffix));
            }
        };
        return AbstractPlot2Task.createConfigMap(env, configKeys, cpFact);
    }

    private ConfigMap createZoneConfigMap(Environment env, ConfigKey<?>[] zoneConfigKeys, final String zoneSuffix, final String[] zoneLayerSuffixes) throws TaskException {
        ConfigParameterFactory cpFact = new ConfigParameterFactory(){

            @Override
            public <T> ConfigParameter<T> getParameter(Environment env, final ConfigKey<T> key) throws TaskException {
                ConfigParameter param = (ConfigParameter)((Object)new ParameterFinder<ConfigParameter<T>>(){

                    @Override
                    public ConfigParameter<T> createParameter(String sfix) {
                        return ConfigParameter.createZoneSuffixedParameter(key, sfix, true);
                    }
                }.getParameter(env, zoneSuffix));
                String dflt = AbstractPlot2Task.this.getConfigParamDefault(env, key, zoneLayerSuffixes);
                if (dflt != null) {
                    param.setStringDefault(dflt);
                }
                return param;
            }
        };
        return AbstractPlot2Task.createConfigMap(env, zoneConfigKeys, cpFact);
    }

    public static ConfigMap createConfigMap(Environment env, ConfigKey<?>[] configKeys, ConfigParameterFactory cpFact) throws TaskException {
        Level level = Level.CONFIG;
        ConfigMap config = new ConfigMap();
        if (Logger.getLogger(AbstractPlot2Task.class.getName()).isLoggable(level)) {
            config = new LoggingConfigMap(config, level);
        }
        for (ConfigKey<?> key : configKeys) {
            AbstractPlot2Task.putConfigValue(env, key, cpFact, config);
        }
        return config;
    }

    private static <T> void putConfigValue(Environment env, ConfigKey<T> key, ConfigParameterFactory cpFact, ConfigMap map) throws TaskException {
        ConfigParameter<T> param = cpFact.getParameter(env, key);
        Object value = param.objectValue(env);
        if (key.getValueClass().equals(Double.class) && value == null) {
            value = key.cast(Double.NaN);
        }
        map.put(key, value);
    }

    public static StarTable getInputTable(Environment env, String suffix) throws TaskException {
        final InputFormatParameter fmtParam = (InputFormatParameter)new ParameterFinder<InputFormatParameter>(){

            @Override
            public InputFormatParameter createParameter(String sfix) {
                return AbstractPlot2Task.createTableParameter(sfix).getFormatParameter();
            }
        }.getParameter(env, suffix);
        final BooleanParameter streamParam = (BooleanParameter)new ParameterFinder<BooleanParameter>(){

            @Override
            public BooleanParameter createParameter(String sfix) {
                return AbstractPlot2Task.createTableParameter(sfix).getStreamParameter();
            }
        }.getParameter(env, suffix);
        InputTableParameter tableParam = (InputTableParameter)((Object)new ParameterFinder<InputTableParameter>(){

            @Override
            public InputTableParameter createParameter(String sfix) {
                return new InputTableParameter(AbstractPlot2Task.createTableParameter(sfix).getName()){

                    @Override
                    public InputFormatParameter getFormatParameter() {
                        return fmtParam;
                    }

                    @Override
                    public BooleanParameter getStreamParameter() {
                        return streamParam;
                    }
                };
            }
        }.getParameter(env, suffix));
        FilterParameter filterParam = (FilterParameter)new ParameterFinder<FilterParameter>(){

            @Override
            public FilterParameter createParameter(String sfix) {
                return AbstractPlot2Task.createFilterParameter(sfix, null);
            }
        }.getParameter(env, suffix);
        TableProducer producer = ConsumerTask.createProducer(env, filterParam, tableParam);
        try {
            return producer.getTable();
        }
        catch (IOException e) {
            throw new ExecutionException("Table processing error", (Throwable)e);
        }
    }

    public static InputTableParameter createTableParameter(String suffix) {
        return new InputTableParameter(TABLE_PREFIX + suffix);
    }

    public static FilterParameter createFilterParameter(String suffix, InputTableParameter tableParam) {
        FilterParameter param = new FilterParameter(FILTER_PREFIX + suffix);
        param.setTableDescription("the layer " + suffix + " input table", tableParam, null);
        return param;
    }

    public static Parameter<String> createLabelParameter(String suffix) {
        StringParameter param = new StringParameter("leglabel" + suffix);
        param.setUsage("<text>");
        param.setPrompt("Legend label for layer " + suffix);
        param.setDescription(new String[]{"<p>Sets the presentation label for the layer with a given suffix.", "This is the text which is displayed in the legend, if present.", "Multiple layers may use the same label, in which case", "they will be combined to form a single legend entry.", "</p>", "<p>If no value is supplied (the default),", "the suffix itself is used as the label.", "</p>"});
        param.setNullPermitted(true);
        return param;
    }

    public Parameter<String> createTitleParameter(String suffix) {
        if (DOC_ZONE_SUFFIX.equals(suffix)) {
            suffix = null;
        }
        String baseName = "title";
        StringParameter param = new StringParameter(baseName + (suffix == null ? DOC_ZONE_SUFFIX : suffix));
        param.setPrompt("Title for plot" + (suffix == null ? DOC_ZONE_SUFFIX : " zone " + suffix));
        param.setDescription(new String[]{"<p>Text of a title to be displayed at the top of", (suffix == null ? "the plot" : "plot zone " + suffix) + ".", "If null, the default, no title is shown", "and there's more space for the graphics.", "</p>", this.getZoneDoc(baseName, suffix)});
        param.setNullPermitted(true);
        return param;
    }

    public StringParameter createAuxLabelParameter(String suffix) {
        if (DOC_ZONE_SUFFIX.equals(suffix)) {
            suffix = null;
        }
        String baseName = "auxlabel";
        StringParameter param = new StringParameter(baseName + (suffix == null ? DOC_ZONE_SUFFIX : suffix));
        param.setUsage("<text>");
        param.setPrompt("Label for aux axis" + (suffix == null ? DOC_ZONE_SUFFIX : " for zone " + suffix));
        param.setDescription(new String[]{"<p>Sets the label used to annotate the aux axis" + (suffix == null ? "," : " for zone " + suffix + ","), "if it is visible.", "</p>", this.getZoneDoc(baseName, suffix)});
        param.setNullPermitted(true);
        return param;
    }

    public BooleanParameter createAuxVisibleParameter(String suffix) {
        if (DOC_ZONE_SUFFIX.equals(suffix)) {
            suffix = null;
        }
        String baseName = "auxvisible";
        BooleanParameter param = new BooleanParameter(baseName + (suffix == null ? DOC_ZONE_SUFFIX : suffix));
        param.setPrompt("Display aux colour ramp" + (suffix == null ? DOC_ZONE_SUFFIX : " for zone " + suffix) + "?");
        param.setDescription(new String[]{"<p>Determines whether the aux axis colour ramp", "is displayed alongside the plot" + (suffix == null ? "." : " for zone " + suffix + "."), "</p>", "<p>If not supplied (the default),", "the aux axis will be visible when aux shading is used", "in any of the plotted layers.", "</p>", this.getZoneDoc(baseName, suffix)});
        param.setNullPermitted(true);
        return param;
    }

    public DoubleParameter createAuxCrowdParameter(String suffix) {
        if (DOC_ZONE_SUFFIX.equals(suffix)) {
            suffix = null;
        }
        String baseName = "auxcrowd";
        DoubleParameter param = new DoubleParameter(baseName + (suffix == null ? DOC_ZONE_SUFFIX : suffix));
        param.setUsage("<factor>");
        param.setPrompt("Tick crowding on aux axis" + (suffix == null ? DOC_ZONE_SUFFIX : " for zone " + suffix));
        param.setDescription(new String[]{"<p>Determines how closely the tick marks are spaced on", "the Aux axis" + (suffix == null ? "," : " for zone " + suffix + ","), "if visible.", "The default value is 1, meaning normal crowding.", "Larger values result in more ticks,", "and smaller values fewer ticks.", "Tick marks will not however be spaced so closely that", "the labels overlap each other,", "so to get very closely spaced marks you may need to", "reduce the font size as well.", "</p>", this.getZoneDoc(baseName, suffix)});
        param.setDoubleDefault(1.0);
        return param;
    }

    public IntegerParameter createAuxWidthParameter(String suffix) {
        if (DOC_ZONE_SUFFIX.equals(suffix)) {
            suffix = null;
        }
        String baseName = "auxwidth";
        IntegerParameter param = new IntegerParameter(baseName + (suffix == null ? DOC_ZONE_SUFFIX : suffix));
        param.setUsage("<pixels>");
        param.setPrompt("Width of aux axis ramp" + (suffix == null ? DOC_ZONE_SUFFIX : " for zone " + suffix));
        param.setDescription(new String[]{"<p>Determines the lateral size of the aux colour ramp,", "if visible, in pixels.", "</p>", this.getZoneDoc(baseName, suffix)});
        param.setIntDefault(15);
        return param;
    }

    public DoubleArrayParameter createLegendPositionParameter(String suffix) {
        if (DOC_ZONE_SUFFIX.equals(suffix)) {
            suffix = null;
        }
        String baseName = "legpos";
        DoubleArrayParameter param = new DoubleArrayParameter(baseName + (suffix == null ? DOC_ZONE_SUFFIX : suffix), 2);
        param.setUsage("<xfrac,yfrac>");
        param.setPrompt("X,Y fractional internal legend position" + (suffix == null ? DOC_ZONE_SUFFIX : " for zone " + suffix));
        param.setDescription(new String[]{"<p>Determines the internal position of the legend on", (suffix == null ? "the plot" : "plot zone " + suffix) + ".", "The value is a comma-separated pair of values giving the", "X and Y positions of the legend within the plotting bounds,", "so for instance \"<code>0.5,0.5</code>\" will put the legend", "right in the middle of the plot.", "If no value is supplied, the legend will appear outside", "the plot boundary.", "</p>", this.getZoneDoc(baseName, suffix)});
        param.setNullPermitted(true);
        return param;
    }

    private String getZoneDoc(String baseName, String suffix) {
        if (!this.hasZoneSuffixes_) {
            return DOC_ZONE_SUFFIX;
        }
        if (suffix != null && suffix.length() > 0) {
            return new StringBuffer().append("<p>This parameter affects only zone ").append("<code>").append(suffix).append("</code>.\n").append("</p>").toString();
        }
        return new StringBuffer().append("<p>If a zone suffix is appended ").append("to the parameter name, ").append("only that zone is affected,\n").append("e.g. ").append("<code>").append(baseName).append(EXAMPLE_ZONE_SUFFIX).append("</code>").append(" affects only zone ").append("<code>").append(EXAMPLE_ZONE_SUFFIX).append("</code>").append(".").append("</p>\n").toString();
    }

    public static boolean hasDomainMappers(Input input) {
        return input.getDomain().getMappers().length > 1;
    }

    public static LayerTypeParameter createLayerTypeParameter(String suffix, PlotContext<?, ?> context) {
        return new LayerTypeParameter(LAYER_PREFIX, suffix, context);
    }

    public static Parameter<String> createZoneParameter(String layerSuffix) {
        StringParameter param = new StringParameter(ZONE_PREFIX + layerSuffix);
        param.setUsage("<text>");
        param.setPrompt("Plot zone for layer " + layerSuffix);
        param.setDescription(new String[]{"<p>Defines which plot zone the layer with suffix " + layerSuffix, "will appear in.", "This only makes sense for multi-zone plots.", "The actual value of the parameter is not significant,", "it just serves as a label,", "but different layers will end up in the same plot zone", "if they give the same values for this parameter.", "</p>"});
        param.setNullPermitted(true);
        return param;
    }

    public static StringParameter createDataParameter(Input input, String suffix, boolean fullDetail) {
        String typeUsage;
        String typeTxt;
        InputMeta meta = input.getMeta();
        Domain<?> domain = input.getDomain();
        boolean hasSuffix = suffix.length() > 0;
        String cName = meta.getShortName();
        boolean isArray = domain instanceof FloatingArrayCoord.ArrayDomain;
        DomainMapper[] mappers = domain.getMappers();
        if (mappers.length == 1) {
            DomainMapper mapper = mappers[0];
            Class cClazz = mapper.getSourceClass();
            if (cClazz.equals(String.class)) {
                typeTxt = "a string";
                typeUsage = "txt";
            } else if (cClazz.equals(Integer.class) || cClazz.equals(Long.class)) {
                typeTxt = "an integer";
                typeUsage = "int";
            } else if (Number.class.isAssignableFrom(cClazz)) {
                typeTxt = "a numeric";
                typeUsage = "num";
            } else if (isArray) {
                typeTxt = "an array-valued";
                typeUsage = "array";
            } else if (Object.class.equals((Object)cClazz)) {
                typeTxt = "an";
                typeUsage = null;
            } else {
                typeTxt = "a <code>" + cClazz.getSimpleName() + "</code>";
                typeUsage = null;
            }
        } else {
            typeTxt = "a " + domain.getDomainName() + " value";
            typeUsage = domain.getDomainName().toLowerCase();
        }
        StringParameter param = new StringParameter(cName + suffix);
        String prompt = meta.getShortDescription();
        if (fullDetail) {
            prompt = prompt + (hasSuffix ? " for layer " + suffix : " for plot layers");
        }
        param.setPrompt(prompt);
        StringBuffer dbuf = new StringBuffer().append(meta.getXmlDescription());
        dbuf.append("<p>");
        if (fullDetail) {
            dbuf.append("This parameter gives a column name, ").append("fixed value, or algebraic expression for the\n").append("<code>").append(cName).append("</code> coordinate\n");
            if (hasSuffix) {
                dbuf.append("for layer <code>").append(suffix).append("</code>");
            } else {
                dbuf.append("for all plot layers");
            }
            dbuf.append(".\n");
        }
        dbuf.append("The value is ").append(typeTxt).append(" algebraic expression based on column names\n").append("as described in <ref id='jel'/>.\n");
        if (isArray) {
            dbuf.append("Some of the functions in the ").append("<ref id='Arrays'>Arrays</ref> class\n").append("may be useful here.\n");
        }
        dbuf.append("</p>\n");
        param.setDescription(dbuf.toString());
        String vUsage = meta.getValueUsage();
        if (vUsage == null) {
            vUsage = typeUsage;
        }
        param.setUsage(vUsage == null ? "<expr>" : "<" + vUsage + "-expr>");
        return param;
    }

    public static Parameter<DomainMapper> createDomainMapperParameter(Input input, String suffix) {
        InputMeta meta = input.getMeta();
        Domain<?> domain = input.getDomain();
        DomainMapper[] dms = domain.getMappers();
        boolean hasSuffix = suffix.length() > 0;
        String cName = meta.getShortName() + DOMAINMAPPER_SUFFIX;
        ChoiceParameter<DomainMapper> param = new ChoiceParameter<DomainMapper>(cName + suffix, dms){

            public String getName(DomainMapper dm) {
                return dm.getSourceName();
            }
        };
        param.setNullPermitted(true);
        String dataParamName = meta.getShortName() + suffix;
        param.setPrompt("value type for parameter " + dataParamName);
        StringBuffer dbuf = new StringBuffer().append("<p>Selects the form in which the ").append(domain.getDomainName()).append(" value for parameter\n").append("<code>" + dataParamName + "</code> is supplied.\n").append("Options are:\n").append("<ul>\n");
        for (DomainMapper dm : dms) {
            dbuf.append("<li><code>").append(dm.getSourceName()).append("</code>: ").append(dm.getSourceDescription()).append("</li>\n");
        }
        dbuf.append("</ul>\n").append("If left blank, a guess will be taken depending on\n").append("the data type of the value supplied for the\n").append("<code>" + dataParamName + "</code> value.\n").append("</p>\n");
        param.setDescription(dbuf.toString());
        return param;
    }

    public static PaintModeParameter createPaintModeParameter() {
        return new PaintModeParameter("omode", EXPORTERS);
    }

    public static <P, A> Icon createPlotIcon(Ganger<P, A> ganger, final SurfaceFactory<P, A> surfFact, final ZoneContent<P, A>[] contents, final Trimming[] trimmings, ShadeAxisKit[] shadeKits, final PaperTypeSelector ptSel, final Compositor compositor, final DataStore dataStore, final int xpix, final int ypix, final boolean forceBitmap) {
        ShadeAxis[] shadeAxes;
        final Rectangle extBox = new Rectangle(0, 0, xpix, ypix);
        boolean cached = false;
        Object[] planArray = null;
        final Set planSet = null;
        boolean withScroll = false;
        final int nz = ganger.getZoneCount();
        final boolean isTrimGlobal = ganger.isTrimmingGlobal();
        final boolean isShadeGlobal = ganger.isShadingGlobal();
        if (contents.length != nz) {
            throw new IllegalArgumentException("zone count mismatch");
        }
        if (trimmings.length != (isTrimGlobal ? 1 : nz)) {
            throw new IllegalArgumentException("trimmings count mismatch");
        }
        if (shadeKits.length != (isShadeGlobal ? 1 : nz)) {
            throw new IllegalArgumentException("shadings count mismatch");
        }
        Gang approxGang = ganger.createGang(extBox, surfFact, contents, trimmings, new ShadeAxis[shadeKits.length], false);
        final ArrayList<Map<AuxScale, Span>> auxSpanList = new ArrayList<Map<AuxScale, Span>>();
        long start = System.currentTimeMillis();
        final Surface[] approxSurfs = new Surface[nz];
        for (int iz = 0; iz < nz; ++iz) {
            Surface approxSurf;
            ZoneContent<P, A> content = contents[iz];
            approxSurfs[iz] = approxSurf = surfFact.createSurface(approxGang.getZonePlotBounds(iz), content.getProfile(), content.getAspect());
            Map<AuxScale, Span> auxSpans = PlotScene.calculateNonShadeSpans(content.getLayers(), approxSurf, planArray, dataStore);
            auxSpanList.add(auxSpans);
        }
        if (isShadeGlobal) {
            ShadeAxisKit shadeKit = shadeKits[0];
            ShadeAxisFactory shadeFact = shadeKit == null ? null : shadeKit.getAxisFactory();
            ArrayList<Bi<Surface, PlotLayer>> surfLayers = new ArrayList<Bi<Surface, PlotLayer>>();
            for (int iz = 0; iz < nz; ++iz) {
                surfLayers.addAll(AuxScale.pairSurfaceLayers(approxSurfs[iz], contents[iz].getLayers()));
            }
            Span shadeSpan = PlotScene.calculateShadeSpan(surfLayers, shadeKit, planArray, dataStore);
            if (shadeSpan != null) {
                for (Map map : auxSpanList) {
                    map.put(AuxScale.COLOR, shadeSpan);
                }
            }
            ShadeAxis shadeAxis = shadeFact != null && shadeSpan != null ? shadeFact.createShadeAxis(shadeSpan) : null;
            shadeAxes = new ShadeAxis[]{shadeAxis};
        } else {
            shadeAxes = new ShadeAxis[nz];
            for (int iz = 0; iz < nz; ++iz) {
                ShadeAxisKit shadeKit = shadeKits[iz];
                ShadeAxisFactory shadeFact = shadeKit == null ? null : shadeKit.getAxisFactory();
                Surface surf = approxSurfs[iz];
                List<Bi<Surface, PlotLayer>> surfLayers = AuxScale.pairSurfaceLayers(approxSurfs[iz], contents[iz].getLayers());
                Span span = PlotScene.calculateShadeSpan(surfLayers, shadeKit, planArray, dataStore);
                if (span != null) {
                    ((Map)auxSpanList.get(iz)).put(AuxScale.COLOR, span);
                }
                shadeAxes[iz] = shadeFact != null && span != null ? shadeFact.createShadeAxis(span) : null;
            }
        }
        PlotUtil.logTimeFromStart(logger_, "Range", start);
        final Gang gang = ganger.createGang(extBox, surfFact, contents, trimmings, shadeAxes, false);
        return new Icon(){

            @Override
            public int getIconWidth() {
                return xpix;
            }

            @Override
            public int getIconHeight() {
                return ypix;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Shape clip = g.getClip();
                long planMillis = 0L;
                long paintMillis = 0L;
                Surface[] surfs = new Surface[nz];
                for (int iz = 0; iz < nz; ++iz) {
                    PaperType paperType;
                    Surface surface;
                    ZoneContent content = contents[iz];
                    PlotLayer[] layers = content.getLayers();
                    surfs[iz] = surface = surfFact.createSurface(gang.getZonePlotBounds(iz), content.getProfile(), content.getAspect());
                    Trimming trimming = isTrimGlobal ? null : trimmings[iz];
                    ShadeAxis shadeAxis = isShadeGlobal ? null : shadeAxes[iz];
                    PlotFrame frame = PlotFrame.createPlotFrame(surface, false);
                    Decoration[] decs = PlotPlacement.createPlotDecorations(frame, trimming, shadeAxis);
                    PlotPlacement placer = new PlotPlacement(extBox, surface, decs);
                    LayerOpt[] opts = PaperTypeSelector.getOpts(layers);
                    PaperType paperType2 = paperType = forceBitmap ? ptSel.getPixelPaperType(opts, compositor) : ptSel.getVectorPaperType(opts);
                    if (clip != null && !clip.intersects(surface.getPlotBounds())) {
                        layers = new PlotLayer[]{};
                    }
                    long planStart = System.currentTimeMillis();
                    Icon zicon = PlotUtil.createPlotIcon(placer, layers, (Map)auxSpanList.get(iz), dataStore, paperType, false, planSet);
                    planMillis += System.currentTimeMillis() - planStart;
                    long paintStart = System.currentTimeMillis();
                    zicon.paintIcon(c, g, 0, 0);
                    paintMillis += System.currentTimeMillis() - paintStart;
                }
                if (isTrimGlobal && trimmings[0] != null || isShadeGlobal && shadeAxes[0] != null) {
                    Decoration[] decs;
                    Captioner captioner = approxSurfs.length > 0 ? approxSurfs[0].getCaptioner() : null;
                    PlotFrame extFrame = PlotFrame.createPlotFrame(surfs, false, extBox);
                    for (Decoration dec : decs = PlotPlacement.createPlotDecorations(extFrame, trimmings[0], shadeAxes[0])) {
                        dec.paintDecoration(g);
                    }
                }
                PlotUtil.logTimeElapsed(logger_, "Plan", planMillis);
                PlotUtil.logTimeElapsed(logger_, "Paint", paintMillis);
                g.translate(-x, -y);
            }
        };
    }

    public final List<Parameter<?>> getZoneKeyParams(ConfigKey<?>[] keys) {
        ArrayList plist = new ArrayList();
        for (int ik = 0; ik < keys.length; ++ik) {
            plist.add(ConfigParameter.createZoneSuffixedParameter(keys[ik], DOC_ZONE_SUFFIX, this.hasZoneSuffixes_));
        }
        return plist;
    }

    private static PlotLayer getFirstAuxLayer(PlotLayer[] layers, AuxScale scale) {
        for (PlotLayer layer : layers) {
            if (!layer.getAuxRangers().containsKey(scale)) continue;
            return layer;
        }
        return null;
    }

    private static class Row0Table
    extends WrapperStarTable {
        final Object[] row0_;
        RowSequence rseq_;

        Row0Table(StarTable base) throws IOException {
            super(base);
            this.rseq_ = base.getRowSequence();
            this.rseq_.next();
            this.row0_ = this.rseq_.getRow();
        }

        public Object[] getRow0() {
            return this.row0_;
        }

        public synchronized RowSequence getRowSequence() throws IOException {
            if (this.rseq_ == null) {
                return super.getRowSequence();
            }
            RowSequence baseSeq = this.rseq_;
            this.rseq_ = null;
            return new WrapperRowSequence(baseSeq){
                long irow;
                {
                    super(x0);
                    this.irow = -1L;
                }

                public boolean next() throws IOException {
                    return ++this.irow == 0L || super.next();
                }

                public Object getCell(int icol) throws IOException {
                    return this.irow == 0L ? row0_[icol] : super.getCell(icol);
                }

                public Object[] getRow() throws IOException {
                    return this.irow == 0L ? row0_ : super.getRow();
                }
            };
        }
    }
}

