/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.data.AbstractDataSpec;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

public class ColumnDataSpec
extends AbstractDataSpec {
    private final StarTable table_;
    private final int nCoord_;
    private final Coord[] coords_;
    private final int[][] userCoordColIndices_;
    private final DomainMapper[][] userCoordMappers_;
    private static final String ALL_MASK = "ALL";

    public ColumnDataSpec(StarTable table, Coord[] coords, int[][] userCoordColIndices) {
        this(table, coords, userCoordColIndices, null);
    }

    public ColumnDataSpec(StarTable table, Coord[] coords, int[][] userCoordColIndices, DomainMapper[][] userCoordMappers) {
        this.nCoord_ = coords.length;
        this.table_ = table;
        this.coords_ = coords;
        this.userCoordColIndices_ = userCoordColIndices;
        this.userCoordMappers_ = new DomainMapper[this.nCoord_][];
        for (int ic = 0; ic < this.nCoord_; ++ic) {
            DomainMapper[] dms;
            if (userCoordMappers[ic] != null) {
                dms = (DomainMapper[])userCoordMappers[ic].clone();
            } else {
                int[] icols = userCoordColIndices[ic];
                int nuc = icols.length;
                dms = new DomainMapper[nuc];
                for (int iuc = 0; iuc < nuc; ++iuc) {
                    ColumnInfo info = table.getColumnInfo(icols[iuc]);
                    Domain<?> domain = coords[ic].getInputs()[iuc].getDomain();
                    dms[iuc] = domain.getProbableMapper((ValueInfo)info);
                    if (dms[iuc] != null) continue;
                    dms[iuc] = domain.getPossibleMapper((ValueInfo)info);
                }
            }
            this.userCoordMappers_[ic] = dms;
        }
        if (userCoordColIndices.length != this.nCoord_ || userCoordMappers.length != this.nCoord_) {
            throw new IllegalArgumentException("coord count mismatch");
        }
    }

    @Override
    public StarTable getSourceTable() {
        return this.table_;
    }

    @Override
    public int getCoordCount() {
        return this.coords_.length;
    }

    @Override
    public String getCoordId(int ic) {
        StringBuffer sbuf = new StringBuffer();
        int[] icols = this.userCoordColIndices_[ic];
        DomainMapper[] dms = this.userCoordMappers_[ic];
        for (int iu = 0; iu < icols.length; ++iu) {
            if (iu > 0) {
                sbuf.append(",");
            }
            sbuf.append(Integer.toString(icols[iu]));
            if (dms == null || dms[iu] == null) continue;
            sbuf.append("|").append(dms[iu].getSourceName());
        }
        return sbuf.toString();
    }

    @Override
    public Coord getCoord(int ic) {
        return this.coords_[ic];
    }

    @Override
    public String getMaskId() {
        return ALL_MASK;
    }

    @Override
    public ValueInfo[] getUserCoordInfos(int ic) {
        int[] icols = this.userCoordColIndices_[ic];
        ValueInfo[] infos = new ValueInfo[icols.length];
        for (int iu = 0; iu < icols.length; ++iu) {
            infos[iu] = this.table_.getColumnInfo(icols[iu]);
        }
        return infos;
    }

    @Override
    public DomainMapper[] getUserCoordMappers(int ic) {
        return this.userCoordMappers_[ic];
    }

    @Override
    public UserDataReader createUserDataReader() {
        final Object[][] userRows = new Object[this.nCoord_][];
        for (int ic = 0; ic < this.nCoord_; ++ic) {
            int[] icols = this.userCoordColIndices_[ic];
            userRows[ic] = new Object[icols.length];
        }
        return new UserDataReader(){

            @Override
            public boolean getMaskFlag(RowData rdata, long irow) {
                return true;
            }

            @Override
            public Object[] getUserCoordValues(RowData rdata, long irow, int icoord) throws IOException {
                Object[] userRow = userRows[icoord];
                int[] icols = ColumnDataSpec.this.userCoordColIndices_[icoord];
                for (int iu = 0; iu < userRow.length; ++iu) {
                    userRow[iu] = rdata.getCell(icols[iu]);
                }
                return userRow;
            }
        };
    }

    @Override
    public boolean isMaskTrue() {
        return true;
    }

    @Override
    public boolean isCoordBlank(int icoord) {
        return false;
    }
}

