/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class HighlightIcon
implements Icon {
    private final int size_;
    private final int size2_;
    private final Stroke stroke_ = new BasicStroke(2.0f, 1, 1);
    private final Map<RenderingHints.Key, Object> hints_;
    private final Color color1_ = new Color(0xFFFFFF);
    private final Color color2_ = new Color(0);
    public static final HighlightIcon INSTANCE = new HighlightIcon(6);

    public HighlightIcon(int size) {
        this.size_ = size;
        this.size2_ = this.size_ * 2 + 1;
        this.hints_ = new HashMap<RenderingHints.Key, Object>();
        this.hints_.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    @Override
    public int getIconWidth() {
        return this.size2_;
    }

    @Override
    public int getIconHeight() {
        return this.size2_;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke stroke0 = g2.getStroke();
        Color color0 = g2.getColor();
        RenderingHints hints0 = g2.getRenderingHints();
        g2.setRenderingHints(this.hints_);
        g2.setStroke(this.stroke_);
        int xoff = x + this.size_;
        int yoff = y + this.size_;
        g2.translate(xoff, yoff);
        g2.setColor(this.color1_);
        HighlightIcon.drawTarget(g2, this.size_ - 1);
        g2.setColor(this.color2_);
        HighlightIcon.drawTarget(g2, this.size_);
        g2.translate(-xoff, -yoff);
        g2.setColor(color0);
        g2.setStroke(stroke0);
        g2.setRenderingHints(hints0);
    }

    public Decoration createDecoration(Point2D gp) {
        int xoff = this.getIconWidth() / 2;
        int yoff = this.getIconWidth() / 2;
        int gx = PlotUtil.ifloor(gp.getX() - (double)xoff);
        int gy = PlotUtil.ifloor(gp.getY() - (double)yoff);
        return new Decoration(this, gx, gy);
    }

    private static void drawTarget(Graphics g, int size) {
        int size2 = size * 2 + 1;
        int s = size - 2;
        int s2 = s * 2;
        g.drawOval(-size, -size, size2, size2);
        g.drawLine(0, s, 0, s2);
        g.drawLine(0, -s, 0, -s2);
        g.drawLine(s, 0, s2, 0);
        g.drawLine(-s, 0, -s2, 0);
    }
}

