/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapeModePlotter;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.ConfigParameter;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.PlotContext;
import uk.ac.starlink.ttools.plot2.task.ShapeFamilyLayerType;
import uk.ac.starlink.ttools.plot2.task.SimpleLayerType;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class LayerTypeParameter
extends ChoiceParameter<LayerType>
implements ExtraParameter {
    private final String layerSuffix_;
    private final DataGeom[] geoms_;
    private final Parameter<?> geomParam_;

    public LayerTypeParameter(String prefix, String suffix, PlotContext<?, ?> context) {
        super(prefix + suffix, (Object[])LayerTypeParameter.getLayerTypes(context.getPlotType().getPlotters()));
        this.layerSuffix_ = suffix;
        this.geoms_ = context.getExampleGeoms();
        this.geomParam_ = context.getGeomParameter(suffix);
        StringBuffer usage = new StringBuffer().append("<layer-type>").append(" ").append("<layer").append(this.layerSuffix_).append("-specific-params>");
        this.setUsage(usage.toString());
        this.setPrompt("Plot type for layer " + suffix);
        String osfix = "&lt;N&gt;";
        StringBuffer obuf = new StringBuffer();
        for (LayerType ltype : (LayerType[])this.getOptions()) {
            String lname = this.stringifyOption(ltype);
            obuf.append("<li><code>").append("<ref id='layer-").append(lname).append("' plaintextref='yes'>").append(lname).append("</ref>").append("</code></li>\n");
        }
        String optlist = obuf.toString();
        this.setDescription(new String[]{"<p>Selects one of the available plot types", "for layer" + suffix + ".", "A plot consists of a plotting surface,", "set up using the various unsuffixed parameters", "of the plotting command,", "and zero or more plot layers.", "Each layer is introduced by a parameter with the name", "<code>" + prefix + osfix + "</code>", "where the suffix \"<code>" + osfix + "</code>\"", "is a label identifying the layer", "and is appended to all the parameter names", "which configure that layer.", "Suffixes may be any string, including the empty string.", "</p>", "<p>This parameter may take one of the following values,", "described in more detail in <ref id='LayerType'/>:", "<ul>", optlist, "</ul>", "</p>", "<p>Each of these layer types comes with a list of type-specific", "parameters to define the details of that layer,", "including some or all of the following groups:", "<ul>", "<li>input table parameters", "(e.g. <code>in" + suffix + "</code>,", "<code>icmd" + suffix + "</code>)</li>", "<li>coordinate params referring to input table columns", "(e.g. <code>x" + suffix + "</code>,", "<code>y" + suffix + "</code>)</li>", "<li>layer style parameters", "(e.g. <code>shading" + suffix + "</code>,", "<code>color" + suffix + "</code>)</li>", "</ul>", "</p>", "<p>Every parameter notionally carries the same suffix", "<code>" + suffix + "</code>.", "However, if the suffix is not present,", "the application will try looking for a parameter with the", "same name with no suffix instead.", "In this way, if several layers have the same value for a given", "parameter (for instance input table),", "you can supply it using one unsuffixed parameter", "to save having to supply several parameters with the same", "value but different suffixes.", "</p>"});
    }

    public String stringifyOption(LayerType ltype) {
        return ltype.getName().toLowerCase();
    }

    @Override
    public String getExtraUsage(TableEnvironment env) {
        boolean hasShades = this.getShapeLayerTypes().length > 0;
        String tableUsage = "<table-params" + this.layerSuffix_ + ">";
        String coordUsage = "<coord-params" + this.layerSuffix_ + ">";
        String styleUsage = "<style-params" + this.layerSuffix_ + ">";
        String shadeUsage = "<shade-params" + this.layerSuffix_ + ">";
        StringBuffer sbuf = new StringBuffer();
        ArrayList<String> uwords = new ArrayList<String>();
        uwords.add(this.getName() + "=<layer-type>");
        uwords.add(tableUsage);
        uwords.add(coordUsage);
        uwords.add(styleUsage);
        if (hasShades) {
            uwords.add(shadeUsage);
        }
        sbuf.append("   Specification of layer N").append(" (with N any string)").append(" takes the form:").append("\n").append(Formatter.formatWords(uwords, 6));
        DataGeom geom = this.geoms_[0];
        sbuf.append("\n   Available layer types").append(" with associated parameters:\n");
        for (LayerType ltype : (LayerType[])this.getOptions()) {
            boolean hasStyle;
            sbuf.append('\n');
            ArrayList<String> usageWords = new ArrayList<String>();
            usageWords.add(this.getName() + "=" + ltype.getName());
            int npos = ltype.getCoordGroup().getBasicPositionCount();
            Coord[] extraCoords = ltype.getExtraCoords();
            boolean hasData = npos > 0 || extraCoords.length > 0;
            ConfigKey<?>[] styleKeys = ltype.getStyleKeys();
            boolean bl = hasStyle = styleKeys.length > 0;
            if (hasData) {
                usageWords.add(tableUsage);
                usageWords.add(coordUsage);
            }
            if (hasStyle) {
                usageWords.add(styleUsage);
            }
            if (hasShades) {
                usageWords.add(shadeUsage);
            }
            sbuf.append(Formatter.formatWords(usageWords, 6));
            if (hasData) {
                ArrayList<String> coordWords = new ArrayList<String>();
                coordWords.add(coordUsage + ":");
                Coord[] posCoords = geom.getPosCoords();
                for (int ipos = 0; ipos < npos; ++ipos) {
                    String suffix = this.layerSuffix_;
                    if (npos > 1) {
                        suffix = PlotUtil.getIndexSuffix(ipos) + suffix;
                    }
                    coordWords.addAll(LayerTypeParameter.usageWords(LayerTypeParameter.getCoordParams(posCoords, suffix, false)));
                }
                if (npos > 0 && this.geomParam_ != null) {
                    coordWords.add(LayerTypeParameter.usageWord(this.geomParam_));
                }
                coordWords.addAll(LayerTypeParameter.usageWords(LayerTypeParameter.getCoordParams(extraCoords, this.layerSuffix_, false)));
                sbuf.append(Formatter.formatWords(coordWords, 9));
            }
            if (!hasStyle) continue;
            ArrayList<String> styleWords = new ArrayList<String>();
            styleWords.add(styleUsage + ":");
            for (Parameter<?> param : ltype.getAssociatedParameters(this.layerSuffix_)) {
                styleWords.add(LayerTypeParameter.usageWord(param));
            }
            styleWords.addAll(LayerTypeParameter.usageWords(LayerTypeParameter.getLayerConfigParams(styleKeys, this.layerSuffix_, false)));
            sbuf.append(Formatter.formatWords(styleWords, 9));
        }
        sbuf.append("\n   ").append(tableUsage).append(" (Table parameters):").append("\n");
        ArrayList<String> tuWords = new ArrayList<String>();
        tuWords.addAll(LayerTypeParameter.usageWords(LayerTypeParameter.getInputParams(this.layerSuffix_)));
        sbuf.append(Formatter.formatWords(tuWords, 6));
        if (hasShades) {
            ShapeFamilyLayerType shapeType = this.getShapeLayerTypes()[0];
            ChoiceParameter<ShapeMode> shapemodeParam = shapeType.createShapeModeParameter(this.layerSuffix_);
            sbuf.append("\n   ").append(shadeUsage).append(" (Available shading types ").append("with associated parameters):").append("\n");
            for (ShapeMode mode : (ShapeMode[])shapemodeParam.getOptions()) {
                ArrayList<String> modeWords = new ArrayList<String>();
                modeWords.add(shapemodeParam.getName() + "=" + mode.getModeName());
                modeWords.addAll(LayerTypeParameter.usageWords(LayerTypeParameter.getCoordParams(mode.getExtraCoords(), this.layerSuffix_, false)));
                modeWords.addAll(LayerTypeParameter.usageWords(LayerTypeParameter.getLayerConfigParams(mode.getConfigKeys(), this.layerSuffix_, false)));
                sbuf.append(Formatter.formatWords(modeWords, 6));
            }
        }
        if (this.geoms_.length > 1) {
            sbuf.append("Coordinate variables may differ by geometry.\n");
        }
        return sbuf.toString();
    }

    private ShapeFamilyLayerType[] getShapeLayerTypes() {
        ArrayList<ShapeFamilyLayerType> shapeList = new ArrayList<ShapeFamilyLayerType>();
        for (LayerType ltype : (LayerType[])this.getOptions()) {
            if (!(ltype instanceof ShapeFamilyLayerType)) continue;
            shapeList.add((ShapeFamilyLayerType)ltype);
        }
        return shapeList.toArray(new ShapeFamilyLayerType[0]);
    }

    public static Parameter<?>[] getInputParams(String suffix) {
        InputTableParameter inParam = AbstractPlot2Task.createTableParameter(suffix);
        return new Parameter[]{inParam, inParam.getFormatParameter(), inParam.getStreamParameter(), AbstractPlot2Task.createFilterParameter(suffix, inParam)};
    }

    public static Parameter<?>[] getCoordParams(Coord[] coords, String suffix, boolean fullDetail) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (Coord coord : coords) {
            for (Input input : coord.getInputs()) {
                StringParameter param = AbstractPlot2Task.createDataParameter(input, suffix, fullDetail);
                param.setNullPermitted(!coord.isRequired());
                paramList.add(param);
                if (!AbstractPlot2Task.hasDomainMappers(input)) continue;
                paramList.add(AbstractPlot2Task.createDomainMapperParameter(input, suffix));
            }
        }
        return paramList.toArray(new Parameter[0]);
    }

    public static Parameter<?>[] getLayerConfigParams(ConfigKey<?>[] configKeys, String suffix, boolean fullDetail) {
        ArrayList paramList = new ArrayList();
        for (ConfigKey<?> key : configKeys) {
            paramList.add(ConfigParameter.createLayerSuffixedParameter(key, suffix, fullDetail));
        }
        return paramList.toArray(new Parameter[0]);
    }

    public static List<String> usageWords(Parameter<?>[] params) {
        ArrayList<String> wordList = new ArrayList<String>(params.length);
        for (Parameter<?> param : params) {
            wordList.add(LayerTypeParameter.usageWord(param));
        }
        return wordList;
    }

    public static String usageWord(Parameter<?> param) {
        return new StringBuffer().append(param.getName()).append('=').append(param.getUsage()).toString();
    }

    public static LayerType[] getLayerTypes(Plotter<?>[] plotters) {
        LinkedHashMap<ShapeForm, ArrayList<ShapeModePlotter>> shapePlotterMap = new LinkedHashMap<ShapeForm, ArrayList<ShapeModePlotter>>();
        ArrayList<LayerType> typeList = new ArrayList<LayerType>();
        for (Plotter<?> plotter : plotters) {
            if (plotter instanceof ShapeModePlotter) {
                ShapeModePlotter shapePlotter = (ShapeModePlotter)plotter;
                ShapeForm form = shapePlotter.getForm();
                if (!shapePlotterMap.containsKey(form)) {
                    ArrayList<ShapeModePlotter> modeList = new ArrayList<ShapeModePlotter>();
                    typeList.add(new ShapeFamilyLayerType(form, modeList));
                    shapePlotterMap.put(form, modeList);
                }
                ((List)shapePlotterMap.get(form)).add(shapePlotter);
                continue;
            }
            typeList.add(new SimpleLayerType(plotter));
        }
        return typeList.toArray(new LayerType[0]);
    }
}

