/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plot.PictureImageIcon;
import uk.ac.starlink.ttools.plottask.Painter;

public class SwingPainter
implements Painter {
    private final String winTitle_;

    public SwingPainter(String winTitle) {
        this.winTitle_ = winTitle;
    }

    @Override
    public void paintPicture(Picture picture) {
        this.postComponent(new JLabel(new PictureImageIcon(picture, true)));
    }

    public void postComponent(Component comp) {
        JPanel holder = new JPanel(new BorderLayout());
        holder.add(comp);
        final JFrame frame = new JFrame(this.winTitle_);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(holder);
        String quitKey = "quit";
        holder.getInputMap().put(KeyStroke.getKeyStroke('q'), quitKey);
        holder.getActionMap().put(quitKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

