/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.auth.UrlConnector;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.TableMetadataStage;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.StdCapabilityInterface;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;
import uk.ac.starlink.vo.TapService;

public class TablesEndpointStage
extends TableMetadataStage {
    private final CapabilityHolder capHolder_;
    private final ContentCoding coding_;

    public TablesEndpointStage(CapabilityHolder capHolder) {
        super("/tables", new String[]{"indexed", "primary", "nullable"}, true);
        this.capHolder_ = capHolder;
        this.coding_ = ContentCoding.NONE;
    }

    @Override
    protected MetadataHolder readTableMetadata(Reporter reporter, TapService tapService) {
        TableSetSaxHandler populatedHandler;
        SAXParser parser;
        BufferedInputStream in;
        URLConnection conn;
        URL turl;
        Boolean declaresTables;
        StdCapabilityInterface[] intfs = this.capHolder_.getInterfaces();
        boolean isVosi11 = false;
        if (intfs == null) {
            declaresTables = null;
        } else {
            declaresTables = Boolean.FALSE;
            for (StdCapabilityInterface intf : intfs) {
                String stdid = intf.getStandardId();
                if (stdid == null || !stdid.startsWith("ivo://ivoa.net/std/VOSI#tables")) continue;
                declaresTables = Boolean.TRUE;
                String vers = intf.getVersion();
                if (vers == null || !vers.matches("1[.][1-9][0-9]*")) continue;
                isVosi11 = true;
            }
        }
        String query = isVosi11 ? "?detail=max" : "";
        try {
            turl = URLUtils.newURL((String)(tapService.getTablesEndpoint() + query));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Shouldn't happen: " + e, e);
        }
        reporter.report(FixedCode.I_TURL, "Reading table metadata from " + turl);
        try {
            conn = AuthManager.getInstance().connect(turl, (UrlConnector)this.coding_);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FLIO, "Can't open tables endpoint", e);
            return null;
        }
        if (conn instanceof HttpURLConnection) {
            String msg;
            int code;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            try {
                code = hconn.getResponseCode();
            }
            catch (IOException e) {
                reporter.report(FixedCode.E_FLIO, "Can't open tables endpoint", e);
                return null;
            }
            if (code == 404) {
                msg = new StringBuffer().append("/tables resource, recommended but not required,").append(" is absent - ").append(code).append(" at ").append(turl).toString();
                reporter.report(FixedCode.W_TBNF, msg);
                if (Boolean.TRUE.equals(declaresTables)) {
                    reporter.report(FixedCode.E_TADH, "Tables endpoint declared but absent");
                }
                return null;
            }
            if (code != 200) {
                msg = new StringBuffer().append("HTTP response ").append(code).append(" from /tables endpoint").append(" - should be 200 or 404").toString();
                reporter.report(FixedCode.E_FLIO, msg);
                return null;
            }
        }
        if (Boolean.FALSE.equals(declaresTables)) {
            boolean is11 = tapService.getTapVersion().is11();
            reporter.report(is11 ? FixedCode.E_TADH : FixedCode.W_TADH, "Tables endpoint present but undeclared");
        }
        try {
            in = new BufferedInputStream(this.coding_.getInputStream(conn));
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FLIO, "Error reading from /tables endpoint", e);
            return null;
        }
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setNamespaceAware(false);
            spfact.setValidating(false);
            parser = spfact.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            reporter.report(FixedCode.F_CAPC, "Trouble setting up XML parse", e);
            return null;
        }
        catch (SAXException e) {
            reporter.report(FixedCode.F_CAPC, "Trouble setting up XML parse", e);
            return null;
        }
        try {
            TableSetSaxHandler handler = new TableSetSaxHandler();
            parser.parse((InputStream)in, (DefaultHandler)handler);
            populatedHandler = handler;
        }
        catch (SAXException e) {
            reporter.report(FixedCode.E_FLSX, "Can't parse table metadata well enough to check it", e);
            return null;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FLIO, "Error reading table metadata", e);
            return null;
        }
        ArrayList<SchemaMeta> schemaList = new ArrayList<SchemaMeta>();
        schemaList.addAll(Arrays.asList(populatedHandler.getSchemas(false)));
        TableMeta[] nakedTables = populatedHandler.getNakedTables();
        int nNaked = nakedTables.length;
        if (nNaked > 0) {
            String msg = new StringBuffer().append(nNaked).append(" tables declared outside of any schema ").toString();
            reporter.report(FixedCode.E_NAKT, msg);
            SchemaMeta dummySchema = SchemaMeta.createDummySchema((String)"<no_schema>");
            dummySchema.setTables(nakedTables);
            schemaList.add(dummySchema);
        }
        final SchemaMeta[] smetas = schemaList.toArray(new SchemaMeta[0]);
        final boolean hasDetail = this.hasDetail(reporter, turl, smetas, isVosi11);
        return new MetadataHolder(){

            @Override
            public SchemaMeta[] getTableMetadata() {
                return smetas;
            }

            @Override
            public boolean hasDetail() {
                return hasDetail;
            }
        };
    }

    private boolean hasDetail(Reporter reporter, URL turl, SchemaMeta[] smetas, boolean isVosi11) {
        int nTable = 0;
        int nColDetail = 0;
        int nKeyDetail = 0;
        for (SchemaMeta smeta : smetas) {
            for (TableMeta tmeta : smeta.getTables()) {
                ++nTable;
                ColumnMeta[] cmetas = tmeta.getColumns();
                ForeignMeta[] fmetas = tmeta.getForeignKeys();
                if (cmetas != null && cmetas.length > 0) {
                    ++nColDetail;
                }
                if (fmetas == null || fmetas.length <= 0) continue;
                ++nKeyDetail;
            }
        }
        if (nColDetail == 0) {
            if (isVosi11) {
                reporter.report(FixedCode.I_CDET, "No column detail returned from " + turl);
            } else {
                reporter.report(FixedCode.W_CDET, "No column detail returned from VOSI 1.0 endpoint " + turl);
            }
            return false;
        }
        if (nColDetail == nTable) {
            return true;
        }
        assert (nColDetail < nTable);
        String msg = "Column detail returned for " + nColDetail + "/" + nTable + " tables from " + turl;
        reporter.report(FixedCode.W_CDET, msg);
        return false;
    }
}

