/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.ConcatStarTable;
import uk.ac.starlink.table.ConstantColumn;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.MetaCopyStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.SeqConcatStarTable;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.util.Bi;

public class CatMapper
implements TableMapper {
    private final StringParameter seqParam_;
    private final StringParameter locParam_;
    private final StringParameter ulocParam_;
    private final BooleanParameter lazyParam_;
    private final BooleanParameter countParam_;
    private final boolean hasLazy_;
    private static final ValueInfo SEQ_INFO = new DefaultValueInfo("iseq", Integer.class, "Sequence number of input table from concatenation operation");
    private static final ValueInfo LOC_INFO = new DefaultValueInfo("loc", String.class, "Location of input table from concatenation operation");
    private static final ValueInfo ULOC_INFO = new DefaultValueInfo("uloc", String.class, "Unique part of input table location from concatenation operation");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public CatMapper(boolean hasLazy) {
        this.hasLazy_ = hasLazy;
        this.seqParam_ = new StringParameter("seqcol");
        this.seqParam_.setUsage("<colname>");
        this.seqParam_.setNullPermitted(true);
        this.seqParam_.setStringDefault(null);
        this.seqParam_.setDescription(new String[]{"<p>Name of a column to be added to the output table", "which will contain the sequence number of the input table", "from which each row originated.", "This column will contain 1 for the rows from the first", "concatenated table, 2 for the second, and so on.", "</p>"});
        this.locParam_ = new StringParameter("loccol");
        this.locParam_.setUsage("<colname>");
        this.locParam_.setNullPermitted(true);
        this.locParam_.setStringDefault(null);
        this.locParam_.setDescription(new String[]{"<p>Name of a column to be added to the output table", "which will contain the location", "(as specified in the input parameter(s))", "of the input table from which each row originated.", "</p>"});
        this.ulocParam_ = new StringParameter("uloccol");
        this.ulocParam_.setUsage("<colname>");
        this.ulocParam_.setNullPermitted(true);
        this.ulocParam_.setStringDefault(null);
        this.ulocParam_.setDescription(new String[]{"<p>Name of a column to be added to the output table", "which will contain the unique part of the location", "(as specified in the input parameter(s))", "of the input table from which each row originated.", "If not null, parameters will also be added to the output table", "giving the pre- and post-fix string common to all the locations.", "For example, if the input tables are \"/data/cat_a1.fits\"", "and \"/data/cat_b2.fits\" then the output table will contain", "a new column &lt;colname&gt; which takes the value", "\"a1\" for rows from the first table and", "\"b2\" for rows from the second, and new parameters", "\"" + CatMapper.prefixParamName("&lt;colname&gt;") + "\" and", "\"" + CatMapper.postfixParamName("&lt;colname&gt;") + "\"", "with the values \"/data/cat_\" and \".fits\" respectively.", "</p>"});
        this.lazyParam_ = new BooleanParameter("lazy");
        this.lazyParam_.setBooleanDefault(false);
        this.lazyParam_.setDescription(new String[]{"<p>Whether to perform table resolution lazily.", "If true, each table is only accessed when the time comes to", "add its rows to the output; if false, then all the tables are", "accessed up front.  This is mostly a tuning parameter,", "and on the whole it doesn't matter much how it is set,", "but for joining an enormous number of tables setting it true", "may avoid running out of resources.", "</p>"});
        this.countParam_ = new BooleanParameter("countrows");
        this.countParam_.setBooleanDefault(false);
        this.countParam_.setDescription(new String[]{"<p>Whether to count the rows in the table before starting", "the output.  This is essentially a tuning parameter -", "if writing to an output format which requires the number", "of rows up front (such as normal FITS) it may result in", "skipping the number of passes through the input files required", "for processing.  Unless you have a good understanding of", "the internals of the software, your best bet for working", "out whether to set this true or false is to try it both", "ways", "</p>"});
    }

    @Override
    public Parameter<?>[] getParameters() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(this.seqParam_);
        paramList.add(this.locParam_);
        paramList.add(this.ulocParam_);
        if (this.hasLazy_) {
            paramList.add(this.lazyParam_);
        }
        paramList.add(this.countParam_);
        return paramList.toArray(new Parameter[0]);
    }

    @Override
    public TableMapping createMapping(Environment env, int nin) throws TaskException {
        String seqCol = this.seqParam_.stringValue(env);
        String locCol = this.locParam_.stringValue(env);
        String ulocCol = this.ulocParam_.stringValue(env);
        boolean lazy = this.hasLazy_ ? this.lazyParam_.booleanValue(env) : false;
        boolean countRows = this.countParam_.booleanValue(env);
        return new CatMapping(seqCol, locCol, ulocCol, lazy, countRows);
    }

    private static String prefixParamName(String colName) {
        return colName + "_prefix";
    }

    private static String postfixParamName(String colName) {
        return colName + "_postfix";
    }

    private static StarTable createConstantsTable(final StarTable template, final List<Bi<ColumnInfo, Object>> constCols) {
        if (template.isRandom()) {
            ColumnStarTable cTable = ColumnStarTable.makeTableWithRows((long)template.getRowCount());
            for (Bi<ColumnInfo, Object> bi : constCols) {
                cTable.addColumn((ColumnData)new ConstantColumn((ColumnInfo)bi.getItem1(), bi.getItem2()));
            }
            return cTable;
        }
        final Object[] row = constCols.stream().map(c -> c.getItem2()).toArray(Object[]::new);
        return new AbstractStarTable(){

            public long getRowCount() {
                return template.getRowCount();
            }

            public int getColumnCount() {
                return constCols.size();
            }

            public ColumnInfo getColumnInfo(int icol) {
                return (ColumnInfo)((Bi)constCols.get(icol)).getItem1();
            }

            public RowSequence getRowSequence() {
                return new RowSequence(){

                    public Object getCell(int icol) {
                        return row[icol];
                    }

                    public Object[] getRow() {
                        return (Object[])row.clone();
                    }

                    public boolean next() {
                        return true;
                    }

                    public void close() {
                    }
                };
            }
        };
    }

    static {
        ((DefaultValueInfo)SEQ_INFO).setNullable(false);
    }

    private static class Trimmer {
        private final String pre_;
        private final String post_;
        private final int locLeng_;
        private final int ulocLeng_;

        public Trimmer(String[] locs, boolean preTrim, boolean postTrim) {
            int npost;
            int npre;
            int nloc = locs.length;
            String loc0 = locs[0];
            int leng = loc0.length();
            for (int iloc = 0; iloc < nloc; ++iloc) {
                leng = Math.min(leng, locs[iloc].length());
            }
            if (preTrim) {
                int np = -1;
                for (int ic = 0; ic < leng && np < 0; ++ic) {
                    char c = loc0.charAt(ic);
                    for (int iloc = 0; iloc < nloc; ++iloc) {
                        if (locs[iloc].charAt(ic) == c) continue;
                        np = ic;
                    }
                }
                npre = np;
            } else {
                npre = 0;
            }
            String string = this.pre_ = npre >= 0 ? loc0.substring(0, npre) : "";
            if (postTrim) {
                int np = -1;
                for (int ic = 0; ic < leng && np < 0; ++ic) {
                    char c = loc0.charAt(loc0.length() - 1 - ic);
                    for (int iloc = 0; iloc < nloc; ++iloc) {
                        if (locs[iloc].charAt(locs[iloc].length() - 1 - ic) == c) continue;
                        np = ic;
                    }
                }
                npost = np;
            } else {
                npost = 0;
            }
            this.post_ = npost >= 0 ? loc0.substring(loc0.length() - npost) : "";
            int locLeng = 0;
            int ulocLeng = 0;
            for (int i = 0; i < nloc; ++i) {
                String loc = locs[i];
                locLeng = Math.max(locLeng, loc.length());
                ulocLeng = Math.max(ulocLeng, this.trim(loc).length());
            }
            this.locLeng_ = locLeng;
            this.ulocLeng_ = ulocLeng;
        }

        public String getPrefix() {
            return this.pre_;
        }

        public String getPostfix() {
            return this.post_;
        }

        public int getLocLength() {
            return this.locLeng_;
        }

        public int getTrimmedLocLength() {
            return this.ulocLeng_;
        }

        public String trim(String loc) {
            if (loc.startsWith(this.pre_) && loc.endsWith(this.post_)) {
                return loc.substring(this.pre_.length(), loc.length() - this.post_.length());
            }
            throw new IllegalArgumentException();
        }
    }

    private static class CatMapping
    implements TableMapping {
        private final String seqCol_;
        private final String locCol_;
        private final String ulocCol_;
        private final boolean lazy_;
        private final boolean countRows_;

        CatMapping(String seqCol, String locCol, String ulocCol, boolean lazy, boolean countRows) {
            this.seqCol_ = seqCol;
            this.locCol_ = locCol;
            this.ulocCol_ = ulocCol;
            this.lazy_ = lazy;
            this.countRows_ = countRows;
        }

        @Override
        public StarTable mapTables(final InputTableSpec[] inSpecs) throws IOException, TaskException {
            WrapperStarTable out;
            int nTable = inSpecs.length;
            String[] locations = new String[nTable];
            for (int i = 0; i < nTable; ++i) {
                locations[i] = inSpecs[i].getLocation();
            }
            boolean trim = this.ulocCol_ != null;
            final Trimmer trimmer = new Trimmer(locations, trim, trim);
            TableProducer[] tProds = new TableProducer[nTable];
            for (int i = 0; i < nTable; ++i) {
                final int index = i;
                tProds[i] = new TableProducer(){

                    @Override
                    public StarTable getTable() throws IOException, TaskException {
                        return this.getTable(inSpecs[index], index, trimmer);
                    }
                };
            }
            if (this.lazy_) {
                StarTable meta = tProds[0].getTable();
                out = new SeqConcatStarTable(meta, tProds);
            } else {
                StarTable[] inTables = new StarTable[nTable];
                for (int i = 0; i < nTable; ++i) {
                    inTables[i] = tProds[i].getTable();
                }
                MetaCopyStarTable t0 = new MetaCopyStarTable(inTables[0]);
                ColumnInfo[] colInfos = ConcatStarTable.extendColumnTypes((ColumnInfo[])Tables.getColumnInfos((StarTable)t0), (StarTable[])inTables);
                for (int ic = 0; ic < colInfos.length; ++ic) {
                    t0.setColumnInfo(ic, colInfos[ic]);
                }
                out = new ConcatStarTable((StarTable)t0, inTables);
            }
            if (this.lazy_ && this.countRows_ && out.getRowCount() < 0L) {
                long nr = 0L;
                for (int i = 0; i < nTable && nr >= 0L; ++i) {
                    try (StarTable t = tProds[i].getTable();){
                        long n = t.getRowCount();
                        nr = n >= 0L ? nr + n : -1L;
                        continue;
                    }
                }
                if (nr >= 0L) {
                    final long nrow = nr;
                    out = new WrapperStarTable((StarTable)out){

                        public long getRowCount() {
                            return nrow;
                        }
                    };
                }
            }
            if (this.ulocCol_ != null) {
                String preDesc = "String prepended to " + this.ulocCol_ + " column to form source table location";
                String postDesc = "String appended to " + this.ulocCol_ + " column to form source table location";
                DefaultValueInfo preInfo = new DefaultValueInfo(CatMapper.prefixParamName(this.ulocCol_), String.class, preDesc);
                DefaultValueInfo postInfo = new DefaultValueInfo(CatMapper.postfixParamName(this.ulocCol_), String.class, postDesc);
                String pre = trimmer.getPrefix();
                String post = trimmer.getPostfix();
                List outParams = out.getParameters();
                if (pre.trim().length() > 0) {
                    outParams.add(new DescribedValue((ValueInfo)preInfo, (Object)pre));
                }
                if (post.trim().length() > 0) {
                    outParams.add(new DescribedValue((ValueInfo)postInfo, (Object)post));
                }
            }
            return out;
        }

        private StarTable getTable(InputTableSpec inSpec, int index, Trimmer trimmer) throws IOException, TaskException {
            StarTable addTable;
            StarTable inTable = inSpec.getWrappedTable();
            ArrayList<Bi> addList = new ArrayList<Bi>();
            if (this.seqCol_ != null) {
                ColumnInfo seqInfo = new ColumnInfo(SEQ_INFO);
                seqInfo.setName(this.seqCol_);
                Integer iseq = index + 1;
                addList.add(new Bi((Object)seqInfo, (Object)iseq));
            }
            if (this.locCol_ != null) {
                ColumnInfo locInfo = new ColumnInfo(LOC_INFO);
                locInfo.setName(this.locCol_);
                locInfo.setElementSize(trimmer.getLocLength());
                String loc = inSpec.getLocation();
                addList.add(new Bi((Object)locInfo, (Object)loc));
            }
            if (this.ulocCol_ != null) {
                ColumnInfo ulocInfo = new ColumnInfo(ULOC_INFO);
                ulocInfo.setName(this.ulocCol_);
                ulocInfo.setElementSize(trimmer.getTrimmedLocLength());
                String uloc = trimmer.trim(inSpec.getLocation());
                addList.add(new Bi((Object)ulocInfo, (Object)uloc));
            }
            return (addTable = CatMapper.createConstantsTable(inTable, addList)).getColumnCount() > 0 ? new JoinStarTable(new StarTable[]{inTable, addTable}) : inTable;
        }
    }
}

