/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.InputStreamParameter;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.ttools.votlint.DoctypeInterpolator;
import uk.ac.starlink.ttools.votlint.PrintSaxMessager;
import uk.ac.starlink.ttools.votlint.SaxMessager;
import uk.ac.starlink.ttools.votlint.VersionDetector;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.ttools.votlint.VotLinter;
import uk.ac.starlink.util.Destination;
import uk.ac.starlink.votable.VOTableVersion;

public class VotLint
implements Task {
    private final InputStreamParameter inParam_ = new InputStreamParameter("votable");
    private final BooleanParameter validParam_;
    private final BooleanParameter ucdParam_;
    private final BooleanParameter unitParam_;
    private final IntegerParameter maxrepeatParam_;
    private final ChoiceParameter<VOTableVersion> versionParam_;
    private final OutputStreamParameter outParam_;

    public VotLint() {
        this.inParam_.setPosition(1);
        this.inParam_.setPrompt("VOTable location");
        this.inParam_.setDescription(new String[]{"<p>Location of the VOTable to be checked.", "This may be a filename, URL or \"-\" (the default),", "to indicate standard input.", "The input may be compressed using one of the known", "compression formats (Unix compress, gzip or bzip2).", "</p>"});
        this.ucdParam_ = new BooleanParameter("ucd");
        this.ucdParam_.setBooleanDefault(true);
        this.ucdParam_.setPrompt("Check ucd attributes for UCD1+ syntax?");
        this.ucdParam_.setDescription(new String[]{"<p>If true, the <code>ucd</code> attributes", "on FIELD and PARAM elements etc", "are checked for conformance against the UCD1+ standard", "or a list of known UCD1 terms.", "</p>"});
        this.unitParam_ = new BooleanParameter("unit");
        this.unitParam_.setNullPermitted(true);
        this.unitParam_.setPrompt("Check unit attributes for VOUnit syntax?");
        this.unitParam_.setDescription(new String[]{"<p>If true, the <code>unit</code> attributes", "on FIELD and PARAM elements", "are checked for conformance against the VOUnits standard;", "if false, no such checks are made.", "</p>", "<p>The VOTable standard version 1.4 and later", "recommends use of VOUnits", "(there are some inconsistencies in the text on this topic", "in VOTable 1.4, but these are cleared up in V1.5).", "Earlier VOTable versions refer to a different (CDS) unit syntax,", "which is not checked by <code>votlint</code>.", "So by default unit syntax is checked when the VOTable is 1.4", "or greater, and not for earlier versions,", "but that can be overridden by giving a <code>true</code>", "or <code>false</code> value for this parameter.", "</p>", "<p>The wording of the VOTable and VOUnit standards", "do not strictly require use of VOUnit syntax even at VOTable 1.4,", "so failed checks result in Warning rather than Error reports.", "</p>"});
        this.validParam_ = new BooleanParameter("validate");
        this.validParam_.setBooleanDefault(true);
        this.validParam_.setPrompt("Validate against VOTable DTD?");
        this.validParam_.setDescription(new String[]{"<p>Whether to validate the input document aganist", "the VOTable DTD.", "If true (the default), then as well as", "<code>votlint</code>'s own checks,", "it is validated against an appropriate version of the VOTable", "DTD which picks up such things as the presence of", "unknown elements and attributes, elements in the wrong place,", "and so on.", "Sometimes however, particularly when XML namespaces are", "involved, the validator can get confused and may produce", "a lot of spurious errors.  Setting this flag false prevents", "this validation step so that only <code>votlint</code>'s", "own checks are performed.", "In this case many violations of the VOTable standard", "concerning document structure will go unnoticed.", "</p>"});
        this.maxrepeatParam_ = new IntegerParameter("maxrepeat");
        this.maxrepeatParam_.setIntDefault(4);
        this.maxrepeatParam_.setPrompt("Maximum repeats of similar message");
        this.maxrepeatParam_.setDescription(new String[]{"<p>Puts a limit on the number of times that the same issue", "will be reported.", "With this set to a relatively small number,", "the output is not cluttered with many repetitions of", "the same problem.", "</p>"});
        this.versionParam_ = new ChoiceParameter("version", (Object[])VOTableVersion.getKnownVersions().values().toArray(new VOTableVersion[0]));
        this.versionParam_.setNullPermitted(true);
        this.versionParam_.setPrompt("VOTable standard version");
        this.versionParam_.setDescription(new String[]{"<p>Selects the version of the VOTable standard which the input", "table is supposed to exemplify.", "The version may also be specified within the document", "using the \"version\" attribute of the document's VOTABLE", "element; if it is and it conflicts with the value specified", "by this flag, a warning is issued.", "</p>", "<p>If no value is provided for this parameter (the default),", "the version will be determined from the VOTable itself.", "</p>"});
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPrompt("File for output messages");
        this.outParam_.setUsage("<location>");
        this.outParam_.setStringDefault("-");
        this.outParam_.setDescription(new String[]{"<p>Destination file for output messages.", "May be a filename or \"-\" to indicate standard output.", "</p>"});
    }

    public String getPurpose() {
        return "Validates VOTable documents";
    }

    public Parameter<?>[] getParameters() {
        return new Parameter[]{this.inParam_, this.ucdParam_, this.unitParam_, this.maxrepeatParam_, this.validParam_, this.versionParam_, this.outParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        PrintStream out;
        VOTableVersion version = (VOTableVersion)this.versionParam_.objectValue(env);
        boolean validate = this.validParam_.booleanValue(env);
        boolean ucd = this.ucdParam_.booleanValue(env);
        Boolean unitPref = (Boolean)this.unitParam_.objectValue(env);
        int maxRepeat = this.maxrepeatParam_.intValue(env);
        boolean debug = env instanceof TableEnvironment && ((TableEnvironment)env).isDebug();
        String sysid = this.inParam_.stringValue(env);
        InputStream in = (InputStream)this.inParam_.objectValue(env);
        try {
            out = new PrintStream(((Destination)this.outParam_.objectValue(env)).createStream());
        }
        catch (IOException e) {
            throw new UsageException("Can't open \"" + this.outParam_.stringValue(env) + "\" for output: " + e.getMessage(), (Throwable)e);
        }
        PrintSaxMessager messager = new PrintSaxMessager(out, debug, maxRepeat);
        return new VotLintExecutable(in, version, ucd, unitPref, validate, sysid, messager);
    }

    static class VotLintExecutable
    implements Executable {
        final InputStream baseIn_;
        final VOTableVersion forceVersion_;
        final boolean ucd_;
        final Boolean unitPref_;
        final boolean validate_;
        final String sysid_;
        final SaxMessager messager_;

        VotLintExecutable(InputStream in, VOTableVersion forceVersion, boolean ucd, Boolean unitPref, boolean validate, String sysid, SaxMessager messager) {
            this.baseIn_ = in;
            this.forceVersion_ = forceVersion;
            this.ucd_ = ucd;
            this.unitPref_ = unitPref;
            this.validate_ = validate;
            this.sysid_ = sysid;
            this.messager_ = messager;
        }

        public void execute() throws IOException, ExecutionException {
            VOTableVersion version;
            BufferedInputStream bufIn = new BufferedInputStream(this.baseIn_);
            if (this.forceVersion_ != null) {
                version = this.forceVersion_;
            } else {
                String foundVersStr = VersionDetector.getVersionString(bufIn);
                VOTableVersion foundVersion = (VOTableVersion)VOTableVersion.getKnownVersions().get(foundVersStr);
                if (foundVersion != null) {
                    version = foundVersion;
                } else {
                    Locator noloc = null;
                    this.messager_.reportMessage(SaxMessager.Level.INFO, new VotLintCode("WTV"), "Unable to determine VOTable version from document", noloc);
                    version = VOTableVersion.getDefaultVersion();
                    this.messager_.reportMessage(SaxMessager.Level.INFO, new VotLintCode("ASV"), "Assuming VOTable v" + version + " by default", noloc);
                }
            }
            String votDraftId = version.getDraftIdentifier();
            if (votDraftId != null) {
                this.messager_.reportMessage(SaxMessager.Level.WARNING, new VotLintCode("DRF"), "Validating against draft version of VOTable standard: " + votDraftId, null);
            }
            assert (version != null);
            final VotLintContext context = new VotLintContext(version, this.validate_, this.messager_);
            context.setCheckUcd(this.ucd_);
            context.setCheckUnit(this.unitPref_ == null ? version.isVOUnitSyntax() : this.unitPref_.booleanValue());
            InputStream in = this.validate_ && version.getDoctypeDeclaration() != null ? new DoctypeInterpolator(){

                @Override
                public void message(String msg) {
                    context.info(new VotLintCode("DOC"), msg);
                }
            }.getStreamWithDoctype(bufIn) : bufIn;
            InputSource sax = new InputSource(in);
            sax.setSystemId(this.sysid_);
            try {
                new VotLinter(context).createParser(null).parse(sax);
            }
            catch (SAXException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

