/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.util.IOUtils;

public class DoctypeInterpolator {
    private static final Pattern XMLDECL_PATTERN = Pattern.compile("<\\?[Xx][Mm][Ll][^\\?]*\\?>");
    private static String VOTABLE_DECL = "<!DOCTYPE VOTABLE PUBLIC '-//votlint//VOTable.dtd' 'file:///dummylocation/VOTable.dtd'>";
    private boolean used_;
    private String votableVersion_;

    public InputStream getStreamWithDoctype(BufferedInputStream in) throws IOException {
        if (this.used_) {
            throw new IllegalStateException("This interpolator already used");
        }
        this.used_ = true;
        assert (in.markSupported());
        int[] tryLengths = new int[]{2048, 16384, 262144};
        for (int i = 0; i < tryLengths.length; ++i) {
            boolean fullyRead;
            int leng = tryLengths[i];
            in.mark(leng);
            byte[] buf = IOUtils.readBytes((InputStream)in, (int)leng);
            Boolean hasDoctype = this.hasDoctype(buf);
            if (hasDoctype != null) {
                if (!hasDoctype.booleanValue()) {
                    buf = this.interpolateDoctype(buf);
                }
                ByteArrayInputStream s1 = new ByteArrayInputStream(buf);
                BufferedInputStream s2 = in;
                return new SequenceInputStream(s1, s2);
            }
            in.reset();
            boolean bl = fullyRead = buf.length < leng;
            if (fullyRead) break;
        }
        this.message("Can't detect whether a Document Type Declaration is present");
        return in;
    }

    public String getVotableVersion() {
        return this.votableVersion_;
    }

    public void message(String msg) {
        System.err.println(msg);
    }

    private Boolean hasDoctype(byte[] buf) {
        XMLReader parser;
        DeclarationChecker declCheck = new DeclarationChecker();
        try {
            parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(declCheck);
            parser.setEntityResolver(declCheck);
            parser.setErrorHandler(declCheck);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", declCheck);
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        try {
            parser.parse(new InputSource(new ByteArrayInputStream(buf)));
        }
        catch (DoneException e) {
            return declCheck.hasDoctype();
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    private byte[] interpolateDoctype(byte[] buf) {
        String[] encodings = new String[]{"UTF-8", "UTF-16BE", "UTF-16LE"};
        for (int i = 0; i < encodings.length; ++i) {
            String encoding = encodings[i];
            try {
                String content = new String(buf, encoding);
                Matcher matcher = XMLDECL_PATTERN.matcher(content);
                if (!matcher.find()) continue;
                return matcher.replaceFirst(matcher.group(0) + VOTABLE_DECL).getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                assert (false) : "Unsupported encoding " + encoding + "?";
                continue;
            }
        }
        String encoding = "UTF-8";
        int bomleng = 0;
        if (buf.length > 2) {
            if (buf[0] == -2 && buf[1] == -1) {
                encoding = "UTF-16BE";
                bomleng = 2;
            } else if (buf[0] == -1 && buf[1] == -2) {
                encoding = "UTF-16LE";
                bomleng = 2;
            }
        }
        try {
            byte[] prebuf = VOTABLE_DECL.getBytes(encoding);
            byte[] fullbuf = new byte[prebuf.length + buf.length];
            System.arraycopy(buf, 0, fullbuf, 0, bomleng);
            System.arraycopy(prebuf, 0, fullbuf, bomleng, prebuf.length);
            System.arraycopy(buf, bomleng, fullbuf, bomleng + prebuf.length, buf.length - bomleng);
            return fullbuf;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)("Unsupported encoding " + encoding + "?"));
        }
    }

    public static void main(String[] args) throws IOException {
        int c;
        InputStream in = new DoctypeInterpolator().getStreamWithDoctype(new BufferedInputStream(System.in));
        while ((c = in.read()) >= 0) {
            System.out.write(c);
        }
    }

    private static class DoneException
    extends SAXException {
        DoneException() {
            super("Successful completion");
        }
    }

    private class DeclarationChecker
    extends DefaultHandler
    implements ContentHandler,
    EntityResolver,
    ErrorHandler,
    LexicalHandler {
        private Boolean hasDoctype_;

        private DeclarationChecker() {
        }

        public Boolean hasDoctype() {
            return this.hasDoctype_;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws DoneException {
            if (this.hasDoctype_ == null) {
                this.hasDoctype_ = Boolean.FALSE;
            }
            if ("VOTABLE".equals(localName) || qName != null && (qName.equals("VOTABLE") || qName.endsWith(":VOTABLE"))) {
                DoctypeInterpolator.this.votableVersion_ = atts.getValue("version");
            }
            throw new DoneException();
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
            this.hasDoctype_ = Boolean.TRUE;
        }

        @Override
        public void warning(SAXParseException e) {
        }

        @Override
        public void error(SAXParseException e) {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw (DoneException)new DoneException().initCause(e);
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void startCDATA() {
        }

        @Override
        public void endCDATA() {
        }

        @Override
        public void startEntity(String name) {
        }

        @Override
        public void endEntity(String name) {
        }

        @Override
        public void comment(char[] ch, int start, int length) {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

