/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.dom.DelegatingDocument;
import uk.ac.starlink.votable.dom.DelegatingElement;

public class VOElement
extends DelegatingElement {
    private final int iseq_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    VOElement(Element base, VODocument doc) {
        super(base, (DelegatingDocument)doc);
        this.iseq_ = doc.getElementCount(doc.getVOTagName(this)) - 1;
    }

    VOElement(Element base, VODocument doc, String tagname) {
        this(base, doc);
        String voTagname = doc.getVOTagName(this);
        if (!voTagname.equals(tagname)) {
            throw new IllegalArgumentException("Unsuitable Element: " + voTagname + " != " + tagname);
        }
    }

    public String getDescription() {
        VOElement descEl = this.getChildByName("DESCRIPTION");
        return descEl == null ? null : DOMUtils.getTextContent(descEl);
    }

    public String getID() {
        return this.hasAttribute("ID") ? this.getAttribute("ID") : null;
    }

    public String getName() {
        return this.hasAttribute("name") ? this.getAttribute("name") : null;
    }

    public VOElement getParent() {
        Node pnode = this.getParentNode();
        if (pnode != null && pnode instanceof VOElement) {
            return (VOElement)pnode;
        }
        if (pnode instanceof Element) {
            throw new AssertionError();
        }
        return null;
    }

    public VOElement[] getChildren() {
        ArrayList<VOElement> children = new ArrayList<VOElement>();
        for (Node ch = this.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (ch instanceof VOElement) {
                children.add((VOElement)ch);
                continue;
            }
            if (ch instanceof Element) {
                throw new AssertionError();
            }
        }
        return children.toArray(new VOElement[0]);
    }

    public VOElement[] getChildrenByName(String votagname) {
        ArrayList<VOElement> children = new ArrayList<VOElement>();
        for (Node ch = this.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element) || !this.getVOTagName((Element)ch).equals(votagname)) continue;
            assert (ch instanceof VOElement);
            children.add((VOElement)ch);
        }
        return children.toArray(new VOElement[0]);
    }

    public VOElement getChildByName(String votagname) {
        for (Node ch = this.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element) || !this.getVOTagName((Element)ch).equals(votagname)) continue;
            assert (ch instanceof VOElement);
            return (VOElement)ch;
        }
        return null;
    }

    public String toString() {
        return this.getHandle();
    }

    public String getHandle() {
        String handle = "";
        if (handle.length() == 0) {
            handle = this.getAttribute("name");
        }
        if (handle.length() == 0) {
            handle = this.getAttribute("ID");
        }
        if (handle.length() == 0) {
            handle = this.getAttribute("ucd");
        }
        if (handle.length() == 0) {
            handle = this.getVOTagName();
        }
        handle = handle.replaceFirst("\n.*", "");
        handle = handle.trim();
        return handle;
    }

    public String getSystemId() {
        return ((VODocument)this.getOwnerDocument()).getSystemId();
    }

    URL getContextURL(String href) {
        return URLUtils.makeURL(((VODocument)this.getOwnerDocument()).getSystemId(), href);
    }

    public String getVOTagName() {
        return this.getVOTagName(this);
    }

    public int getElementSequence() {
        return this.iseq_;
    }

    public VOElement getReferencedElement(String refAtt, String votagname) {
        if (this.hasAttribute(refAtt)) {
            String ref = this.getAttribute(refAtt);
            Document doc = this.getOwnerDocument();
            if (ref != null && ref.trim().length() > 0 && doc != null) {
                Element refEl = doc.getElementById(ref);
                if (refEl instanceof VOElement && votagname.equals(this.getVOTagName(refEl))) {
                    return (VOElement)refEl;
                }
                if (refEl == null) {
                    String msg = new StringBuffer().append("Failed to find element referenced from <").append(this.getTagName()).append(" ").append(refAtt).append("='").append(ref).append("'/>").toString();
                    logger_.warning(msg);
                }
            }
        }
        return null;
    }

    public NodeList getElementsByVOTagName(String voTagName) {
        final ArrayList<Element> findList = new ArrayList<Element>();
        this.addChildrenByVOTagName(this, voTagName, findList);
        return new NodeList(){

            @Override
            public int getLength() {
                return findList.size();
            }

            @Override
            public Node item(int i) {
                return (Node)findList.get(i);
            }
        };
    }

    private void addChildrenByVOTagName(Element el, String voTagName, List<Element> elList) {
        for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childEl = (Element)child;
            if (voTagName.equals(this.getVOTagName(childEl))) {
                elList.add(childEl);
            }
            this.addChildrenByVOTagName(childEl, voTagName, elList);
        }
    }

    private String getVOTagName(Element el) {
        Document doc = el.getOwnerDocument();
        return doc instanceof VODocument ? ((VODocument)doc).getVOTagName(el) : el.getTagName();
    }
}

