/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.MouseInputAdapter;
import uk.ac.starlink.table.join.EllipseCartesianMatchEngine;
import uk.ac.starlink.table.join.EllipseSkyMatchEngine;

public class EllipseToy
extends JComponent {
    private static Stroke DASHES = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);

    private static void setAntialias(Graphics2D g2, boolean on) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, on ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void main(String[] args) {
        String usage = "Usage: " + EllipseToy.class.getName() + " [-sky] [-[no]circles]";
        JFrame frame = new JFrame();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean sky = false;
        boolean recogniseCircles = true;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-sky")) {
                it.remove();
                sky = true;
                continue;
            }
            if (arg.startsWith("-circ")) {
                it.remove();
                recogniseCircles = true;
                continue;
            }
            if (arg.startsWith("-nocirc")) {
                it.remove();
                recogniseCircles = false;
                continue;
            }
            if (arg.startsWith("-h")) {
                System.out.println(usage);
                return;
            }
            System.err.println(usage);
            System.exit(1);
        }
        if (!argList.isEmpty()) {
            System.err.println(usage);
            System.exit(1);
        }
        frame.add(sky ? new SkyEllipseToy(recogniseCircles) : new CartesianEllipseToy(recogniseCircles));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static class Ellipse {
        int x_;
        int y_;
        int a_;
        int b_;
        double theta_;

        Ellipse(int x, int y, int a, int b, double theta) {
            this.x_ = x;
            this.y_ = y;
            this.a_ = a;
            this.b_ = b;
            this.theta_ = theta;
        }

        Ellipse(Ellipse e) {
            this(e.x_, e.y_, e.a_, e.b_, e.theta_);
        }

        public String toString() {
            return new Formatter().format("a=%3d b=%3d x=%3d y=%3d theta=%3d", this.a_, this.b_, this.x_, this.y_, (int)(this.theta_ * 180.0 / Math.PI)).toString();
        }

        public Changer getChanger(Point p, int tol) {
            boolean isPoint;
            final Point p0 = p;
            final Ellipse e0 = new Ellipse(this);
            final double ct = Math.cos(this.theta_);
            final double st = Math.sin(this.theta_);
            Point center = new Point(this.x_, this.y_);
            Point aPlus = new Point((int)((double)this.x_ + (double)this.a_ * ct), (int)((double)this.y_ - (double)this.a_ * st));
            Point bPlus = new Point((int)((double)this.x_ + (double)this.b_ * st), (int)((double)this.y_ + (double)this.b_ * ct));
            Point aMinus = new Point((int)((double)this.x_ - (double)this.a_ * ct), (int)((double)this.y_ + (double)this.a_ * st));
            Point bMinus = new Point((int)((double)this.x_ - (double)this.b_ * st), (int)((double)this.y_ - (double)this.b_ * ct));
            boolean bl = isPoint = this.a_ == 0 && this.b_ == 0;
            if (this.isClose(p, aPlus, tol) && !isPoint) {
                return new Changer(this){

                    @Override
                    public void submitChange(Point p1) {
                        a_ = e0.a_ + (int)((double)(p1.x - p0.x) * ct - (double)(p1.y - p0.y) * st);
                    }

                    @Override
                    public void multiClick(int nclick) {
                    }
                };
            }
            if (this.isClose(p, bPlus, tol) && !isPoint) {
                return new Changer(this){

                    @Override
                    public void submitChange(Point p1) {
                        b_ = e0.b_ + (int)((double)(p1.x - p0.x) * st + (double)(p1.y - p0.y) * ct);
                    }

                    @Override
                    public void multiClick(int nclick) {
                    }
                };
            }
            if (this.isClose(p, center, tol)) {
                return new Changer(this){

                    @Override
                    public void submitChange(Point p1) {
                        x_ = e0.x_ + p1.x - p0.x;
                        y_ = e0.y_ + p1.y - p0.y;
                    }

                    @Override
                    public void multiClick(int nclick) {
                        if (nclick == 2) {
                            int maxr;
                            a_ = maxr = Math.max(a_, b_);
                            b_ = maxr;
                        }
                    }
                };
            }
            if (this.isClose(p, aMinus, tol) || this.isClose(p, bMinus, tol)) {
                return new Changer(this){

                    @Override
                    public void submitChange(Point p1) {
                        theta_ = e0.theta_ - Math.atan2(p1.y - e0.y_, p1.x - e0.x_) + Math.atan2(p0.y - e0.y_, p0.x - e0.x_);
                        theta_ = (theta_ + Math.PI * 2) % (Math.PI * 2);
                    }

                    @Override
                    public void multiClick(int nclick) {
                    }
                };
            }
            return null;
        }

        boolean isClose(Point p1, Point p2, int tol) {
            return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y) <= tol * tol;
        }
    }

    private static abstract class Changer {
        private final Ellipse ellipse_;

        Changer(Ellipse ellipse) {
            this.ellipse_ = ellipse;
        }

        abstract void submitChange(Point var1);

        abstract void multiClick(int var1);
    }

    private static class Dragger
    extends MouseInputAdapter {
        private final Ellipse[] ellipses_;
        private final JComponent comp_;
        private Point p0_;
        private Ellipse e0_;
        private Changer changer_;
        private static final Cursor defaultCursor_ = Cursor.getDefaultCursor();
        private static final Cursor moveCursor_ = Cursor.getPredefinedCursor(13);
        private static final Cursor targetCursor_ = Cursor.getPredefinedCursor(12);

        Dragger(Ellipse[] ellipses, JComponent comp) {
            this.ellipses_ = ellipses;
            this.comp_ = comp;
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Changer changer = this.getChanger(evt);
            if (changer != null) {
                this.changer_ = changer;
                this.p0_ = evt.getPoint();
                this.e0_ = new Ellipse(changer.ellipse_);
                this.comp_.setCursor(moveCursor_);
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (this.changer_ != null) {
                this.changer_.submitChange(evt.getPoint());
                this.comp_.repaint(this.comp_.getBounds());
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            Changer changer = this.getChanger(evt);
            this.comp_.setCursor(changer == null ? defaultCursor_ : targetCursor_);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.changer_ = null;
            this.p0_ = null;
            this.e0_ = null;
            this.comp_.setCursor(defaultCursor_);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Changer changer = this.getChanger(evt);
            int nclick = evt.getClickCount();
            if (changer != null && nclick > 1) {
                changer.multiClick(nclick);
                this.comp_.repaint(this.comp_.getBounds());
            }
        }

        private Changer getChanger(MouseEvent evt) {
            Point p = evt.getPoint();
            for (int ie = 0; ie < this.ellipses_.length; ++ie) {
                Changer changer = this.ellipses_[ie].getChanger(p, 4);
                if (changer == null) continue;
                return changer;
            }
            return null;
        }
    }

    public static class SkyEllipseToy
    extends JComponent {
        private final boolean recogniseCircles_;
        private final Ellipse e1_;
        private final Ellipse e2_;

        public SkyEllipseToy(boolean recogniseCircles) {
            this.recogniseCircles_ = recogniseCircles;
            int qp = 180;
            this.setPreferredSize(new Dimension(qp * 4, qp * 2));
            this.e1_ = new Ellipse(qp, qp, (int)((double)qp * 0.15), (int)((double)qp * 0.1), 1.5707963267948966);
            this.e2_ = new Ellipse((int)((double)qp * 1.5), (int)((double)qp * 1.1), (int)((double)qp * 0.08), (int)((double)qp * 0.06), 0.5235987755982988);
            Dragger dragger = new Dragger(new Ellipse[]{this.e1_, this.e2_}, this){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    super.mouseDragged(evt);
                    int qp = this.getQuarterPixelCount();
                    this.normalizeEllipse(e1_, qp);
                    this.normalizeEllipse(e2_, qp);
                }
            };
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int qp = this.getQuarterPixelCount();
            Graphics2D g2 = (Graphics2D)g.create();
            this.paintSurface(g2, qp, this.e1_, this.e2_);
            g2.drawRect(0, 0, qp * 4, qp * 2);
            g2.setColor(new Color(0x808080));
            g2.drawLine(0, qp, qp * 4, qp);
            g2.setColor(Color.BLACK);
            EllipseToy.setAntialias(g2, true);
            this.paintEllipse(g2, this.e1_, qp);
            this.paintEllipse(g2, this.e2_, qp);
            EllipseSkyMatchEngine.Match match = EllipseSkyMatchEngine.getMatch(this.adaptEllipse(this.e1_, qp), this.adaptEllipse(this.e2_, qp), true);
            if (match != null) {
                Point p2;
                g2.setColor(Color.RED);
                g2.drawString(new Formatter().format("%4.2f", match.score_).toString(), Math.max(this.e1_.x_ + Math.max(this.e1_.a_, this.e1_.b_), this.e2_.x_ + Math.max(this.e2_.a_, this.e2_.b_)), Math.max(this.e1_.y_ + Math.max(this.e1_.a_, this.e1_.b_), this.e2_.y_ + Math.max(this.e2_.a_, this.e2_.b_)));
                Point p1 = Double.isNaN(match.alpha1_ + match.delta1_) ? null : new Point(this.alphaToX(match.alpha1_, qp), this.deltaToY(match.delta1_, qp));
                Point point = p2 = Double.isNaN(match.alpha2_ + match.delta2_) ? null : new Point(this.alphaToX(match.alpha2_, qp), this.deltaToY(match.delta2_, qp));
                if (p1 != null) {
                    g2.drawLine(this.e1_.x_, this.e1_.y_, p1.x, p1.y);
                }
                if (p2 != null) {
                    g2.drawLine(this.e2_.x_, this.e2_.y_, p2.x, p2.y);
                }
                if (p1 != null && p2 != null) {
                    Stroke str = g2.getStroke();
                    g2.setStroke(DASHES);
                    g2.drawLine(p1.x, p1.y, p2.x, p2.y);
                    g2.setStroke(str);
                }
            }
            this.paintProjections(g2, qp);
        }

        private int getQuarterPixelCount() {
            Rectangle bounds = this.getBounds();
            return Math.min(bounds.width / 4, bounds.height / 2);
        }

        private void paintEllipse(Graphics g, Ellipse e, int qp) {
            Graphics2D g2 = (Graphics2D)g.create();
            EllipseSkyMatchEngine.SkyEllipse se = this.adaptEllipse(e, qp);
            g2.setFont(g2.getFont().deriveFont(8.0f));
            g2.translate(e.x_, e.y_);
            g2.drawString("(" + (int)(se.alpha_ * 180.0 / Math.PI) + "," + (int)(se.delta_ * 180.0 / Math.PI) + ")", e.a_, e.b_);
            g2.rotate(-e.theta_);
            g2.drawLine(-e.a_, 0, e.a_, 0);
            g2.drawLine(0, -e.b_, 0, e.b_);
            g2.drawOval(-e.a_, -e.b_, 2 * e.a_, 2 * e.b_);
            g2 = (Graphics2D)g.create();
            g2.setFont(g2.getFont().deriveFont(10.0f));
            g2.setColor(new Color(0x404040));
            g2.translate(e.x_, e.y_);
            int paDeg = (int)(this.thetaToZeta(e.theta_) / Math.PI * 180.0);
            g2.drawArc(-20, -20, 40, 40, 90, -paDeg);
            g2.drawString("" + paDeg, 0, 0);
        }

        private void paintProjections(Graphics g, int qp) {
            Graphics2D g2 = (Graphics2D)g.create();
            EllipseSkyMatchEngine.SkyEllipse se1 = this.adaptEllipse(this.e1_, qp);
            EllipseSkyMatchEngine.SkyEllipse se2 = this.adaptEllipse(this.e2_, qp);
            double[] pt = EllipseSkyMatchEngine.bisect(se1.alpha_, se1.delta_, se2.alpha_, se2.delta_);
            EllipseSkyMatchEngine.Projector projector = new EllipseSkyMatchEngine.Projector(pt[0], pt[1]);
            EllipseCartesianMatchEngine.Ellipse ce1 = se1.project(projector);
            EllipseCartesianMatchEngine.Ellipse ce2 = se2.project(projector);
            g2.translate((this.e1_.x_ + this.e2_.x_) / 2, (this.e1_.y_ + this.e2_.y_) / 2);
            this.paintCartesianEllipse(g2, ce1, qp);
            this.paintCartesianEllipse(g2, ce2, qp);
        }

        private void paintCartesianEllipse(Graphics g, EllipseCartesianMatchEngine.Ellipse ce, int qp) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(Color.GREEN);
            double f = (double)(2 * qp) / Math.PI;
            int x = (int)(ce.x_ * f);
            int y = (int)(ce.y_ * f);
            int a = (int)(ce.a_ * f);
            int b = (int)(ce.b_ * f);
            double theta = ce.theta_;
            g2.translate(x, -y);
            g2.rotate(theta);
            g2.drawOval(-a, -b, 2 * a, 2 * b);
        }

        private double xToAlpha(int x, int qp) {
            double alpha = (double)x * Math.PI / 2.0 / (double)qp;
            return alpha;
        }

        private double yToDelta(int y, int qp) {
            double delta = (double)(qp - y) * Math.PI / 2.0 / (double)qp;
            return delta;
        }

        private double thetaToZeta(double theta) {
            double zeta = -theta + 1.5707963267948966;
            zeta = (zeta + Math.PI * 2) % (Math.PI * 2) - Math.PI;
            return zeta;
        }

        private int alphaToX(double alpha, int qp) {
            return (int)(alpha / Math.PI * 2.0 * (double)qp);
        }

        private int deltaToY(double delta, int qp) {
            return (int)(-delta / Math.PI * 2.0 * (double)qp) + qp;
        }

        private void normalizeEllipse(Ellipse e, int qp) {
            if (e.y_ < 0) {
                e.y_ = -e.y_;
                e.x_ += qp * 2;
            }
            if (e.y_ > qp * 2) {
                e.y_ = qp * 4 - e.y_;
                e.x_ -= qp * 2;
            }
            e.x_ = (e.x_ + qp * 4) % (qp * 4);
        }

        private EllipseSkyMatchEngine.SkyEllipse adaptEllipse(Ellipse e, int qp) {
            double alpha = this.xToAlpha(e.x_, qp);
            double delta = this.yToDelta(e.y_, qp);
            double mu = (double)e.a_ * Math.PI / 2.0 / (double)qp;
            double nu = (double)e.b_ * Math.PI / 2.0 / (double)qp;
            double zeta = this.thetaToZeta(e.theta_);
            return EllipseSkyMatchEngine.createSkyEllipse(alpha, delta, mu, nu, zeta, this.recogniseCircles_);
        }

        private void paintSurface(Graphics g, int qp, Ellipse e1, Ellipse e2) {
            Graphics2D g2 = (Graphics2D)g.create();
            EllipseToy.setAntialias(g2, false);
            EllipseSkyMatchEngine.SkyEllipse se1 = this.adaptEllipse(e1, qp);
            EllipseSkyMatchEngine.SkyEllipse se2 = this.adaptEllipse(e2, qp);
            Rectangle bounds = this.getBounds();
            int xmax = bounds.x + 4 * qp;
            int ymax = bounds.y + 2 * qp;
            int step = 4;
            for (int y = bounds.y; y < ymax; y += step) {
                double delta = this.yToDelta(y, qp);
                for (int x = bounds.x; x < xmax; x += step) {
                    double alpha = this.xToAlpha(x, qp);
                    double d1 = se1.getScaledDistance(alpha, delta);
                    double d2 = se2.getScaledDistance(alpha, delta);
                    double c1 = d1 < 1.0 ? d1 * 0.8 : 1.0;
                    double c2 = d2 < 1.0 ? d2 * 0.8 : 1.0;
                    float lev = (float)(c1 * c2 * 0.6 + 0.4);
                    Color c = new Color(lev, lev, 1.0f);
                    g2.setColor(c);
                    g2.fillRect(x, y, step, step);
                }
            }
        }
    }

    public static class CartesianEllipseToy
    extends JComponent {
        private final boolean recogniseCircles_;
        private final Ellipse e1_;
        private final Ellipse e2_;

        public CartesianEllipseToy(boolean recogniseCircles) {
            this.recogniseCircles_ = recogniseCircles;
            this.setPreferredSize(new Dimension(400, 400));
            this.e1_ = new Ellipse(100, 100, 60, 90, 0.0);
            this.e2_ = new Ellipse(200, 50, 70, 40, 0.5235987755982988);
            Dragger dragger = new Dragger(new Ellipse[]{this.e1_, this.e2_}, this);
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            EllipseToy.setAntialias(g2, true);
            this.paintEllipse(g2, this.e1_);
            this.paintEllipse(g2, this.e2_);
            EllipseCartesianMatchEngine.Match match = EllipseCartesianMatchEngine.getMatch(this.adaptEllipse(this.e1_), this.adaptEllipse(this.e2_), this.recogniseCircles_);
            if (match != null) {
                Point p2;
                g2.setColor(Color.RED);
                g2.drawString(new Formatter().format("%4.2f", match.score_).toString(), (this.e1_.x_ + this.e2_.x_) / 2, (this.e1_.y_ + this.e2_.y_) / 2);
                Point p1 = Double.isNaN(match.x1_ + match.y1_) ? null : new Point((int)match.x1_, (int)match.y1_);
                Point point = p2 = Double.isNaN(match.x2_ + match.y2_) ? null : new Point((int)match.x2_, (int)match.y2_);
                if (p1 != null) {
                    g2.drawLine(this.e1_.x_, this.e1_.y_, p1.x, p1.y);
                }
                if (!Double.isNaN(match.x2_ + match.y2_)) {
                    g2.drawLine(this.e2_.x_, this.e2_.y_, p2.x, p2.y);
                }
                if (p1 != null && p2 != null) {
                    Stroke str = g2.getStroke();
                    g2.setStroke(DASHES);
                    g2.drawLine(p1.x, p1.y, p2.x, p2.y);
                    g2.setStroke(str);
                }
            }
        }

        private void paintEllipse(Graphics g, Ellipse e) {
            Graphics2D g2 = (Graphics2D)g.create();
            int thDeg = (int)(e.theta_ * 180.0 / Math.PI);
            g2.setFont(g2.getFont().deriveFont(10.0f));
            g2.translate(e.x_, e.y_);
            Color c = g2.getColor();
            g2.setColor(new Color(0xD0D0D0));
            g2.fillArc(-20, -20, 40, 40, 0, thDeg);
            g2.setColor(c);
            g2.drawString("" + thDeg, 0, 0);
            g2.rotate(-e.theta_);
            g2.drawLine(-e.a_, 0, e.a_, 0);
            g2.drawLine(0, -e.b_, 0, e.b_);
            g2.drawOval(-e.a_, -e.b_, 2 * e.a_, 2 * e.b_);
            g2.drawString("" + e.a_, e.a_ / 2, 0);
            g2.rotate(1.5707963267948966);
            g2.drawString("" + e.b_, e.b_ / 2, 0);
            g2.rotate(-1.5707963267948966);
        }

        private EllipseCartesianMatchEngine.Ellipse adaptEllipse(Ellipse e) {
            return new EllipseCartesianMatchEngine.Ellipse(e.x_, e.y_, e.a_, e.b_, e.theta_);
        }
    }
}

