/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchKit;

public class EqualsMatchEngine
implements MatchEngine {
    private static final MatchKit KIT = new MatchKit(){

        @Override
        public Object[] getBins(Object[] tuple) {
            Object[] objectArray;
            Object obj = tuple[0];
            if (Tables.isBlank(obj)) {
                objectArray = NO_BINS;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = EqualsMatchEngine.getHash(obj);
            }
            return objectArray;
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            return EqualsMatchEngine.isEqual(tuple1[0], tuple2[0]) ? 0.0 : -1.0;
        }
    };

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        return () -> KIT;
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        return null;
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return null;
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        DefaultValueInfo vinfo = new DefaultValueInfo("Matched Value", Object.class, "Value for exact match");
        vinfo.setNullable(false);
        return new ValueInfo[]{vinfo};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return new DescribedValue[0];
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        return new DescribedValue[0];
    }

    public String toString() {
        return "Exact Value";
    }

    private static boolean isEqual(Object o1, Object o2) {
        if (Tables.isBlank(o1) || Tables.isBlank(o2)) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (c1.isArray() && c2.equals(c1)) {
            Class<?> clazz = c1.getComponentType();
            assert (clazz == c2.getComponentType());
            if (clazz == Byte.TYPE) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (clazz == Short.TYPE) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
            if (clazz == Integer.TYPE) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (clazz == Long.TYPE) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (clazz == Float.TYPE) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (clazz == Double.TYPE) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
            if (clazz == Boolean.TYPE) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (clazz == Character.TYPE) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            assert (Object.class.isAssignableFrom(clazz));
            Object[] a1 = (Object[])o1;
            int n1 = a1.length;
            Object[] a2 = (Object[])o2;
            int n2 = a2.length;
            if (n1 != n2) {
                return false;
            }
            for (int i = 0; i < n1; ++i) {
                if (EqualsMatchEngine.isEqual(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        if (EqualsMatchEngine.isNumber(o1) && EqualsMatchEngine.isNumber(o2) && !c1.equals(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            return EqualsMatchEngine.isInteger(n1) && EqualsMatchEngine.isInteger(n2) ? n1.longValue() == n2.longValue() : n1.doubleValue() == n2.doubleValue();
        }
        return false;
    }

    private static int getHash(Object obj) {
        if (Tables.isBlank(obj)) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            int leng = Array.getLength(obj);
            int hash = 17;
            for (int i = 0; i < leng; ++i) {
                hash = 23 * hash + EqualsMatchEngine.getHash(Array.get(obj, i));
            }
            return hash;
        }
        if (EqualsMatchEngine.isNumber(obj)) {
            long bits = Double.doubleToLongBits(((Number)obj).doubleValue());
            return (int)(bits ^ bits >>> 32);
        }
        return obj.hashCode();
    }

    private static boolean isNumber(Object obj) {
        return obj instanceof Number && (EqualsMatchEngine.isInteger((Number)obj) || obj instanceof Float || obj instanceof Double);
    }

    private static boolean isInteger(Number num) {
        return num instanceof Byte || num instanceof Short || num instanceof Integer || num instanceof Long;
    }
}

