/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.join.Profiler;
import uk.ac.starlink.table.join.ProgressIndicator;

public class RangeModelProgressIndicator
extends DefaultBoundedRangeModel
implements ProgressIndicator,
Runnable {
    double level;
    double lastUpdatedLevel;
    final Profiler profiler;
    static final int MAX = 1000;
    static final double DMAX = 1000.0;

    public RangeModelProgressIndicator(boolean profile) {
        super(0, 1000, 0, 1000);
        this.profiler = profile ? new Profiler() : null;
    }

    @Override
    public void startStage(String stage) {
        this.level = 0.0;
        this.lastUpdatedLevel = 0.0;
        this.updateNow();
        if (this.profiler != null) {
            this.profiler.reset();
        }
    }

    @Override
    public void setLevel(double lev) throws InterruptedException {
        this.level = lev;
        if (this.level - this.lastUpdatedLevel > 0.01) {
            this.lastUpdatedLevel = this.level;
            this.updateNow();
        }
    }

    @Override
    public void endStage() {
        this.level = 0.0;
        this.lastUpdatedLevel = 0.0;
        this.updateNow();
        if (this.profiler != null) {
            this.logMessage(this.profiler.report());
        }
    }

    @Override
    public void logMessage(String msg) {
    }

    private void updateNow() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.setValue((int)(this.level * 1000.0));
        this.fireStateChanged();
    }
}

