/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.join.Binners;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.LongBinner;
import uk.ac.starlink.table.join.MatchComputer;
import uk.ac.starlink.table.join.MatchKit;
import uk.ac.starlink.table.join.ObjectBinner;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.ProgressRowSequence;
import uk.ac.starlink.table.join.RowLink2;
import uk.ac.starlink.table.join.RowRef;

class SequentialMatchComputer
implements MatchComputer {
    SequentialMatchComputer() {
    }

    @Override
    public String getDescription() {
        return "Sequential";
    }

    @Override
    public MatchComputer.BinnedRows binRowIndices(Supplier<MatchKit> kitFact, Supplier<Predicate<Object[]>> rowSelector, StarTable tableR, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        final LongBinner binner = Binners.createLongBinner(tableR.getRowCount());
        long nrow = 0L;
        long nref = 0L;
        long nexclude = 0L;
        MatchKit matchKit = kitFact.get();
        Predicate<Object[]> inclusion = rowSelector.get();
        try (ProgressRowSequence rseq = new ProgressRowSequence(tableR, indicator, stageTxt);){
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                if (inclusion.test(row)) {
                    Object[] keys = matchKit.getBins(row);
                    int nkey = keys.length;
                    for (int ikey = 0; ikey < nkey; ++ikey) {
                        binner.addItem(keys[ikey], lrow);
                    }
                    nref += (long)nkey;
                } else {
                    ++nexclude;
                }
                ++nrow;
                ++lrow;
            }
            assert (nrow == tableR.getRowCount());
        }
        final long nref0 = nref;
        final long nexclude0 = nexclude;
        return new MatchComputer.BinnedRows(){

            @Override
            public LongBinner getLongBinner() {
                return binner;
            }

            @Override
            public long getNref() {
                return nref0;
            }

            @Override
            public long getNexclude() {
                return nexclude0;
            }
        };
    }

    @Override
    public long binRowRefs(Supplier<MatchKit> kitFact, Supplier<Predicate<Object[]>> rowSelector, StarTable table, int tIndex, ObjectBinner<Object, RowRef> binner, boolean newBins, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        long nrow = 0L;
        long ninclude = 0L;
        MatchKit matchKit = kitFact.get();
        Predicate<Object[]> inclusion = rowSelector.get();
        try (ProgressRowSequence rseq = new ProgressRowSequence(table, indicator, stageTxt);){
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                if (inclusion.test(row)) {
                    ++ninclude;
                    Object[] keys = matchKit.getBins(row);
                    if (keys.length > 0) {
                        RowRef rref = new RowRef(tIndex, lrow);
                        for (Object key : keys) {
                            if (!newBins && !binner.containsKey(key)) continue;
                            binner.addItem(key, rref);
                        }
                    }
                }
                ++nrow;
                ++lrow;
            }
        }
        assert (nrow == table.getRowCount() || table.getRowCount() < 0L);
        return ninclude;
    }

    @Override
    public LinkSet scanBinsForPairs(Supplier<MatchKit> kitFact, Supplier<Predicate<Object[]>> rowSelector, StarTable tableR, int indexR, StarTable tableS, int indexS, boolean bestOnly, LongBinner binnerR, Supplier<LinkSet> linksetCreator, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        LinkSet linkSet = linksetCreator.get();
        MatchKit matchKit = kitFact.get();
        Predicate<Object[]> inclusion = rowSelector.get();
        try (ProgressRowSequence sseq = new ProgressRowSequence(tableS, indicator, stageTxt);){
            ArrayList<RowLink2> linkList = new ArrayList<RowLink2>();
            HashSet<Long> rrowSet = new HashSet<Long>();
            long isrow = 0L;
            while (sseq.nextProgress()) {
                Object[] srowData = sseq.getRow();
                if (inclusion.test(srowData)) {
                    Object[] keys = matchKit.getBins(srowData);
                    int nkey = keys.length;
                    rrowSet.clear();
                    for (int ikey = 0; ikey < nkey; ++ikey) {
                        long[] rrows = binnerR.getLongs(keys[ikey]);
                        if (rrows == null) continue;
                        for (int ir = 0; ir < rrows.length; ++ir) {
                            rrowSet.add(rrows[ir]);
                        }
                    }
                    long[] rrows = new long[rrowSet.size()];
                    int ir = 0;
                    for (Long rr : rrowSet) {
                        rrows[ir++] = rr;
                    }
                    Arrays.sort(rrows);
                    linkList.clear();
                    double bestScore = Double.MAX_VALUE;
                    for (ir = 0; ir < rrows.length; ++ir) {
                        long irrow = rrows[ir];
                        Object[] rrowData = tableR.getRow(irrow);
                        double score = matchKit.matchScore(srowData, rrowData);
                        if (!(score >= 0.0) || bestOnly && !(score < bestScore)) continue;
                        RowRef rref = new RowRef(indexR, irrow);
                        RowRef sref = new RowRef(indexS, isrow);
                        RowLink2 pairLink = new RowLink2(rref, sref);
                        pairLink.setScore(score);
                        if (bestOnly) {
                            bestScore = score;
                            linkList.clear();
                        }
                        linkList.add(pairLink);
                        assert (!bestOnly || linkList.size() == 1);
                    }
                    for (RowLink2 pairLink : linkList) {
                        assert (!linkSet.containsLink(pairLink));
                        linkSet.addLink(pairLink);
                    }
                }
                ++isrow;
            }
        }
        return linkSet;
    }

    @Override
    public Coverage readCoverage(Supplier<Coverage> covFact, StarTable table, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        Coverage cov = covFact.get();
        try (ProgressRowSequence rseq = new ProgressRowSequence(table, indicator, stageTxt);){
            while (rseq.nextProgress()) {
                cov.extend(rseq.getRow());
            }
        }
        return cov;
    }

    @Override
    public long countRows(StarTable table, Supplier<Predicate<Object[]>> rowSelector, ProgressIndicator indicator, String stageTxt) throws IOException, InterruptedException {
        Predicate<Object[]> inclusion = rowSelector.get();
        long nInclude = 0L;
        try (ProgressRowSequence rseq = new ProgressRowSequence(table, indicator, stageTxt);){
            while (rseq.nextProgress()) {
                if (!inclusion.test(rseq.getRow())) continue;
                ++nInclude;
            }
        }
        return nInclude;
    }
}

