/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableSerializerConfig;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataBufferedOutputStream;
import uk.ac.starlink.util.IOUtils;

public abstract class AbstractFitsTableWriter
extends StreamStarTableWriter
implements MultiStarTableWriter {
    private String formatName_;
    private boolean writeDate_;
    private boolean allowSignedByte_;
    private boolean allowZeroLengthString_;
    private WideFits wide_;
    private byte padChar_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected AbstractFitsTableWriter(String formatName) {
        this.setFormatName(formatName);
        this.allowSignedByte_ = true;
        this.allowZeroLengthString_ = true;
        this.wide_ = WideFits.DEFAULT;
        this.padChar_ = 0;
        this.writeDate_ = true;
    }

    @Override
    public String getFormatName() {
        return this.formatName_;
    }

    public void setFormatName(String formatName) {
        this.formatName_ = formatName;
    }

    @Override
    public String getMimeType() {
        return "application/fits";
    }

    @Override
    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        this.writeStarTables(Tables.singleTableSequence(table), out);
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        StarTable table;
        this.writePrimaryHDU(out);
        while ((table = tableSeq.nextTable()) != null) {
            this.writeTableHDU(table, this.createSerializer(table), out);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTables(TableSequence tableSeq, String location, StarTableOutput sto) throws IOException {
        try (OutputStream out = sto.getOutputStream(location);){
            out = new BufferedOutputStream(out);
            this.writeStarTables(tableSeq, out);
            out.flush();
        }
    }

    public void writePrimaryHDU(OutputStream out) throws IOException {
        FitsUtil.writeEmptyPrimary(out);
    }

    public void writeTableHDU(StarTable table, FitsTableSerializer fitser, OutputStream out) throws IOException {
        ArrayList<CardImage> cards = new ArrayList<CardImage>(Arrays.asList(fitser.getHeader()));
        cards.addAll(this.getMetadataCards());
        cards.add(CardFactory.END_CARD);
        FitsUtil.writeHeader(cards.toArray(new CardImage[0]), out);
        DataBufferedOutputStream dout = new DataBufferedOutputStream(out);
        fitser.writeData((DataOutput)dout);
        dout.flush();
    }

    public FitsTableSerializerConfig getConfig() {
        final boolean allowSignedByte = this.getAllowSignedByte();
        final boolean allowZeroLengthString = this.getAllowZeroLengthString();
        final WideFits wide = this.getWide();
        final byte padChar = this.getPadCharacter();
        return new FitsTableSerializerConfig(){

            @Override
            public boolean allowSignedByte() {
                return allowSignedByte;
            }

            @Override
            public boolean allowZeroLengthString() {
                return allowZeroLengthString;
            }

            @Override
            public WideFits getWide() {
                return wide;
            }

            @Override
            public byte getPadCharacter() {
                return padChar;
            }
        };
    }

    protected abstract FitsTableSerializer createSerializer(StarTable var1) throws IOException;

    protected List<CardImage> getMetadataCards() {
        ArrayList<CardImage> cards = new ArrayList<CardImage>();
        CardFactory cfact = CardFactory.DEFAULT;
        if (this.getWriteDate()) {
            cards.add(cfact.createStringCard("DATE-HDU", AbstractFitsTableWriter.getCurrentDate(), "Date of HDU creation (UTC)"));
        }
        String stilVers = IOUtils.getResourceContents(StarTable.class, (String)"stil.version", null);
        cards.add(cfact.createStringCard("STILVERS", stilVers, "Version of STIL software"));
        cards.add(cfact.createStringCard("STILCLAS", this.getClass().getName(), "STIL Author class"));
        return cards;
    }

    @ConfigMethod(property="date", doc="<p>If true, the DATE-HDU header is filled in with the current date; otherwise it is not included.</p>")
    public void setWriteDate(boolean writeDate) {
        this.writeDate_ = writeDate;
    }

    public boolean getWriteDate() {
        return this.writeDate_;
    }

    public void setAllowSignedByte(boolean allowSignedByte) {
        this.allowSignedByte_ = allowSignedByte;
    }

    public boolean getAllowSignedByte() {
        return this.allowSignedByte_;
    }

    public void setAllowZeroLengthString(boolean allowZeroLengthString) {
        this.allowZeroLengthString_ = allowZeroLengthString;
    }

    public boolean getAllowZeroLengthString() {
        return this.allowZeroLengthString_;
    }

    public void setWide(WideFits wide) {
        this.wide_ = wide;
    }

    public WideFits getWide() {
        return this.wide_;
    }

    public void setPadCharacter(byte padChar) {
        this.padChar_ = padChar;
    }

    public byte getPadCharacter() {
        return this.padChar_;
    }

    public static String getCurrentDate() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        fmt.setTimeZone(utc);
        fmt.setCalendar(new GregorianCalendar(utc, Locale.UK));
        return fmt.format(new Date());
    }
}

