/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.CardType;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.ParsedCard;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.IOUtils;

public class FitsUtil {
    public static final int BLOCK_LENG = 2880;
    public static final int CARD_LENG = 80;
    public static final int CARDS_PER_BLOCK = 36;
    public static final int MAX_NCOLSTD = 999;
    public static final String FLOAT_REGEX = "(?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?";
    private static final Pattern FLOATARRAY_PATTERN = Pattern.compile("\\s*[(]\\s*(?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?(\\s*[,]\\s*(?:[+-]?(?:[0-9]*\\.[0-9]+|[0-9]+\\.?))(?:[ED][+-]?[0-9]+)?)*+\\s*[)]\\s*");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    private FitsUtil() {
    }

    public static boolean isMagic(byte[] buffer) {
        return buffer.length >= 9 && (char)buffer[0] == 'S' && (char)buffer[1] == 'I' && (char)buffer[2] == 'M' && (char)buffer[3] == 'P' && (char)buffer[4] == 'L' && (char)buffer[5] == 'E' && (char)buffer[6] == ' ' && (char)buffer[7] == ' ' && (char)buffer[8] == '=';
    }

    public static boolean isFitsCharacter(int ch) {
        return ch >= 32 && ch <= 126;
    }

    public static FitsHeader readHeader(InputStream in) throws IOException {
        FitsHeader hdr = FitsUtil.readHeaderIfPresent(in);
        if (hdr == null) {
            throw new EOFException("FITS ended before header");
        }
        return hdr;
    }

    /*
     * Unable to fully structure code
     */
    public static FitsHeader readHeaderIfPresent(InputStream in) throws IOException {
        list = new ArrayList<ParsedCard<?>>();
        blockBuf = new byte[2880];
        cardBuf = new byte[80];
        while (true) {
            for (ngot = 0; ngot < 2880; ngot += n) {
                n = in.read(blockBuf, ngot, 2880 - ngot);
                if (n >= 0) continue;
                if (ngot == 0) {
                    if (list.size() == 0) {
                        return null;
                    }
                    throw new EOFException("FITS ended mid-header");
                }
                throw new EOFException("FITS ended mid-block");
            }
            ipos = 0;
            while (true) {
                if (ipos >= 2880) ** continue;
                System.arraycopy(blockBuf, ipos, cardBuf, 0, 80);
                card = FitsUtil.parseCard(cardBuf);
                list.add(card);
                if (CardType.END == card.getType()) {
                    cards = list.toArray(new ParsedCard[0]);
                    return new FitsHeader(cards);
                }
                ipos += 80;
            }
            break;
        }
    }

    public static ParsedCard<?> parseCard(byte[] buf80) {
        String txt80 = new String(buf80, StandardCharsets.US_ASCII);
        for (CardType<?> type : CardType.CARD_TYPES) {
            ParsedCard<?> card = type.toCard(txt80);
            if (card == null) continue;
            return card;
        }
        return new ParsedCard<Object>(null, CardType.UNKNOWN, null, null);
    }

    public static long skipHDUs(InputStream in, int nskip) throws IOException {
        long advance = 0L;
        while (nskip-- > 0) {
            FitsHeader hdr = FitsUtil.readHeader(in);
            advance += hdr.getHeaderByteCount();
            long datasize = hdr.getDataByteCount();
            IOUtils.skip((InputStream)in, (long)datasize);
            advance += datasize;
        }
        return advance;
    }

    public static long roundUp(long value, int blockSize) {
        return (value + (long)blockSize - 1L) / (long)blockSize * (long)blockSize;
    }

    public static int writeHeader(CardImage[] cards, OutputStream out) throws IOException {
        int ncard = cards.length;
        int nbyte = Tables.checkedLongToInt(FitsUtil.roundUp(cards.length * 80, 2880));
        byte[] buf = new byte[nbyte];
        for (int ic = 0; ic < ncard; ++ic) {
            System.arraycopy(cards[ic].getBytes(), 0, buf, ic * 80, 80);
        }
        Arrays.fill(buf, ncard * 80, nbyte, (byte)32);
        out.write(buf);
        return nbyte;
    }

    public static void writeEmptyPrimary(OutputStream out) throws IOException {
        CardFactory cfact = CardFactory.STRICT;
        CardImage[] cards = new CardImage[]{cfact.createLogicalCard("SIMPLE", true, "Standard FITS format"), cfact.createIntegerCard("BITPIX", 8L, "Character data"), cfact.createIntegerCard("NAXIS", 0L, "No image, just extensions"), cfact.createLogicalCard("EXTEND", true, "There are standard extensions"), cfact.createCommentCard("Dummy header; see following table extension"), CardFactory.END_CARD};
        FitsUtil.writeHeader(cards, out);
    }

    public static void checkColumnCount(WideFits wide, int ncol) throws IOException {
        if (wide == null) {
            if (ncol > 999) {
                String msg = new StringBuffer().append("Too many columns ").append(ncol).append(" > ").append(999).append(" (FITS standard hard limit)").toString();
                throw new IOException(msg);
            }
        } else {
            int nmax = wide.getExtColumnMax();
            if (ncol > nmax) {
                String msg = new StringBuffer().append("Too many column ").append(ncol).append(" > ").append(nmax).append(" (limit of extended column convention").toString();
                throw new IOException(msg);
            }
        }
    }

    public static Object asNumericArray(String txt) {
        if (FLOATARRAY_PATTERN.matcher(txt).matches()) {
            String[] tokens = txt.substring(txt.indexOf(40) + 1, txt.indexOf(41)).split("\\s*,\\s*");
            int n = tokens.length;
            boolean isInts = true;
            int[] ivals = new int[n];
            double[] dvals = new double[n];
            try {
                for (int i = 0; i < n; ++i) {
                    dvals[i] = Double.parseDouble(tokens[i]);
                    ivals[i] = (int)dvals[i];
                    isInts &= (double)ivals[i] == dvals[i];
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            return isInts ? ivals : (int[])dvals;
        }
        return null;
    }
}

