/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Logger;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.fits.ColumnWriter;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;

abstract class ScalarColumnWriter
implements ColumnWriter {
    private final char formatChar_;
    private final int nbyte_;
    private final Number badNumber_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected ScalarColumnWriter(char formatChar, int nbyte, Number badNumber) {
        this.formatChar_ = formatChar;
        this.nbyte_ = nbyte;
        this.badNumber_ = badNumber;
    }

    @Override
    public String getFormat() {
        return new String(new char[]{this.formatChar_});
    }

    @Override
    public char getFormatChar() {
        return this.formatChar_;
    }

    @Override
    public int getLength() {
        return this.nbyte_;
    }

    @Override
    public int[] getDims() {
        return null;
    }

    @Override
    public BigDecimal getZero() {
        return BigDecimal.ZERO;
    }

    @Override
    public double getScale() {
        return 1.0;
    }

    @Override
    public Number getBadNumber() {
        return this.badNumber_;
    }

    public static ScalarColumnWriter createColumnWriter(ColumnInfo cinfo, boolean nullableInt, boolean allowSignedByte, final byte padChar) {
        Object blankObj;
        DescribedValue blankVal;
        Class<?> clazz = cinfo.getContentClass();
        Number blankNum = null;
        if (nullableInt && (blankVal = cinfo.getAuxDatum(Tables.NULL_VALUE_INFO)) != null && (blankObj = blankVal.getValue()) instanceof Number) {
            blankNum = (Number)blankObj;
        }
        boolean isUbyte = Boolean.TRUE.equals(cinfo.getAuxDatumValue(Tables.UBYTE_FLAG_INFO, Boolean.class));
        final BigInteger longOffset = ScalarColumnWriter.getLongOffset(cinfo);
        if (isUbyte && clazz == Short.class) {
            final short badVal = blankNum == null ? (short)255 : (short)blankNum.shortValue();
            return new ScalarColumnWriter('B', 1, nullableInt ? Short.valueOf(badVal) : null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    short bval = value != null ? ((Number)value).shortValue() : badVal;
                    stream.writeByte(bval);
                }
            };
        }
        if (longOffset != null && clazz == String.class) {
            final long badVal = blankNum == null ? Long.MIN_VALUE : blankNum.longValue();
            final BigDecimal zeroNum = new BigDecimal(longOffset);
            return new ScalarColumnWriter('K', 8, nullableInt ? Long.valueOf(badVal) : null){

                @Override
                public BigDecimal getZero() {
                    return zeroNum;
                }

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    long lval = value instanceof String ? 2.getOffsetLongValue((String)value, longOffset, badVal) : badVal;
                    stream.writeLong(lval);
                }
            };
        }
        if (clazz == Boolean.class) {
            return new ScalarColumnWriter('L', 1, null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    int b = Boolean.TRUE.equals(value) ? 84 : (Boolean.FALSE.equals(value) ? 70 : 0);
                    stream.writeByte(b);
                }
            };
        }
        if (clazz == Byte.class) {
            if (allowSignedByte) {
                final byte[] buf = new byte[1];
                final byte badVal = blankNum == null ? (byte)0 : blankNum.byteValue();
                final BigDecimal zeroByte = new BigDecimal(-128);
                return new ScalarColumnWriter('B', 1, nullableInt ? Byte.valueOf(badVal) : null){

                    @Override
                    public void writeValue(DataOutput stream, Object value) throws IOException {
                        byte b = value != null ? ((Number)value).byteValue() : badVal;
                        buf[0] = (byte)(b ^ 0xFFFFFF80);
                        stream.write(buf);
                    }

                    @Override
                    public BigDecimal getZero() {
                        return zeroByte;
                    }
                };
            }
            final short badVal = blankNum == null ? (short)-129 : (short)blankNum.shortValue();
            return new ScalarColumnWriter('I', 2, nullableInt ? Short.valueOf(badVal) : null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    short sval = value != null ? ((Number)value).shortValue() : badVal;
                    stream.writeShort(sval);
                }
            };
        }
        if (clazz == Short.class) {
            final short badVal = blankNum == null ? (short)Short.MIN_VALUE : (short)blankNum.shortValue();
            return new ScalarColumnWriter('I', 2, nullableInt ? Short.valueOf(badVal) : null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    short sval = value != null ? ((Number)value).shortValue() : badVal;
                    stream.writeShort(sval);
                }
            };
        }
        if (clazz == Integer.class) {
            final int badVal = blankNum == null ? Integer.MIN_VALUE : blankNum.intValue();
            return new ScalarColumnWriter('J', 4, nullableInt ? Integer.valueOf(badVal) : null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    int ival = value != null ? ((Number)value).intValue() : badVal;
                    stream.writeInt(ival);
                }
            };
        }
        if (clazz == Long.class) {
            final long badVal = blankNum == null ? Long.MIN_VALUE : blankNum.longValue();
            return new ScalarColumnWriter('K', 8, nullableInt ? Long.valueOf(badVal) : null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    long lval = value != null ? ((Number)value).longValue() : badVal;
                    stream.writeLong(lval);
                }
            };
        }
        if (clazz == Float.class) {
            return new ScalarColumnWriter('E', 4, null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    float fval = value != null ? ((Number)value).floatValue() : Float.NaN;
                    stream.writeFloat(fval);
                }
            };
        }
        if (clazz == Double.class) {
            return new ScalarColumnWriter('D', 8, null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    double dval = value != null ? ((Number)value).doubleValue() : Double.NaN;
                    stream.writeDouble(dval);
                }
            };
        }
        if (clazz == Character.class) {
            return new ScalarColumnWriter('A', 1, null){

                @Override
                public void writeValue(DataOutput stream, Object value) throws IOException {
                    char cval = value != null ? ((Character)value).charValue() : (char)padChar;
                    stream.writeByte(cval);
                }
            };
        }
        return null;
    }

    static BigInteger getLongOffset(ColumnInfo cinfo) {
        String longoffTxt;
        Class<?> clazz = cinfo.getContentClass();
        if ((String.class.equals(clazz) || String[].class.equals(clazz)) && (longoffTxt = cinfo.getAuxDatumValue(BintableStarTable.LONGOFF_INFO, String.class)) != null) {
            try {
                return new BigInteger(longoffTxt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static long getOffsetLongValue(String txt, BigInteger longOffset, long badVal) {
        if (txt == null) {
            return badVal;
        }
        try {
            return new BigInteger(txt).subtract(longOffset).longValueExact();
        }
        catch (NumberFormatException e) {
            return badVal;
        }
        catch (ArithmeticException e) {
            return badVal;
        }
    }
}

