/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import uk.ac.starlink.parquet.ParquetIO;
import uk.ac.starlink.parquet.ParquetUtil;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.formats.DocumentedIOHandler;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.VOTableVersion;

public class ParquetTableWriter
implements StarTableWriter,
DocumentedIOHandler {
    private boolean groupArray_ = true;
    private CompressionCodecName codec_;
    private Boolean useDict_;
    private boolean votMeta_ = true;
    private Map<String, String> kvItems_;
    private VOTableVersion votVersion_;
    private static final String FMT_NAME = "parquet";

    @Override
    public String getFormatName() {
        return FMT_NAME;
    }

    @Override
    public String[] getExtensions() {
        return new String[]{FMT_NAME, "parq"};
    }

    @Override
    public boolean looksLikeFile(String location) {
        return DocumentedIOHandler.matchesExtension(this, location);
    }

    @Override
    public String getMimeType() {
        return "application/octet-stream";
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>Parquet is a columnar format developed within the Apache", "project.", "Data is compressed on disk and read into memory before use.", this.readText("parquet-format.xml"), "</p>", "<p>The parquet file format itself defines only rather limited", "semantic metadata, so that there is no standard way to record", "column units, descriptions, UCDs etc.", "By default,", "additional metadata is written in the form of a DATA-less VOTable", "attached to the file footer, as described by the", "<webref url='https://www.ivoa.net/documents/Notes/VOParquet/'", ">VOParquet convention</webref>.", "This additional metadata can then be retrieved by other", "VOParquet-aware software.", "</p>", this.readText("parquet-packaging.xml"), "");
    }

    @Override
    public void writeStarTable(StarTable table, String location, StarTableOutput sto) throws IOException {
        ParquetIO io = ParquetUtil.getIO();
        if ("-".equals(location)) {
            io.writeParquet(table, this, System.out);
        } else {
            io.writeParquet(table, this, location);
        }
    }

    @Override
    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        ParquetUtil.getIO().writeParquet(table, this, out);
    }

    @ConfigMethod(property="groupArray", sequence=5, usage="true|false", example="false", doc="<p>Controls the low-level detail of how array-valued columns\nare written.\nFor an array-valued int32 column named IVAL,\n<code>groupArray=false</code> will write it as\n\"<code>repeated int32 IVAL</code>\"\nwhile <code>groupArray=true</code> will write it as\n\"<code>optional group IVAL (LIST) {repeated group list\n{optional int32 element}}</code>\".\n</p><p>Although setting it <code>false</code> may be slightly more\nefficient, the default is <code>true</code>,\nsince if any of the columns have array values that either\nmay be null or may have elements which are null,\ngroupArray-style declarations for all columns are required\nby the <webref url='https://github.com/apache/parquet-format/blob/apache-parquet-format-2.10.0/LogicalTypes.md'>Parquet file format</webref>:\n<blockquote><em>\n\"A repeated field that is neither contained by a LIST- or\nMAP-annotated group nor annotated by LIST or MAP should be\ninterpreted as a required list of required elements where\nthe element type is the type of the field.\nImplementations should use either LIST and MAP annotations\nor unannotated repeated fields, but not both. When using the\nannotations, no unannotated repeated types are allowed.\"\n</em></blockquote>\n</p><p>If this option is set false and an attempt is made to write\nnull arrays or arrays with null values, writing will fail.\n</p>")
    public void setGroupArray(boolean groupArray) {
        this.groupArray_ = groupArray;
    }

    public boolean isGroupArray() {
        return this.groupArray_;
    }

    @ConfigMethod(property="compression", sequence=2, example="gzip", usage="uncompressed|snappy|zstd|gzip|lz4_raw", doc="<p>Configures the type of compression used for output.\nSupported values are probably\n<code>uncompressed</code>, <code>snappy</code>,\n<code>zstd</code>, <code>gzip</code> and <code>lz4_raw</code>.\nOthers may be available if the relevant codecs are on the\nclasspath at runtime.\nIf no value is specified, the parquet-mr library default\nis used, which is probably <code>uncompressed</code>.</p>")
    public void setCompressionCodec(CompressionCodecName codec) {
        this.codec_ = codec;
    }

    public CompressionCodecName getCompressionCodec() {
        return this.codec_;
    }

    @ConfigMethod(property="usedict", example="false", sequence=4, doc="<p>Determines whether dictionary encoding is used for output.\nThis will work well to compress the output\nfor columns with a small number of distinct values.\nEven when this setting is true,\ndictionary encoding is abandoned once many values\nhave been encountered (the dictionary gets too big).\nIf no value is specified, the parquet-mr library default\nis used, which is probably <code>true</code>.\n</p>")
    public void setDictionaryEncoding(Boolean useDict) {
        this.useDict_ = useDict;
    }

    public Boolean isDictionaryEncoding() {
        return this.useDict_;
    }

    @ConfigMethod(property="votmeta", sequence=1, example="false", doc="<p>If true, rich metadata for the table will be written out\nin the form of a DATA-less VOTable that is stored in the\nparquet extra metadata key-value list under the key\n<code>IVOA.VOTable-Parquet.content</code>,\naccording to the\n<webref url='https://www.ivoa.net/documents/Notes/VOParquet/'>VOParquet convention</webref> (version 1.0).\nThis enables items such as Units, UCDs and column descriptions, that would otherwise be lost in the serialization,\nto be stored in the output parquet file.\nThis information can then be recovered by parquet readers\nthat understand this convention.\n</p>")
    public void setVOTableMetadata(boolean votMeta) {
        this.votMeta_ = votMeta;
    }

    public boolean isVOTableMetadata() {
        return this.votMeta_;
    }

    public void setKeyValueItems(Map<String, String> kvItems) {
        this.kvItems_ = kvItems;
    }

    public Map<String, String> getKeyValueItems() {
        return this.kvItems_;
    }

    @ConfigMethod(property="kvmap", sequence=3, example="author:Messier", usage="key1:value1;key2:value2;...", doc="<p>Can be used to doctor the map of key-value metadata\nstored in the parquet footer.\nMap items are specified with a colon, like\n<code>&lt;key&gt;:&lt;value&gt;</code>\nand separated with a semicolon,\nso for instance you could write\n\"<code>kvmap=author:Messier;year:1774</code>\".\nThis will overwrite any map entries that would otherwise\nhave been written.\nIf a value starts with the at sign (\"<code>@</code>\")\nit is interpreted as giving the name of a file\nwhose contents will be used instead of the literal value.\nSpecifying an empty entry will ensure it is not written\ninto the key=value list.</p><p>The following output format specification would write\nparquet output including VOParquet metadata from\na manually prepared VOTable file <code>meta.vot</code>:\n<verbatim>\n   parquet(votmeta=false,kvmap=IVOA.VOTable-Parquet.version:1.0;IVOA.VOTable-Parquet.content:@meta.vot)</verbatim>\n</p>")
    public void setKVMap(KVMap kvItems) {
        this.setKeyValueItems(kvItems);
    }

    public void setVOTableVersion(VOTableVersion votVersion) {
        this.votVersion_ = votVersion;
    }

    public VOTableVersion getVOTableVersion() {
        return this.votVersion_;
    }

    public static class KVMap
    extends LinkedHashMap<String, String> {
        public static KVMap valueOf(String txt) {
            String[] words;
            KVMap map = new KVMap();
            for (String word : words = txt.split(";", 0)) {
                String value;
                String key;
                String[] kv = word.split(":", 2);
                if (kv.length == 2) {
                    key = kv[0];
                    String val = kv[1];
                    if (val.length() == 0) {
                        value = null;
                    } else if (val.charAt(0) == '@') {
                        String fname = val.substring(1);
                        try {
                            value = KVMap.readFile(fname);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read file " + fname, e);
                        }
                    } else {
                        value = val;
                    }
                } else {
                    String msg = new StringBuffer().append("Don't understand \"").append(word).append("\", should be <key>:[<value>]").toString();
                    throw new IllegalArgumentException(msg);
                }
                map.put(key, value);
            }
            return map;
        }

        private static String readFile(String fname) throws IOException {
            try (FileInputStream in = new FileInputStream(fname);){
                String string = new String(IOUtils.readBytes((InputStream)in, (int)0x100000), StandardCharsets.UTF_8);
                return string;
            }
        }
    }
}

