/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.ColStat;
import uk.ac.starlink.feather.ItemAccumulator;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.StoragePolicy;

public abstract class AbstractItemAccumulator
implements ItemAccumulator {
    private final StoragePolicy storage_;
    private final boolean isNullable_;
    private final ByteStore maskStore_;
    private final OutputStream maskOut_;
    private long nRow_;
    private long nNull_;
    private int ibit_;
    private int mask_;

    protected AbstractItemAccumulator(StoragePolicy storage, boolean isNullable) {
        this.storage_ = storage;
        this.isNullable_ = isNullable;
        this.maskStore_ = isNullable ? storage.makeByteStore() : null;
        this.maskOut_ = isNullable ? new BufferedOutputStream(this.maskStore_.getOutputStream()) : null;
    }

    protected abstract void addDataItem(Object var1) throws IOException;

    protected abstract void closeData() throws IOException;

    protected boolean isNull(Object item) {
        return item == null;
    }

    public abstract long writeDataBytes(OutputStream var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.isNullable_) {
            this.maskOut_.close();
            this.maskStore_.close();
        }
        this.closeData();
    }

    @Override
    public void addItem(Object item) throws IOException {
        ++this.nRow_;
        if (this.isNullable_) {
            if (this.isNull(item)) {
                ++this.nNull_;
            } else {
                this.mask_ |= 1 << this.ibit_;
            }
            if (++this.ibit_ == 8) {
                this.maskOut_.write(this.mask_);
                this.ibit_ = 0;
                this.mask_ = 0;
            }
        }
        this.addDataItem(item);
    }

    @Override
    public ColStat writeColumnBytes(OutputStream out) throws IOException {
        long dataOffset;
        long byteCount;
        long nNullByte;
        if (this.isNullable_) {
            if (this.ibit_ > 0) {
                this.maskOut_.write(this.mask_);
            }
            long nbMask = (this.nRow_ + 7L) / 8L;
            nbMask += (long)BufUtils.align8(this.maskOut_, nbMask);
            this.maskOut_.close();
            if (this.nNull_ > 0L) {
                this.maskStore_.copy(out);
                nNullByte = nbMask;
            } else {
                nNullByte = 0L;
            }
            this.maskStore_.close();
        } else {
            nNullByte = 0L;
        }
        long nbData = this.writeDataBytes(out);
        long nDataByte = nbData + (long)BufUtils.align8(out, nbData);
        final long rowCount = this.nRow_;
        final long nullCount = this.nNull_;
        if (this.nNull_ > 0L) {
            byteCount = nNullByte + nDataByte;
            dataOffset = nNullByte;
        } else {
            byteCount = nDataByte;
            dataOffset = 0L;
        }
        return new ColStat(){

            @Override
            public long getByteCount() {
                return byteCount;
            }

            @Override
            public long getNullCount() {
                return nullCount;
            }

            @Override
            public long getRowCount() {
                return rowCount;
            }

            @Override
            public long getDataOffset() {
                return dataOffset;
            }
        };
    }
}

