/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.starlink.feather.AbstractItemAccumulator;
import uk.ac.starlink.feather.ItemAccumulator;
import uk.ac.starlink.feather.StarColumnWriter;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;

public class BooleanStarColumnWriter
extends StarColumnWriter {
    public BooleanStarColumnWriter(StarTable table, int icol) {
        super(table, icol, FeatherType.BOOL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarColumnWriter.DataStat writeDataBytes(OutputStream out) throws IOException {
        int icol = this.getColumnIndex();
        RowSequence rseq = this.getTable().getRowSequence();
        int mask = 0;
        int ibit = 0;
        long nrow = 0L;
        try {
            while (rseq.next()) {
                ++nrow;
                if (Boolean.TRUE.equals(rseq.getCell(icol))) {
                    mask |= 1 << ibit;
                }
                if (++ibit != 8) continue;
                out.write(mask);
                ibit = 0;
                mask = 0;
            }
            if (ibit > 0) {
                out.write(mask);
            }
        }
        finally {
            rseq.close();
        }
        long nbyte = (nrow + 7L) / 8L;
        return new StarColumnWriter.DataStat(nbyte, nrow);
    }

    @Override
    public ItemAccumulator createItemAccumulator(StoragePolicy storage) {
        final ByteStore dataStore = storage.makeByteStore();
        final BufferedOutputStream dataOut = new BufferedOutputStream(dataStore.getOutputStream());
        return new AbstractItemAccumulator(storage, true){
            int mask;
            int ibit;
            long nbyte;
            long nrow;

            @Override
            public void addDataItem(Object item) throws IOException {
                ++this.nrow;
                if (Boolean.TRUE.equals(item)) {
                    this.mask |= 1 << this.ibit;
                }
                if (++this.ibit == 8) {
                    dataOut.write(this.mask);
                    ++this.nbyte;
                    this.ibit = 0;
                    this.mask = 0;
                }
            }

            @Override
            public long writeDataBytes(OutputStream out) throws IOException {
                if (this.ibit > 0) {
                    dataOut.write(this.mask);
                    ++this.nbyte;
                }
                dataOut.close();
                dataStore.copy(out);
                dataStore.close();
                assert (this.nbyte == (this.nrow + 7L) / 8L);
                return this.nbyte;
            }

            @Override
            public void closeData() throws IOException {
                dataOut.close();
                dataStore.close();
            }
        };
    }
}

