/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.function.LongSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;

public class RandomRowSplittable
implements RowSplittable {
    private final StarTable table_;
    private final RowAccess access_;
    private long irow_;
    private long nrow_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.table.RandomRowSplittable");

    public RandomRowSplittable(StarTable table) throws IOException {
        this(table, -1L, table.getRowCount());
    }

    private RandomRowSplittable(StarTable table, long irow, long nrow) throws IOException {
        this.table_ = table;
        if (!table.isRandom()) {
            throw new UnsupportedOperationException("Table not random access");
        }
        this.access_ = table.getRowAccess();
        this.irow_ = irow;
        this.nrow_ = nrow;
    }

    @Override
    public long splittableSize() {
        return this.nrow_ - this.irow_;
    }

    @Override
    public RandomRowSplittable split() {
        if (this.nrow_ - this.irow_ > 2L) {
            RandomRowSplittable split;
            long mid = (this.irow_ + this.nrow_) / 2L;
            try {
                split = new RandomRowSplittable(this.table_, this.irow_, mid);
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Split failed with IOException: " + e, e);
                return null;
            }
            this.irow_ = mid - 1L;
            return split;
        }
        return null;
    }

    @Override
    public LongSupplier rowIndex() {
        return () -> this.irow_;
    }

    @Override
    public boolean next() throws IOException {
        if (this.irow_ < this.nrow_ - 1L) {
            ++this.irow_;
            this.access_.setRowIndex(this.irow_);
            return true;
        }
        return false;
    }

    @Override
    public Object getCell(int icol) throws IOException {
        return this.access_.getCell(icol);
    }

    @Override
    public Object[] getRow() throws IOException {
        return this.access_.getRow();
    }

    @Override
    public void close() throws IOException {
        this.access_.close();
    }
}

