/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ClassTableScheme;
import uk.ac.starlink.table.LoopTableScheme;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TablePreparation;
import uk.ac.starlink.table.TableScheme;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.TestTableScheme;
import uk.ac.starlink.table.formats.AsciiTableBuilder;
import uk.ac.starlink.table.formats.CsvTableBuilder;
import uk.ac.starlink.table.formats.IpacTableBuilder;
import uk.ac.starlink.table.formats.TstTableBuilder;
import uk.ac.starlink.table.formats.WDCTableBuilder;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.table.jdbc.JDBCTableScheme;
import uk.ac.starlink.util.BeanConfig;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.URLDataSource;

public class StarTableFactory {
    private List<TableBuilder> defaultBuilders_;
    private List<TableBuilder> knownBuilders_;
    private Map<String, TableScheme> schemes_;
    private JDBCHandler jdbcHandler_;
    private boolean requireRandom_;
    private StoragePolicy storagePolicy_;
    private TablePreparation tablePrep_;
    private Predicate<DataSource> inputRestriction_;
    public static final String KNOWN_BUILDERS_PROPERTY = "startable.readers";
    public static final String SCHEMES_PROPERTY = "startable.schemes";
    public static final String AUTO_HANDLER = "(auto)";
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.table");
    private static final Pattern SCHEME_REGEX = Pattern.compile(":([a-zA-Z0-9_-]+):(.*)");
    private static String[] defaultBuilderClasses = new String[]{"uk.ac.starlink.votable.FitsPlusTableBuilder", "uk.ac.starlink.votable.ColFitsPlusTableBuilder", "uk.ac.starlink.fits.ColFitsTableBuilder", "uk.ac.starlink.fits.FitsTableBuilder", "uk.ac.starlink.votable.VOTableBuilder", "uk.ac.starlink.cdf.CdfTableBuilder", "uk.ac.starlink.ecsv.EcsvTableBuilder", "uk.ac.starlink.pds4.Pds4TableBuilder", "uk.ac.starlink.table.formats.MrtTableBuilder", "uk.ac.starlink.parquet.ParquetTableBuilder", "uk.ac.starlink.feather.FeatherTableBuilder", "uk.ac.starlink.gbin.GbinTableBuilder"};
    private static String[] knownBuilderClasses = new String[]{AsciiTableBuilder.class.getName(), CsvTableBuilder.class.getName(), TstTableBuilder.class.getName(), IpacTableBuilder.class.getName(), "uk.ac.starlink.hapi.HapiTableBuilder", WDCTableBuilder.class.getName()};
    private static String[] dfltSchemeClasses = new String[]{LoopTableScheme.class.getName(), TestTableScheme.class.getName(), ClassTableScheme.class.getName(), "uk.ac.starlink.hapi.HapiTableScheme"};

    public StarTableFactory() {
        this(false);
    }

    public StarTableFactory(boolean requireRandom) {
        this.requireRandom_ = requireRandom;
        this.defaultBuilders_ = StarTableFactory.listFromClassNames(defaultBuilderClasses, TableBuilder.class);
        this.knownBuilders_ = new ArrayList<TableBuilder>();
        this.knownBuilders_.addAll(this.defaultBuilders_);
        this.knownBuilders_.addAll(StarTableFactory.listFromClassNames(knownBuilderClasses, TableBuilder.class));
        this.knownBuilders_.addAll(Loader.getClassInstances(KNOWN_BUILDERS_PROPERTY, TableBuilder.class));
        ArrayList<TableScheme> schemeList = new ArrayList<TableScheme>();
        schemeList.add(new JDBCTableScheme(this));
        schemeList.addAll(StarTableFactory.listFromClassNames(dfltSchemeClasses, TableScheme.class));
        schemeList.addAll(Loader.getClassInstances(SCHEMES_PROPERTY, TableScheme.class));
        this.schemes_ = new LinkedHashMap<String, TableScheme>();
        for (TableScheme scheme : schemeList) {
            this.addScheme(scheme);
        }
    }

    public StarTableFactory(StarTableFactory fact) {
        this(fact.requireRandom());
        this.defaultBuilders_ = new ArrayList<TableBuilder>(fact.defaultBuilders_);
        this.knownBuilders_ = new ArrayList<TableBuilder>(fact.knownBuilders_);
        this.schemes_ = new LinkedHashMap<String, TableScheme>(fact.schemes_);
        this.storagePolicy_ = fact.storagePolicy_;
        this.tablePrep_ = fact.tablePrep_;
    }

    public List<TableBuilder> getDefaultBuilders() {
        return this.defaultBuilders_;
    }

    public void setDefaultBuilders(TableBuilder[] builders) {
        this.defaultBuilders_ = new ArrayList<TableBuilder>(Arrays.asList(builders));
    }

    public List<TableBuilder> getKnownBuilders() {
        return this.knownBuilders_;
    }

    public void setKnownBuilders(TableBuilder[] builders) {
        this.knownBuilders_ = new ArrayList<TableBuilder>(Arrays.asList(builders));
    }

    public List<String> getKnownFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        for (TableBuilder b : this.getKnownBuilders()) {
            formats.add(b.getFormatName());
        }
        return formats;
    }

    public Map<String, TableScheme> getSchemes() {
        return this.schemes_;
    }

    public void addScheme(TableScheme scheme) {
        this.schemes_.put(scheme.getSchemeName(), scheme);
    }

    public void setRequireRandom(boolean requireRandom) {
        this.requireRandom_ = requireRandom;
    }

    public boolean requireRandom() {
        return this.requireRandom_;
    }

    public void setStoragePolicy(StoragePolicy policy) {
        this.storagePolicy_ = policy;
    }

    public StoragePolicy getStoragePolicy() {
        if (this.storagePolicy_ == null) {
            this.storagePolicy_ = StoragePolicy.getDefaultPolicy();
        }
        return this.storagePolicy_;
    }

    public void setPreparation(TablePreparation tablePrep) {
        this.tablePrep_ = tablePrep;
    }

    public TablePreparation getPreparation() {
        return this.tablePrep_;
    }

    public void setInputRestriction(Predicate<DataSource> restriction) {
        this.inputRestriction_ = restriction;
    }

    public Predicate<DataSource> getInputRestriction() {
        return this.inputRestriction_;
    }

    public StarTable randomTable(StarTable table) throws IOException {
        return this.getStoragePolicy().randomTable(table);
    }

    public StarTable makeStarTable(DataSource datsrc) throws TableFormatException, IOException {
        this.checkDataSource(datsrc);
        List<TableBuilder> builders = this.getTableBuilders(datsrc);
        for (TableBuilder builder : builders) {
            try {
                StarTable startab = builder.makeStarTable(datsrc, this.requireRandom(), this.getStoragePolicy());
                startab = this.prepareTable(startab, builder);
                startab.setURL(datsrc.getURL());
                if (startab.getName() == null) {
                    startab.setName(datsrc.getName());
                }
                return startab;
            }
            catch (TableFormatException e) {
                logger.info("Table not " + builder.getFormatName() + " - " + e.getMessage());
            }
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Can't make StarTable from \"").append(datsrc.getName()).append("\"");
        Iterator<TableBuilder> it = builders.iterator();
        if (it.hasNext()) {
            msg.append(" (tried");
            while (it.hasNext()) {
                msg.append(" ").append(it.next().getFormatName());
                if (!it.hasNext()) continue;
                msg.append(',');
            }
            msg.append(')');
        } else {
            msg.append(" - no table handlers available");
        }
        throw new TableFormatException(msg.toString());
    }

    public TableSequence makeStarTables(DataSource datsrc) throws TableFormatException, IOException {
        this.checkDataSource(datsrc);
        List<TableBuilder> builders = this.getTableBuilders(datsrc);
        for (TableBuilder builder : builders) {
            try {
                if (builder instanceof MultiTableBuilder) {
                    MultiTableBuilder mbuilder = (MultiTableBuilder)builder;
                    TableSequence tseq = mbuilder.makeStarTables(datsrc, this.getStoragePolicy());
                    String nameBase = datsrc.getName() + "-";
                    return this.prepareTableSequence(tseq, nameBase, mbuilder);
                }
                StarTable startab = builder.makeStarTable(datsrc, this.requireRandom(), this.getStoragePolicy());
                startab = this.prepareTable(startab, builder);
                startab.setURL(datsrc.getURL());
                if (startab.getName() == null) {
                    startab.setName(datsrc.getName());
                }
                return Tables.singleTableSequence(startab);
            }
            catch (TableFormatException e) {
                logger.info("Table not " + builder.getFormatName() + " - " + e.getMessage());
            }
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Can't make StarTables from \"").append(datsrc.getName()).append("\"");
        Iterator<TableBuilder> it = builders.iterator();
        if (it.hasNext()) {
            msg.append(" (tried");
            while (it.hasNext()) {
                msg.append(" ").append(it.next().getFormatName());
                if (!it.hasNext()) continue;
                msg.append(',');
            }
            msg.append(')');
        } else {
            msg.append(" - no table handlers available");
        }
        throw new TableFormatException(msg.toString());
    }

    public StarTable makeStarTable(String location) throws TableFormatException, IOException {
        String[] schemeLoc = StarTableFactory.parseSchemeLocation(location);
        if (schemeLoc != null) {
            TableScheme scheme = this.schemes_.get(schemeLoc[0]);
            if (scheme != null) {
                return this.createSchemeTable(location, scheme);
            }
            return this.makeStarTable(this.schemeSyntaxDataSource(location));
        }
        return this.makeStarTable(DataSource.makeDataSource(location));
    }

    @Deprecated
    public StarTable makeStarTable(URL url) throws IOException {
        return this.makeStarTable(new URLDataSource(url));
    }

    public StarTable makeStarTable(DataSource datsrc, String handler) throws TableFormatException, IOException {
        StarTable startab;
        this.checkDataSource(datsrc);
        if (handler == null || handler.trim().length() == 0 || handler.equals(AUTO_HANDLER)) {
            return this.makeStarTable(datsrc);
        }
        TableBuilder builder = this.getTableBuilder(handler);
        try {
            startab = builder.makeStarTable(datsrc, this.requireRandom(), this.getStoragePolicy());
            startab = this.prepareTable(startab, builder);
        }
        catch (TableFormatException e) {
            String msg = "Can't open " + datsrc.getName() + " as " + builder.getFormatName();
            String emsg = e.getMessage();
            msg = emsg != null && emsg.trim().length() > 0 ? msg + " (" + emsg + ")" : msg + " (" + e.toString() + ")";
            throw new TableFormatException(msg, e);
        }
        startab.setURL(datsrc.getURL());
        if (startab.getName() == null) {
            startab.setName(datsrc.getName());
        }
        return startab;
    }

    public TableSequence makeStarTables(DataSource datsrc, String handler) throws TableFormatException, IOException {
        this.checkDataSource(datsrc);
        if (handler == null || handler.trim().length() == 0 || handler.equals(AUTO_HANDLER)) {
            return this.makeStarTables(datsrc);
        }
        TableBuilder builder = this.getTableBuilder(handler);
        try {
            if (builder instanceof MultiTableBuilder) {
                MultiTableBuilder mbuilder = (MultiTableBuilder)builder;
                TableSequence tseq = mbuilder.makeStarTables(datsrc, this.getStoragePolicy());
                String nameBase = datsrc.getName() + "-";
                return this.prepareTableSequence(tseq, nameBase, mbuilder);
            }
            StarTable startab = builder.makeStarTable(datsrc, this.requireRandom(), this.getStoragePolicy());
            startab = this.prepareTable(startab, builder);
            startab.setURL(datsrc.getURL());
            if (startab.getName() == null) {
                startab.setName(datsrc.getName());
            }
            return Tables.singleTableSequence(startab);
        }
        catch (TableFormatException e) {
            String msg = "Can't open " + datsrc.getName() + " as " + builder.getFormatName();
            String emsg = e.getMessage();
            msg = emsg != null && emsg.trim().length() > 0 ? msg + " (" + emsg + ")" : msg + " (" + e.toString() + ")";
            throw new TableFormatException(msg, e);
        }
    }

    public TableSequence makeStarTables(String location, String handler) throws TableFormatException, IOException {
        String[] schemeLoc = StarTableFactory.parseSchemeLocation(location);
        if (schemeLoc != null) {
            TableScheme scheme = this.schemes_.get(schemeLoc[0]);
            if (scheme != null) {
                StarTable table = this.createSchemeTable(location, scheme);
                return Tables.singleTableSequence(table);
            }
            return this.makeStarTables(this.schemeSyntaxDataSource(location), handler);
        }
        return this.makeStarTables(DataSource.makeDataSource(location), handler);
    }

    public StarTable makeStarTable(String location, String handler) throws TableFormatException, IOException {
        if ("-".equals(location)) {
            return this.makeStarTable(System.in, this.getTableBuilder(handler));
        }
        String[] schemeLoc = StarTableFactory.parseSchemeLocation(location);
        if (schemeLoc != null) {
            TableScheme scheme = this.schemes_.get(schemeLoc[0]);
            if (scheme != null) {
                return this.createSchemeTable(location, scheme);
            }
            return this.makeStarTable(this.schemeSyntaxDataSource(location), handler);
        }
        return this.makeStarTable(DataSource.makeDataSource(location), handler);
    }

    @Deprecated
    public StarTable makeStarTable(URL url, String handler) throws TableFormatException, IOException {
        return this.makeStarTable(new URLDataSource(url), handler);
    }

    public StarTable makeStarTable(InputStream in, TableBuilder builder) throws TableFormatException, IOException {
        in = Compression.decompressStatic(in);
        in = new BufferedInputStream(in);
        RowStore store = this.getStoragePolicy().makeRowStore();
        builder.streamStarTable(in, store, null);
        return this.prepareTable(store.getStarTable(), builder);
    }

    public StarTable makeStarTable(Transferable trans) throws IOException {
        DataFlavor[] flavors = trans.getTransferDataFlavors();
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            String mimeType = flavor.getMimeType();
            Class<?> clazz = flavor.getRepresentationClass();
            if (clazz.equals(URL.class)) {
                try {
                    Object data = trans.getTransferData(flavor);
                    if (data instanceof URL) {
                        URL url = (URL)data;
                        return this.makeStarTable(url);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException("DataFlavor " + flavor + " support withdrawn?");
                }
                catch (TableFormatException e) {
                    msg.append(e.getMessage());
                }
            }
            if (!InputStream.class.isAssignableFrom(clazz) || flavor.isFlavorSerializedObjectType()) continue;
            for (TableBuilder builder : this.defaultBuilders_) {
                Object data;
                if (!builder.canImport(flavor)) continue;
                try {
                    data = trans.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException("DataFlavor " + flavor + " support withdrawn?");
                }
                if (data instanceof InputStream) {
                    return this.makeStarTable((InputStream)data, builder);
                }
                throw new RuntimeException("Flavour lies?");
            }
        }
        throw new TableFormatException(msg.toString());
    }

    public boolean canImport(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            String mimeType = flavor.getMimeType();
            Class<?> clazz = flavor.getRepresentationClass();
            if (clazz.equals(URL.class)) {
                return true;
            }
            for (TableBuilder builder : this.defaultBuilders_) {
                if (!builder.canImport(flavor)) continue;
                return true;
            }
        }
        return false;
    }

    public JDBCHandler getJDBCHandler() {
        if (this.jdbcHandler_ == null) {
            this.jdbcHandler_ = new JDBCHandler();
        }
        return this.jdbcHandler_;
    }

    public void setJDBCHandler(JDBCHandler handler) {
        this.jdbcHandler_ = handler;
    }

    public TableBuilder getTableBuilder(String name) throws TableFormatException {
        if (name == null) {
            throw new TableFormatException("No table handler with null name");
        }
        for (TableBuilder builder : this.knownBuilders_) {
            if (!builder.getFormatName().equalsIgnoreCase(name)) continue;
            return builder;
        }
        BeanConfig config = BeanConfig.parseSpec(name);
        String cname = config.getBaseText();
        Class<? extends TableBuilder> clazz = this.getBuilderClass(cname);
        if (clazz != null) {
            TableBuilder tbuilder;
            try {
                tbuilder = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new TableFormatException("Can't instantiate class " + clazz.getName(), e);
            }
            try {
                config.configBean(tbuilder);
            }
            catch (LoadException e) {
                throw new TableFormatException("Handler configuration failed: " + e, e);
            }
            return tbuilder;
        }
        throw new TableFormatException("No table handler available for " + name);
    }

    private Class<? extends TableBuilder> getBuilderClass(String name) throws TableFormatException {
        Class<?> clazz;
        for (TableBuilder builder : this.knownBuilders_) {
            if (!builder.getFormatName().equalsIgnoreCase(name)) continue;
            return builder.getClass();
        }
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (TableBuilder.class.isAssignableFrom(clazz)) {
            return clazz.asSubclass(TableBuilder.class);
        }
        throw new TableFormatException("Class " + clazz.getName() + " does not implement TableBuilder");
    }

    private List<TableBuilder> getTableBuilders(DataSource datsrc) {
        URL url;
        ArrayList<TableBuilder> list = new ArrayList<TableBuilder>(this.defaultBuilders_);
        TableBuilder locBuilder = StarTableFactory.getBuilderByLocation(this.knownBuilders_, datsrc.getName());
        if (locBuilder == null && (url = datsrc.getURL()) != null) {
            locBuilder = StarTableFactory.getBuilderByLocation(this.knownBuilders_, url.toString());
        }
        if (locBuilder != null) {
            list.add(locBuilder);
        }
        return list;
    }

    private static TableBuilder getBuilderByLocation(List<TableBuilder> builders, String loc) {
        if (loc != null) {
            loc = loc.replaceFirst("[.](gz|Z|bz2|bzip2|gzip)$", "");
            for (TableBuilder builder : builders) {
                if (!builder.looksLikeFile(loc)) continue;
                return builder;
            }
        }
        return null;
    }

    private StarTable prepareTable(StarTable startab, TableBuilder builder) throws IOException {
        if (this.requireRandom()) {
            startab = this.randomTable(startab);
        }
        if (this.tablePrep_ != null) {
            startab = this.tablePrep_.prepareLoadedTable(startab, builder);
        }
        return startab;
    }

    private TableSequence prepareTableSequence(final TableSequence tseq, final String nameBase, final MultiTableBuilder builder) {
        return new TableSequence(){
            private int index;

            @Override
            public StarTable nextTable() throws IOException {
                StarTable table = tseq.nextTable();
                if (table == null) {
                    return null;
                }
                ++this.index;
                if ((table = StarTableFactory.this.prepareTable(table, builder)).getName() == null) {
                    table.setName(nameBase + this.index);
                }
                return table;
            }
        };
    }

    private void checkDataSource(DataSource datsrc) throws IOException {
        if (this.inputRestriction_ != null && !this.inputRestriction_.test(datsrc)) {
            throw new IOException("Access blocked to data at " + datsrc);
        }
    }

    private DataSource schemeSyntaxDataSource(String location) throws IOException {
        try {
            return DataSource.makeDataSource(location);
        }
        catch (FileNotFoundException e) {
            String msg = new StringBuffer().append("No such scheme \"").append(StarTableFactory.parseSchemeLocation(location)[0]).append("\" - known schemes: ").append(this.schemes_.keySet()).toString();
            throw new FileNotFoundException(msg);
        }
    }

    private StarTable createSchemeTable(String location, TableScheme scheme) throws IOException {
        StarTable table;
        String schemeName = scheme.getSchemeName();
        String[] parts = StarTableFactory.parseSchemeLocation(location);
        if (parts == null) {
            throw new IllegalArgumentException("Location \"" + location + "\" is not of form :<scheme-name>:<spec>");
        }
        if (!schemeName.equals(parts[0])) {
            throw new IllegalArgumentException("Location \"" + location + "\" is not of form :" + schemeName + ":<spec>");
        }
        String spec = parts[1];
        try {
            table = scheme.createTable(spec);
        }
        catch (TableFormatException e) {
            String msg = new StringBuffer().append("Bad format for ").append(":").append(schemeName).append(":").append(scheme.getSchemeUsage()).append(" (was \"").append(location).append("\"").toString();
            throw new TableFormatException(msg, e);
        }
        return this.prepareTable(table, null);
    }

    public static String[] parseSchemeLocation(String location) {
        String[] stringArray;
        if (location.startsWith("jdbc:")) {
            return new String[]{"jdbc", location.substring(5)};
        }
        Matcher matcher = SCHEME_REGEX.matcher(location);
        if (matcher.matches()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = matcher.group(1);
            stringArray = stringArray2;
            stringArray2[1] = matcher.group(2);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private static <T> List<T> listFromClassNames(String[] classNames, Class<T> type) {
        ArrayList list = new ArrayList();
        for (String cname : classNames) {
            try {
                Class<?> clazz = Class.forName(cname);
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                list.add(instance);
                logger.config(cname + " registered");
            }
            catch (ClassNotFoundException e) {
                logger.info(cname + " not found - can't register");
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Failed to register " + cname + " - " + e, e);
            }
        }
        return list;
    }
}

