/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Consumer;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;

public abstract class HapiType<S, A> {
    private final String identifier_;
    private final Class<S> scalarClazz_;
    private final Class<A> arrayClazz_;
    private final int nbyte_;
    public static final HapiType<String, String[]> STRING;
    public static final HapiType<String, String[]> ISOTIME;
    public static final HapiType<Double, double[]> DOUBLE;
    public static final HapiType<Integer, int[]> INTEGER;
    private static final HapiType<?, ?>[] VALUES;

    private HapiType(String identifier, Class<S> scalarClazz, Class<A> arrayClazz, int nbyte) {
        this.identifier_ = identifier;
        this.scalarClazz_ = scalarClazz;
        this.arrayClazz_ = arrayClazz;
        this.nbyte_ = nbyte;
    }

    public String getIdentifier() {
        return this.identifier_;
    }

    public Class<S> getScalarClass() {
        return this.scalarClazz_;
    }

    public Class<A> getArrayClass() {
        return this.arrayClazz_;
    }

    public int getByteCount(int paramLength) {
        return this.nbyte_ > 0 ? this.nbyte_ : paramLength;
    }

    public abstract S readStringScalar(String var1);

    public abstract S readBinaryScalar(byte[] var1, int var2, int var3);

    public abstract A readStringArray(String[] var1, int var2, int var3);

    public abstract A readBinaryArray(byte[] var1, int var2, int var3, int var4);

    public abstract void applyFills(A var1, S var2);

    public abstract void adjustInfo(DefaultValueInfo var1);

    public String toString() {
        return this.identifier_;
    }

    public static HapiType<?, ?> fromText(String txt) {
        return Arrays.stream(VALUES).filter(s -> s.identifier_.equalsIgnoreCase(txt)).findAny().orElse(null);
    }

    static {
        HapiType[] hapiTypeArray = new HapiType[4];
        STRING = new StringType();
        hapiTypeArray[0] = STRING;
        ISOTIME = new IsotimeType();
        hapiTypeArray[1] = ISOTIME;
        DOUBLE = new DoubleType();
        hapiTypeArray[2] = DOUBLE;
        INTEGER = new IntegerType();
        hapiTypeArray[3] = INTEGER;
        VALUES = hapiTypeArray;
    }

    private static class DoubleType
    extends HapiType<Double, double[]> {
        DoubleType() {
            super("double", Double.class, double[].class, 8);
        }

        @Override
        public Double readStringScalar(String txt) {
            try {
                return Double.parseDouble(txt);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Double readBinaryScalar(byte[] buf, int ipos, int leng) {
            return DoubleType.readBinaryDouble(buf, ipos);
        }

        @Override
        public double[] readStringArray(String[] txts, int ipos, int nel) {
            double[] out = new double[nel];
            for (int i = 0; i < nel; ++i) {
                double dval;
                String txt = txts[ipos + i];
                if (txt == null || txt.length() == 0) {
                    dval = Double.NaN;
                } else {
                    try {
                        dval = Double.parseDouble(txt);
                    }
                    catch (NumberFormatException e) {
                        dval = Double.NaN;
                    }
                }
                out[i] = dval;
            }
            return out;
        }

        @Override
        public double[] readBinaryArray(byte[] buf, int ipos, int elSize, int nel) {
            double[] out = new double[nel];
            for (int i = 0; i < nel; ++i) {
                out[i] = DoubleType.readBinaryDouble(buf, ipos);
                ipos += 8;
            }
            return out;
        }

        @Override
        public void applyFills(double[] array, Double fill) {
            double dfill = fill;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != dfill) continue;
                array[i] = Double.NaN;
            }
        }

        @Override
        public void adjustInfo(DefaultValueInfo info) {
        }

        private static double readBinaryDouble(byte[] buf, int ipos) {
            long bits = (long)(buf[ipos + 0] & 0xFF) | (long)(buf[ipos + 1] & 0xFF) << 8 | (long)(buf[ipos + 2] & 0xFF) << 16 | (long)(buf[ipos + 3] & 0xFF) << 24 | (long)(buf[ipos + 4] & 0xFF) << 32 | (long)(buf[ipos + 5] & 0xFF) << 40 | (long)(buf[ipos + 6] & 0xFF) << 48 | (long)(buf[ipos + 7] & 0xFF) << 56;
            return Double.longBitsToDouble(bits);
        }
    }

    private static class IntegerType
    extends HapiType<Integer, int[]> {
        static final int BLANK_INT_ARRAY_VALUE = 0;

        IntegerType() {
            super("integer", Integer.class, int[].class, 4);
        }

        @Override
        public Integer readStringScalar(String txt) {
            try {
                return Integer.parseInt(txt);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Integer readBinaryScalar(byte[] buf, int ipos, int leng) {
            return IntegerType.readBinaryInt(buf, ipos);
        }

        @Override
        public int[] readStringArray(String[] txts, int ipos, int nel) {
            int[] out = new int[nel];
            for (int i = 0; i < nel; ++i) {
                int ival;
                String txt = txts[ipos + i];
                if (txt == null || txt.length() == 0) {
                    ival = 0;
                } else {
                    try {
                        ival = Integer.parseInt(txt);
                    }
                    catch (NumberFormatException e) {
                        ival = 0;
                    }
                }
                out[i] = ival;
            }
            return out;
        }

        @Override
        public int[] readBinaryArray(byte[] buf, int ipos, int elSize, int nel) {
            int[] out = new int[nel];
            for (int i = 0; i < nel; ++i) {
                out[i] = IntegerType.readBinaryInt(buf, ipos);
                ipos += 4;
            }
            return out;
        }

        @Override
        public void applyFills(int[] array, Integer fill) {
            int ifill = fill;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != ifill) continue;
                array[i] = 0;
            }
        }

        @Override
        public void adjustInfo(DefaultValueInfo info) {
        }

        private static int readBinaryInt(byte[] buf, int ipos) {
            return buf[ipos + 0] & 0xFF | (buf[ipos + 1] & 0xFF) << 8 | (buf[ipos + 2] & 0xFF) << 16 | (buf[ipos + 3] & 0xFF) << 24;
        }
    }

    private static class IsotimeType
    extends StringType {
        IsotimeType() {
            super("isotime", info -> {
                info.setUCD("time.epoch");
                info.setXtype("timestamp");
                info.setDomainMappers(new DomainMapper[]{TimeMapper.ISO_8601});
            });
        }
    }

    private static class StringType
    extends HapiType<String, String[]> {
        private final Consumer<DefaultValueInfo> infoAdjuster_;

        StringType(String name, Consumer<DefaultValueInfo> infoAdjuster) {
            super(name, String.class, String[].class, -1);
            this.infoAdjuster_ = infoAdjuster;
        }

        StringType() {
            this("string", info -> {});
        }

        @Override
        public String readStringScalar(String txt) {
            return txt;
        }

        @Override
        public String readBinaryScalar(byte[] buf, int ipos, int leng) {
            return StringType.readUtf8(buf, ipos, leng);
        }

        @Override
        public String[] readStringArray(String[] txts, int ipos, int nel) {
            String[] out = new String[nel];
            System.arraycopy(txts, ipos, out, 0, nel);
            return out;
        }

        @Override
        public String[] readBinaryArray(byte[] buf, int ipos, int elSize, int nel) {
            String[] out = new String[nel];
            for (int i = 0; i < nel; ++i) {
                out[i] = StringType.readUtf8(buf, ipos, elSize);
                ipos += elSize;
            }
            return out;
        }

        @Override
        public void applyFills(String[] array, String fill) {
            for (int i = 0; i < array.length; ++i) {
                if (!fill.equals(array[i])) continue;
                array[i] = null;
            }
        }

        @Override
        public void adjustInfo(DefaultValueInfo info) {
            this.infoAdjuster_.accept(info);
        }

        private static String readUtf8(byte[] buf, int ipos, int leng) {
            int iend = ipos + leng;
            for (int i = ipos; i < iend; ++i) {
                if (buf[i] != 0) continue;
                iend = i;
            }
            return new String(buf, ipos, iend - ipos, StandardCharsets.UTF_8);
        }
    }
}

