/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import adql.db.DBChecker;
import adql.db.DBColumn;
import adql.db.DBIdentifier;
import adql.db.DBTable;
import adql.db.DefaultDBColumn;
import adql.db.DefaultDBTable;
import adql.db.FunctionDef;
import adql.parser.ADQLParser;
import adql.parser.ADQLQueryFactory;
import adql.parser.QueryChecker;
import adql.parser.feature.FeatureSet;
import adql.parser.feature.LanguageFeature;
import adql.parser.grammar.ParseException;
import adql.parser.grammar.TokenMgrError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.AdqlVersion;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;

public class AdqlValidator {
    private final QueryChecker checker_;
    private final ADQLQueryFactory qfact_;
    private final FeatureSet featureSet_;
    private AdqlVersion version_;
    private boolean isAllowAnyUdf_;
    private ADQLParser parser_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static final AdqlVersion DFLT_VERSION = AdqlVersion.V21;
    static final Ivoid ADQLGEO_FEATURE_TYPE_VOLLT = TapCapability.createTapRegExtIvoid("#features-adqlgeo");
    static final Ivoid ADQLGEO_FEATURE_TYPE_VARIANT = TapCapability.createTapRegExtIvoid("#features-adql-geo");

    private AdqlValidator(AdqlVersion version, FeatureSet featureSet, ValidatorTable[] vtables) {
        this.featureSet_ = featureSet == null ? new FeatureSet(true) : featureSet;
        this.checker_ = vtables == null ? null : new DBChecker(Arrays.stream(vtables).map(ValidatorDBTable::new).collect(Collectors.toList()));
        this.qfact_ = new ADQLQueryFactory();
        this.setAdqlVersion(version);
        assert (this.parser_ != null);
    }

    public void setAdqlVersion(AdqlVersion version) {
        this.version_ = version == null ? DFLT_VERSION : version;
        this.updateParser();
    }

    public void setAllowAnyUdf(boolean isAllowed) {
        this.isAllowAnyUdf_ = isAllowed;
        this.updateParser();
    }

    public void validate(String query) throws ParseException, TokenMgrError {
        this.parser_.parseQuery(query);
    }

    public String fixup(String query) {
        if (query != null && query.trim().length() > 0) {
            try {
                String fixQuery = this.parser_.tryQuickFix(query);
                return query.equals(fixQuery) ? null : fixQuery;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private void updateParser() {
        this.parser_ = new ADQLParser(this.version_.getVolltVersion(), this.checker_, this.qfact_, this.featureSet_);
        this.parser_.allowAnyUdf(this.isAllowAnyUdf_);
    }

    public static AdqlValidator createValidator() {
        return new AdqlValidator(null, null, null);
    }

    public static AdqlValidator createValidator(ValidatorTable[] vtables) {
        return new AdqlValidator(null, null, vtables);
    }

    public static AdqlValidator createValidator(ValidatorTable[] vtables, TapLanguage lang) {
        FeatureSet featureSet;
        TapLanguageFeature[] udfFeats;
        HashMap featMap;
        AdqlVersion version = AdqlValidator.getLatestAdqlVersion(lang);
        HashMap hashMap = featMap = lang == null ? null : new LinkedHashMap<Ivoid, TapLanguageFeature[]>(lang.getFeaturesMap());
        if (featMap == null) {
            featMap = new HashMap();
        }
        ArrayList<LanguageFeature> features = new ArrayList<LanguageFeature>();
        TapLanguageFeature[] variantGeoFeats = (TapLanguageFeature[])featMap.remove(ADQLGEO_FEATURE_TYPE_VARIANT);
        if (variantGeoFeats != null) {
            featMap.put(ADQLGEO_FEATURE_TYPE_VOLLT, variantGeoFeats);
        }
        if ((udfFeats = (TapLanguageFeature[])featMap.remove(TapCapability.UDF_FEATURE_TYPE)) != null) {
            for (TapLanguageFeature udfFeat : udfFeats) {
                String form = udfFeat.getForm();
                try {
                    FunctionDef udf = FunctionDef.parse(form);
                    features.add(udf.toLanguageFeature());
                }
                catch (ParseException e) {
                    logger_.log(Level.INFO, "Failed to parse UDF def \"" + form + "\"", e);
                }
            }
        }
        for (Map.Entry entry : featMap.entrySet()) {
            Ivoid type = (Ivoid)entry.getKey();
            assert (!TapCapability.UDF_FEATURE_TYPE.equals(type) && !ADQLGEO_FEATURE_TYPE_VARIANT.equals(type));
            for (TapLanguageFeature feat : (TapLanguageFeature[])entry.getValue()) {
                features.add(new LanguageFeature(AdqlValidator.volltFeatureType(type), feat.getForm(), true, feat.getDescription()));
            }
        }
        if (features.size() > 0) {
            featureSet = new FeatureSet(false);
            for (LanguageFeature f : features) {
                featureSet.support(f);
            }
        } else {
            featureSet = new FeatureSet(true);
        }
        return new AdqlValidator(version, featureSet, vtables);
    }

    private static String volltFeatureType(Ivoid ivoid) {
        String regPart = ivoid.getRegistryPart();
        String volltTapRegExt = "ivo://ivoa.net/std/TAPRegExt";
        return (volltTapRegExt.equalsIgnoreCase(regPart) ? volltTapRegExt : regPart) + ivoid.getLocalPart();
    }

    public static void main(String[] args) throws ParseException, IOException, SAXException {
        ValidatorTable[] vtables;
        String usage = "\n   Usage: " + AdqlValidator.class.getName() + " [-meta <tmeta-url>] <query>\n";
        SchemaMeta[] schMetas = null;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator<String> it = argList.iterator();
        while (it.hasNext()) {
            String arg = it.next();
            if (arg.startsWith("-h")) {
                System.out.println(usage);
                return;
            }
            if (!arg.equals("-meta") || !it.hasNext()) continue;
            it.remove();
            String loc = it.next();
            it.remove();
            schMetas = TableSetSaxHandler.readTableSet(URLUtils.newURL((String)loc), ContentCoding.GZIP);
        }
        if (argList.size() != 1) {
            System.err.println(usage);
            System.exit(1);
            return;
        }
        String query = argList.remove(0);
        if (schMetas != null) {
            ArrayList<1> vtList = new ArrayList<1>();
            for (SchemaMeta schMeta : schMetas) {
                final String sname = schMeta.getName();
                for (TableMeta tmeta : schMeta.getTables()) {
                    ArrayList<String> colNames;
                    final String tname = tmeta.getName();
                    ColumnMeta[] cmetas = tmeta.getColumns();
                    if (cmetas == null) {
                        colNames = null;
                    } else {
                        colNames = new ArrayList<String>();
                        for (ColumnMeta cmeta : cmetas) {
                            colNames.add(cmeta.getName());
                        }
                    }
                    vtList.add(new ValidatorTable(){

                        @Override
                        public String getSchemaName() {
                            return sname;
                        }

                        @Override
                        public String getTableName() {
                            return tname;
                        }

                        @Override
                        public Collection<String> getColumnNames() {
                            return colNames;
                        }
                    });
                }
            }
            vtables = vtList.toArray(new ValidatorTable[0]);
        } else {
            vtables = null;
        }
        AdqlValidator.createValidator(vtables).validate(query);
    }

    private static AdqlVersion getLatestAdqlVersion(TapLanguage lang) {
        if (lang != null) {
            boolean isAdql = "ADQL".equalsIgnoreCase(lang.getName());
            for (AdqlVersion version : new AdqlVersion[]{AdqlVersion.V21, AdqlVersion.V20}) {
                for (Ivoid vid : lang.getVersionIds()) {
                    if (!version.getIvoid().equalsIvoid(vid)) continue;
                    return version;
                }
                if (!isAdql) continue;
                for (String vnum : lang.getVersions()) {
                    if (!version.getNumber().equals(vnum)) continue;
                    return version;
                }
            }
        }
        return null;
    }

    private static class ValidatorDBTable
    implements DBTable {
        private final ValidatorTable vtable_;
        private String name_;
        private String schemaName_;
        private String catalogName_;
        private boolean isDelimited_;
        private AdqlSyntax syntax_;

        ValidatorDBTable(ValidatorTable vtable) {
            this.vtable_ = vtable;
            this.syntax_ = AdqlSyntax.getInstance();
            String tname = vtable.getTableName();
            this.isDelimited_ = DBIdentifier.isDelimited(tname);
            String[] names = this.syntax_.getCatalogSchemaTable(tname);
            if (names != null) {
                this.name_ = names[2];
                this.schemaName_ = vtable.getSchemaName();
                this.catalogName_ = names[0];
            } else {
                this.name_ = tname;
                this.schemaName_ = vtable.getSchemaName();
                this.catalogName_ = null;
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return this.isDelimited_;
        }

        @Override
        public String getADQLName() {
            return this.syntax_.unquote(this.name_);
        }

        @Override
        public String getDBName() {
            return this.name_;
        }

        @Override
        public String getADQLSchemaName() {
            return this.syntax_.unquote(this.schemaName_);
        }

        @Override
        public String getDBSchemaName() {
            return this.schemaName_;
        }

        @Override
        public String getADQLCatalogName() {
            return this.syntax_.unquote(this.catalogName_);
        }

        @Override
        public String getDBCatalogName() {
            return this.catalogName_;
        }

        @Override
        public DBColumn getColumn(String colName, boolean isAdqlName) {
            Collection<String> cnames = this.vtable_.getColumnNames();
            if (cnames == null) {
                return this.createDBColumn(colName);
            }
            for (String cn : cnames) {
                if (!colName.equals(isAdqlName ? this.syntax_.unquote(cn) : cn)) continue;
                return this.createDBColumn(cn);
            }
            return null;
        }

        @Override
        public Iterator<DBColumn> iterator() {
            Collection<String> cnames = this.vtable_.getColumnNames();
            if (cnames == null) {
                return new ArrayList().iterator();
            }
            final Iterator<String> it = cnames.iterator();
            return new Iterator<DBColumn>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public DBColumn next() {
                    return this.createDBColumn((String)it.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public DBTable copy(String dbName, String adqlName) {
            DefaultDBTable copy = new DefaultDBTable(this.getADQLCatalogName(), this.catalogName_, this.getADQLSchemaName(), this.schemaName_, adqlName, dbName);
            copy.setCaseSensitive(this.isCaseSensitive());
            for (DBColumn col : this) {
                copy.addColumn(col.copy(col.getDBName(), col.getADQLName(), copy));
            }
            return copy;
        }

        private DBColumn createDBColumn(String colName) {
            String rawColName = this.syntax_.unquote(colName);
            return new DefaultDBColumn(colName, rawColName, (DBTable)this);
        }
    }

    public static interface ValidatorTable {
        public String getTableName();

        public String getSchemaName();

        public Collection<String> getColumnNames();
    }
}

