/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MaskTreeModel
implements TreeModel {
    private final boolean includeDescendants_;
    private final List<TreeModelListener> listeners_;
    private final TreeModelListener baseModelListener_;
    private TreeModel base_;
    private int baseNodeCount_;
    private Content content_;
    private static final List<Object> EMPTY_CHILDLIST = Collections.emptyList();

    public MaskTreeModel(TreeModel base, boolean includeDescendants) {
        this.includeDescendants_ = includeDescendants;
        this.base_ = base;
        this.listeners_ = new ArrayList<TreeModelListener>();
        this.baseModelListener_ = new BaseModelListener();
        this.base_.addTreeModelListener(this.baseModelListener_);
        this.baseNodeCount_ = -1;
    }

    @Override
    public Object getRoot() {
        return this.base_.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.base_.isLeaf(node);
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.content_ == null) {
            return this.base_.getChildCount(parent);
        }
        List<Object> children = this.content_.childMap_.get(parent);
        return children == null ? 0 : children.size();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.content_ == null) {
            return this.base_.getChild(parent, index);
        }
        List<Object> children = this.content_.childMap_.get(parent);
        return children == null ? null : children.get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (this.content_ == null) {
            return this.base_.getIndexOfChild(parent, child);
        }
        List<Object> children = this.content_.childMap_.get(parent);
        return children == null ? -1 : children.indexOf(child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.base_.valueForPathChanged(path, newValue);
    }

    @Override
    public void addTreeModelListener(TreeModelListener lnr) {
        this.listeners_.add(lnr);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener lnr) {
        this.listeners_.remove(lnr);
    }

    public TreeModel getBaseModel() {
        return this.base_;
    }

    public void setBaseModel(TreeModel base) {
        this.base_.removeTreeModelListener(this.baseModelListener_);
        this.base_ = base;
        this.baseNodeCount_ = -1;
        if (this.content_ != null) {
            this.content_ = this.createContent(this.base_, this.content_.mask_);
        }
        this.base_.addTreeModelListener(this.baseModelListener_);
        this.fireStructureChanged();
    }

    public Mask getMask() {
        return this.content_ == null ? null : this.content_.mask_;
    }

    public void setMask(Mask mask) {
        if (this.content_ == null ? mask != null : !this.content_.mask_.equals(mask)) {
            this.content_ = this.createContent(this.base_, mask);
            this.fireStructureChanged();
        }
    }

    public int getNodeCount() {
        if (this.content_ != null) {
            return this.content_.inclusionSet_.size();
        }
        if (this.baseNodeCount_ < 0) {
            this.baseNodeCount_ = MaskTreeModel.countDescendants(this.base_.getRoot(), this.base_);
        }
        return this.baseNodeCount_;
    }

    private void fireStructureChanged() {
        TreeModelEvent evt = new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
        for (TreeModelListener lnr : this.listeners_) {
            lnr.treeStructureChanged(evt);
        }
    }

    private Content createContent(TreeModel model, Mask mask) {
        if (mask == null) {
            return null;
        }
        HashSet<Object> inclusionSet = new HashSet<Object>();
        Stack<Object> path = new Stack<Object>();
        Object root = model.getRoot();
        path.push(root);
        boolean allIncluded = MaskTreeModel.addIncludedNodes(inclusionSet, path, model, mask, false, this.includeDescendants_);
        inclusionSet.add(root);
        if (allIncluded) {
            return null;
        }
        HashMap<Object, List<Object>> childMap = new HashMap<Object, List<Object>>();
        MaskTreeModel.addChildLists(childMap, root, inclusionSet, model);
        return new Content(mask, inclusionSet, childMap);
    }

    private static int countDescendants(Object node, TreeModel model) {
        int n = 1;
        int nc = model.getChildCount(node);
        for (int ic = 0; ic < nc; ++ic) {
            n += MaskTreeModel.countDescendants(model.getChild(node, ic), model);
        }
        return n;
    }

    private static boolean addIncludedNodes(Set<Object> inclusionSet, Stack<Object> path, TreeModel model, Mask mask, boolean ancestorsIncluded, boolean includeDescendants) {
        boolean nodeIncluded;
        Object node = path.peek();
        if (ancestorsIncluded) {
            boolean bl = nodeIncluded = includeDescendants || mask.isIncluded(node);
            if (nodeIncluded) {
                inclusionSet.add(node);
            }
        } else {
            nodeIncluded = mask.isIncluded(node);
            if (nodeIncluded) {
                for (Object e : path) {
                    inclusionSet.add(e);
                }
            }
        }
        boolean allIncluded = nodeIncluded;
        int n = model.getChildCount(node);
        for (int ic = 0; ic < n; ++ic) {
            path.push(model.getChild(node, ic));
            allIncluded = MaskTreeModel.addIncludedNodes(inclusionSet, path, model, mask, nodeIncluded, includeDescendants) && allIncluded;
            path.pop();
        }
        return allIncluded;
    }

    private static void addChildLists(Map<Object, List<Object>> childMap, Object node, Set<Object> inclusionSet, TreeModel model) {
        int nc = model.getChildCount(node);
        ArrayList<Object> childList = new ArrayList<Object>();
        for (int ic = 0; ic < nc; ++ic) {
            Object child = model.getChild(node, ic);
            if (!inclusionSet.contains(child)) continue;
            childList.add(child);
            MaskTreeModel.addChildLists(childMap, child, inclusionSet, model);
        }
        childMap.put(node, childList.isEmpty() ? EMPTY_CHILDLIST : childList);
    }

    private class BaseModelListener
    implements TreeModelListener {
        private BaseModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent evt) {
            if (!this.recontent()) {
                for (TreeModelListener lnr : MaskTreeModel.this.listeners_) {
                    lnr.treeNodesChanged(evt);
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent evt) {
            if (!this.recontent()) {
                for (TreeModelListener lnr : MaskTreeModel.this.listeners_) {
                    lnr.treeNodesInserted(evt);
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent evt) {
            if (!this.recontent()) {
                for (TreeModelListener lnr : MaskTreeModel.this.listeners_) {
                    lnr.treeNodesRemoved(evt);
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent evt) {
            if (!this.recontent()) {
                for (TreeModelListener lnr : MaskTreeModel.this.listeners_) {
                    lnr.treeStructureChanged(evt);
                }
            }
        }

        private boolean recontent() {
            if (MaskTreeModel.this.content_ != null) {
                MaskTreeModel.this.content_ = MaskTreeModel.this.createContent(MaskTreeModel.this.base_, ((MaskTreeModel)MaskTreeModel.this).content_.mask_);
                MaskTreeModel.this.fireStructureChanged();
                return true;
            }
            return false;
        }
    }

    private static class Content {
        final Mask mask_;
        final Set<Object> inclusionSet_;
        final Map<Object, List<Object>> childMap_;

        Content(Mask mask, Set<Object> inclusionSet, Map<Object, List<Object>> childMap) {
            this.mask_ = mask;
            this.inclusionSet_ = inclusionSet;
            this.childMap_ = childMap;
            assert (this.mask_ != null && this.inclusionSet_ != null && this.childMap_ != null);
        }
    }

    public static interface Mask {
        public boolean isIncluded(Object var1);
    }
}

