/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.ResourceField;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;

public class RegTapRegistryQuery
implements RegistryQuery {
    private final TapService tapService_;
    private final String adql_;
    private final ContentCoding coding_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static final String SUBJECT_DELIM = ", ";
    public static final String GAVO_REG = "http://reg.g-vo.org/tap";
    public static final String ARI_REG = "http://dc.zah.uni-heidelberg.de/tap";
    public static final String AIP_REG = "http://gavo.aip.de/tap";
    public static final String PARIS_REG = "http://voparis-rr.obspm.fr/tap";
    public static final String EUROVO_REG = "https://registry.euro-vo.org/regtap/tap";
    public static final String STSCI_REG = "https://mast.stsci.edu/vo-tap/api/v0.1/registry";
    public static final String INAF_REG = "http://ia2-vo.oats.inaf.it:8080/registry";
    public static final String[] REGISTRIES = new String[]{"http://reg.g-vo.org/tap", "https://mast.stsci.edu/vo-tap/api/v0.1/registry", "https://registry.euro-vo.org/regtap/tap", "http://dc.zah.uni-heidelberg.de/tap", "http://gavo.aip.de/tap", "http://voparis-rr.obspm.fr/tap"};
    public static final ValueInfo REGISTRY_INFO = new DefaultValueInfo("Registry Location", URL.class, "TAP base URL of registry queried");
    public static final ValueInfo ADQL_INFO = new DefaultValueInfo("Registry Query", String.class, "ADQL text of query made to the registry");
    private static final String AND_IS_STANDARD = " AND intf_role='std'";
    private static Collection<String> HAS_UNIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://reg.g-vo.org/tap", "http://dc.zah.uni-heidelberg.de/tap", "http://gavo.aip.de/tap", "http://voparis-rr.obspm.fr/tap")));

    public RegTapRegistryQuery(TapService tapService, Ivoid[] standardIds, String adqlWhere) {
        this.tapService_ = tapService;
        this.coding_ = ContentCoding.GZIP;
        String[] selCols = new String[]{"ivoid", "short_name", "res_title", "reference_url", "base_role", "role_name", "email", "intf_index", "access_url", "standard_id", "cap_type", "cap_description", "std_version", "res_subjects"};
        StringBuffer abuf = new StringBuffer().append("SELECT");
        for (int i = 0; i < selCols.length; ++i) {
            abuf.append(i > 0 ? SUBJECT_DELIM : " ").append(selCols[i]);
        }
        abuf.append(" FROM rr.resource AS res");
        if (standardIds != null && standardIds.length > 0) {
            abuf.append(" NATURAL JOIN rr.interface").append(" NATURAL JOIN rr.capability");
        }
        abuf.append(" NATURAL LEFT OUTER JOIN rr.res_role").append(" NATURAL LEFT OUTER JOIN").append(" (SELECT").append(" ivoid, ").append(" ivo_string_agg(res_subject, ").append(RegTapRegistryQuery.adqlCharLiteral(SUBJECT_DELIM)).append(")").append(" AS res_subjects").append(" FROM rr.res_subject").append(" GROUP BY ivoid) AS sbj");
        abuf.append(" WHERE (base_role='contact'").append(" OR base_role='publisher'").append(" OR base_role IS NULL)");
        if (standardIds != null && standardIds.length > 0) {
            abuf.append(" AND").append(" standard_id IN (");
            for (int is = 0; is < standardIds.length; ++is) {
                if (is > 0) {
                    abuf.append(SUBJECT_DELIM);
                }
                abuf.append("'").append(standardIds[is].toRegtapString()).append("'");
            }
            abuf.append(")").append(AND_IS_STANDARD);
        }
        if (adqlWhere != null && adqlWhere.trim().length() > 0) {
            abuf.append(" AND").append(" (").append(adqlWhere).append(")");
        }
        this.adql_ = abuf.toString();
    }

    @Override
    public DescribedValue[] getMetadata() {
        return new DescribedValue[]{new DescribedValue(REGISTRY_INFO, (Object)this.getRegistry()), new DescribedValue(ADQL_INFO, (Object)this.getText())};
    }

    @Override
    public URL getRegistry() {
        try {
            return URLUtils.newURL((String)this.tapService_.getIdentity());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getText() {
        return this.adql_;
    }

    @Override
    public RegResource[] getQueryResources() throws IOException {
        boolean overflow;
        logger_.info(this.adql_);
        TapQuery query = new TapQuery(this.tapService_, this.adql_, null);
        QuerySink sink = new QuerySink();
        try {
            overflow = query.executeSync(sink, this.coding_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        RegResource[] resources = sink.getResources();
        int ncap = 0;
        for (int i = 0; i < resources.length; ++i) {
            ncap += resources[i].getCapabilities().length;
        }
        StringBuffer sbuf = new StringBuffer().append("RegTAP query: ").append(sink.nrow_).append(" rows, ").append(resources.length).append(" resources, ").append(ncap).append(" capabilities");
        if (overflow) {
            sbuf.append(" (truncated)");
        }
        logger_.info(sbuf.toString());
        return resources;
    }

    @Override
    public Iterator<RegResource> getQueryIterator() throws IOException {
        return Arrays.asList(this.getQueryResources()).iterator();
    }

    public static String getAdqlCondition(ResourceField field, String keyword, boolean hasSubjectsTable) {
        String rrName = field.getRelationalName();
        if (field == ResourceField.ID || field == ResourceField.SHORTNAME) {
            return new StringBuffer().append("1=ivo_nocasematch(").append(rrName).append(SUBJECT_DELIM).append(RegTapRegistryQuery.adqlCharLiteral("%" + keyword + "%")).append(")").toString();
        }
        if (field == ResourceField.TITLE || field == ResourceField.DESCRIPTION) {
            return new StringBuffer().append("1=ivo_hasword(").append(rrName).append(SUBJECT_DELIM).append(RegTapRegistryQuery.adqlCharLiteral(keyword)).append(")").toString();
        }
        if (field == ResourceField.PUBLISHER) {
            return new StringBuffer().append("(").append("base_role='publisher'").append(" AND ").append("1=ivo_nocasematch(").append("role_name").append(SUBJECT_DELIM).append(RegTapRegistryQuery.adqlCharLiteral("%" + keyword + "%")).append(")").append(")").toString();
        }
        if (field == ResourceField.SUBJECTS) {
            if (hasSubjectsTable) {
                return new StringBuffer().append("1=ivo_nocasematch(").append(rrName).append(SUBJECT_DELIM).append(RegTapRegistryQuery.adqlCharLiteral("%" + keyword + "%")).append(")").toString();
            }
            return new StringBuffer().append("1=ivo_nocasematch(").append("res_subjects").append(SUBJECT_DELIM).append(RegTapRegistryQuery.adqlCharLiteral("%" + keyword + "%")).append(")").toString();
        }
        return null;
    }

    private static String adqlCharLiteral(String txt) {
        return "'" + txt.replaceAll("'", "''") + "'";
    }

    public static String[] getSearchableRegistries(TapService regtapService) throws IOException {
        String adql = new StringBuffer().append("SELECT access_url").append(" FROM rr.interface").append(" NATURAL JOIN rr.capability").append(" NATURAL JOIN rr.res_detail").append(" WHERE standard_id='ivo://ivoa.net/std/tap'").append(AND_IS_STANDARD).append(" AND detail_xpath='/capability/dataModel/@ivo-id' ").append(" AND 1=ivo_nocasematch(detail_value, ").append("'ivo://ivoa.net/std/regtap#1.0')").toString();
        TapQuery query = new TapQuery(regtapService, adql, null);
        logger_.info(adql);
        StarTable table = query.executeSync(StoragePolicy.PREFER_MEMORY, ContentCoding.NONE);
        ArrayList<String> urlList = new ArrayList<String>();
        RowSequence rseq = table.getRowSequence();
        while (rseq.next()) {
            urlList.add((String)rseq.getCell(0));
        }
        rseq.close();
        return urlList.toArray(new String[0]);
    }

    static boolean isSupportUnion(String tapUrl) {
        return HAS_UNIONS.contains(tapUrl);
    }

    private static class QuerySink
    implements TableSink {
        private final Map<String, RegTapResource> resMap_ = new LinkedHashMap<String, RegTapResource>();
        private final Map<String, Integer> colMap_ = new HashMap<String, Integer>();
        long nrow_;

        QuerySink() {
        }

        public RegTapResource[] getResources() {
            return this.resMap_.values().toArray(new RegTapResource[0]);
        }

        public void acceptMetadata(StarTable meta) {
            int ncol = meta.getColumnCount();
            for (int i = 0; i < ncol; ++i) {
                this.colMap_.put(meta.getColumnInfo(i).getName().toLowerCase(), i);
            }
        }

        public void endRows() {
        }

        public void acceptRow(Object[] row) {
            ++this.nrow_;
            String ivoid = this.getString(row, "ivoid");
            String shortName = this.getString(row, "short_name");
            String title = this.getString(row, "res_title");
            String refUrl = this.getString(row, "reference_url");
            String baseRole = this.getString(row, "base_role");
            String roleName = this.getString(row, "role_name");
            String email = this.getString(row, "email");
            Object intfIndex = this.getEntry(row, "intf_index");
            final String accessUrl = this.getString(row, "access_url");
            final String standardId = this.getString(row, "standard_id");
            final String capType = this.getString(row, "cap_type");
            final String capDescription = this.getString(row, "cap_description");
            final String stdVersion = this.getString(row, "std_version");
            String subjectTxt = this.getString(row, "res_subjects");
            if (!this.resMap_.containsKey(ivoid)) {
                String[] subjects = subjectTxt == null ? new String[]{} : subjectTxt.split(RegTapRegistryQuery.SUBJECT_DELIM);
                this.resMap_.put(ivoid, new RegTapResource(ivoid, shortName, title, refUrl, subjects));
            }
            RegTapResource resource = this.resMap_.get(ivoid);
            if ("contact".equals(baseRole)) {
                resource.contactName_ = roleName;
                resource.contactEmail_ = email;
            } else if ("publisher".equals(baseRole)) {
                resource.publisherName_ = roleName;
            }
            if (intfIndex != null && !resource.capMap_.containsKey(intfIndex)) {
                resource.capMap_.put(intfIndex, new RegCapabilityInterface(){

                    @Override
                    public String getAccessUrl() {
                        return accessUrl;
                    }

                    @Override
                    public String getStandardId() {
                        return standardId;
                    }

                    @Override
                    public String getXsiType() {
                        return capType;
                    }

                    @Override
                    public String getDescription() {
                        return capDescription;
                    }

                    @Override
                    public String getVersion() {
                        return stdVersion;
                    }
                });
            }
        }

        private Object getEntry(Object[] row, String rrName) {
            Integer icol = this.colMap_.get(rrName);
            return icol == null ? null : row[icol];
        }

        private String getString(Object[] row, String rrName) {
            return (String)this.getEntry(row, rrName);
        }
    }

    private static class RegTapResource
    implements RegResource {
        final String ivoid_;
        final String shortName_;
        final String title_;
        final String refUrl_;
        String contactName_;
        String contactEmail_;
        String publisherName_;
        String[] subjects_;
        Map<Object, RegCapabilityInterface> capMap_;

        RegTapResource(String ivoid, String shortName, String title, String refUrl, String[] subjects) {
            this.ivoid_ = ivoid;
            this.shortName_ = shortName;
            this.title_ = title;
            this.refUrl_ = refUrl;
            this.subjects_ = subjects;
            this.capMap_ = new LinkedHashMap<Object, RegCapabilityInterface>();
        }

        @Override
        public String getIdentifier() {
            return this.ivoid_;
        }

        @Override
        public String getShortName() {
            return this.shortName_;
        }

        @Override
        public String getTitle() {
            return this.title_;
        }

        @Override
        public String getReferenceUrl() {
            return this.refUrl_;
        }

        @Override
        public String getContact() {
            boolean hasEmail;
            boolean hasName = this.contactName_ != null && this.contactName_.trim().length() > 0;
            boolean bl = hasEmail = this.contactEmail_ != null && this.contactEmail_.trim().length() > 0;
            if (hasEmail && hasName) {
                return this.contactName_ + " <" + this.contactEmail_ + ">";
            }
            if (hasEmail) {
                return this.contactEmail_;
            }
            if (hasName) {
                return this.contactName_;
            }
            return null;
        }

        @Override
        public String getPublisher() {
            return this.publisherName_;
        }

        @Override
        public String[] getSubjects() {
            return this.subjects_;
        }

        @Override
        public RegCapabilityInterface[] getCapabilities() {
            return this.capMap_.values().toArray(new RegCapabilityInterface[0]);
        }
    }
}

