/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;

public class UwsJobPanel
extends JPanel {
    private final ValueField urlField_;
    private final ValueField phaseField_;
    private final ValueField idField_;
    private final ValueField runField_;
    private final ValueField ownerField_;
    private final ValueField durationField_;
    private final ValueField startField_;
    private final ValueField endField_;
    private final ValueField destructionField_;
    private final ValueField errorField_;
    private final JComponent paramPanel_;
    private UwsJob job_;

    public UwsJobPanel(boolean includeUrl) {
        super(new BorderLayout());
        Box main = Box.createVerticalBox();
        this.add((Component)main, "North");
        this.urlField_ = new ValueField();
        this.phaseField_ = new ValueField();
        this.idField_ = new ValueField();
        this.runField_ = new ValueField();
        this.ownerField_ = new ValueField();
        this.durationField_ = new ValueField();
        this.startField_ = new ValueField();
        this.endField_ = new ValueField();
        this.destructionField_ = new ValueField();
        this.errorField_ = new ValueField(true);
        this.paramPanel_ = Box.createVerticalBox();
        Stack stack = new Stack();
        if (includeUrl) {
            stack.addItem("URL", this.urlField_);
        }
        stack.addItem("Phase", this.phaseField_);
        stack.addItem("Job ID", this.idField_);
        stack.addItem("Run ID", this.runField_);
        stack.addItem("Owner ID", this.ownerField_);
        stack.addItem("Max Duration", this.durationField_);
        stack.addItem("Start Time", this.startField_);
        stack.addItem("End Time", this.endField_);
        stack.addItem("Destruction Time", this.destructionField_);
        stack.addItem("Error", this.errorField_);
        stack.addItem("Parameters", this.paramPanel_);
        main.add(stack);
    }

    public UwsJob getJob() {
        return this.job_;
    }

    public void setJob(UwsJob job) {
        this.job_ = job;
        if (this.job_ == null) {
            this.urlField_.setText(null);
        } else {
            this.urlField_.setText(job.getJobUrl().toString());
        }
        this.setJobInfo(job == null ? null : job.getLastInfo());
    }

    public void setJobInfo(UwsJobInfo jobInfo) {
        if (jobInfo == null) {
            this.phaseField_.setText(null);
            this.idField_.setText(null);
            this.runField_.setText(null);
            this.ownerField_.setText(null);
            this.durationField_.setText(null);
            this.startField_.setText(null);
            this.endField_.setText(null);
            this.destructionField_.setText(null);
            this.errorField_.setText(null);
            this.paramPanel_.removeAll();
        } else {
            this.phaseField_.setText(jobInfo.getPhase());
            this.idField_.setText(jobInfo.getJobId());
            this.runField_.setText(jobInfo.getRunId());
            this.ownerField_.setText(jobInfo.getOwnerId());
            String duration = jobInfo.getExecutionDuration();
            if (duration != null && duration.matches("\\s*0+\\s*")) {
                duration = "unlimited";
            }
            this.durationField_.setText(duration);
            this.startField_.setText(jobInfo.getStartTime());
            this.endField_.setText(jobInfo.getEndTime());
            this.destructionField_.setText(jobInfo.getDestruction());
            UwsJobInfo.Parameter[] params = jobInfo.getParameters();
            if (params == null) {
                params = new UwsJobInfo.Parameter[]{};
            }
            Stack pStack = new Stack();
            pStack.setBorder(params.length > 0 ? BorderFactory.createEtchedBorder() : BorderFactory.createEmptyBorder());
            for (int ip = 0; ip < params.length; ++ip) {
                UwsJobInfo.Parameter param = params[ip];
                ValueField pField = new ValueField(true);
                pField.setText(param.getValue());
                pField.setEmph(param.isByReference());
                pStack.addItem(param.getId(), pField);
            }
            this.paramPanel_.removeAll();
            this.paramPanel_.add(pStack);
            UwsJobInfo.Error error = jobInfo.getError();
            this.errorField_.setText(error == null ? null : error.getMessage());
        }
        this.revalidate();
    }

    @Override
    public void scrollRectToVisible(Rectangle rect) {
    }

    private static JComponent createTitledField(String title, JComponent field) {
        Box box = Box.createVerticalBox();
        Box titleLine = Box.createHorizontalBox();
        titleLine.add(new JLabel(title + ": "));
        titleLine.add(Box.createHorizontalGlue());
        box.add(titleLine);
        Box fieldLine = Box.createHorizontalBox();
        fieldLine.add(Box.createHorizontalStrut(20));
        fieldLine.add(field);
        box.add(fieldLine);
        return box;
    }

    private static class ValueField
    extends Box {
        private final JTextComponent textField_;
        private Font baseFont_;

        public ValueField() {
            this(false);
        }

        public ValueField(boolean multiLine) {
            super(0);
            this.textField_ = multiLine ? new JTextArea() : new JTextField();
            this.textField_.setEditable(false);
            if (multiLine) {
                this.textField_.setOpaque(false);
            } else {
                this.textField_.setBorder(BorderFactory.createEmptyBorder());
            }
            this.add(this.textField_);
        }

        public void setText(String txt) {
            this.textField_.setText(txt);
            this.textField_.setCaretPosition(0);
        }

        public void setEmph(boolean emph) {
            if (this.baseFont_ == null) {
                this.baseFont_ = this.textField_.getFont();
            }
            this.textField_.setFont(emph ? this.baseFont_.deriveFont(2) : this.baseFont_);
        }
    }

    private static class Stack
    extends JPanel {
        private final GridBagLayout layer_ = (GridBagLayout)this.getLayout();
        private final GridBagConstraints cons_ = new GridBagConstraints();

        public Stack() {
            super(new GridBagLayout());
            this.cons_.gridy = 0;
        }

        public void addItem(String title, JComponent field) {
            if (this.cons_.gridy > 0) {
                this.cons_.gridx = 0;
                Component strut = Box.createVerticalStrut(4);
                this.layer_.setConstraints(strut, this.cons_);
                this.add(strut);
                ++this.cons_.gridy;
            }
            JLabel titleLabel = new JLabel(title + ": ");
            GridBagConstraints cons1 = (GridBagConstraints)this.cons_.clone();
            cons1.gridx = 0;
            cons1.anchor = 18;
            this.layer_.setConstraints(titleLabel, cons1);
            this.add(titleLabel);
            GridBagConstraints cons2 = (GridBagConstraints)this.cons_.clone();
            cons2.gridx = 1;
            cons2.anchor = 18;
            cons2.weightx = 1.0;
            cons2.fill = 2;
            cons2.gridwidth = 0;
            this.layer_.setConstraints(field, cons2);
            this.add(field);
            ++this.cons_.gridy;
        }
    }
}

