/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ListItem;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Iterator;

public class List
implements TextElementArray {
    protected ArrayList list = new ArrayList();
    protected boolean numbered = false;
    protected boolean lettered = false;
    protected boolean lowercase = false;
    protected boolean autoindent = false;
    protected boolean alignindent = false;
    protected int first = 1;
    protected Chunk symbol = new Chunk("- ");
    protected String preSymbol = "";
    protected String postSymbol = ". ";
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected float symbolIndent = 0.0f;

    public List() {
        this(false, false);
    }

    public List(boolean bl, boolean bl2) {
        this.numbered = bl;
        this.lettered = bl2;
        this.autoindent = true;
        this.alignindent = true;
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 14;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void normalizeIndentation() {
        Element element;
        float f = 0.0f;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!(element instanceof ListItem)) continue;
            f = Math.max(f, ((ListItem)element).getIndentationLeft());
        }
        iterator = this.list.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!(element instanceof ListItem)) continue;
            ((ListItem)element).setIndentationLeft(f);
        }
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public ArrayList getItems() {
        return this.list;
    }

    public boolean isAlignindent() {
        return this.alignindent;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return true;
    }
}

