package fit.gui;

import fit.framework.MetadataTable;
import javax.swing.table.AbstractTableModel;

/**
 * Utility {@link javax.swing.table.TableModel} implementation which 
 * makes it easy to define the characteristics of each column.
 *
 * @author   Mark Taylor
 * @since    31 Oct 2006
 */
public abstract class ColumnsTableModel extends AbstractTableModel {

    private ColDef[] colDefs_;

    /**
     * Constructs an ColumnsTableModel with no columns.
     */
    public ColumnsTableModel() {
        setColDefs( new ColDef[ 0 ] );
    }

    /**
     * Sets the array of column definitions to be used by this model.
     *
     * @param  coldefs  array of column definitions for this table
     */
    public void setColDefs( ColDef[] coldefs ) {
        colDefs_ = coldefs;
        fireTableStructureChanged();
    }

    /**
     * Returns the array of column definitions.
     *
     * @return  coldefs
     */
    public ColDef[] getColDefs() {
        return colDefs_;
    }

    public int getColumnCount() {
        return colDefs_.length;
    }

    public String getColumnName( int icol ) {
        return colDefs_[ icol ].getColumnName();
    }

    public Class getColumnClass( int icol ) {
        return colDefs_[ icol ].getColumnClass();
    }

    public Object getValueAt( int irow, int icol ) {
        ColDef coldef = colDefs_[ icol ];
        Object result = coldef.getValueAt( irow );
        assert result == null ||
               coldef.getColumnClass().isAssignableFrom( result.getClass() );
        return result;
    }
}
