package fit.gui;

import fit.framework.MetadataTable;
import javax.swing.table.AbstractTableModel;

/**
 * TableModel implementation based on a {@link fit.framework.MetadataTable}.
 *
 * @author   Mark Taylor
 * @since    7 Nov 2006
 */
public class MetadataTableModel extends AbstractTableModel 
                             /* implements MetadataTable // could do */
                                                           {

    private final MetadataTable metaTable_;

    /**
     * Constructor.
     *
     * @param   metaTable  metadata table
     */
    public MetadataTableModel( MetadataTable metaTable ) {
        metaTable_ = metaTable;
    }

    public int getColumnCount() {
        return metaTable_.getColumnCount();
    }

    public int getRowCount() {
        return metaTable_.getRowCount();
    }

    public String getColumnName( int icol ) {
        return metaTable_.getColumnName( icol );
    }

    public Class getColumnClass( int icol ) {
        return metaTable_.getColumnClass( icol );
    }

    public Object getValueAt( int irow, int icol ) {
        return metaTable_.getValueAt( irow, icol );
    }
}
