package fit.test;

import fit.formats.ModelTableTheoryReader;
import fit.formats.ModelTableTheoryWriter;
import fit.framework.TheorySet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import uk.ac.starlink.fits.FitsTableWriter;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.util.ByteArrayDataSource;
import uk.ac.starlink.votable.VOTableWriter;

public class ModelTableTest extends FitTestCase {

    public ModelTableTest( String name ) {
        super( name );
    }

    public void testIO() throws IOException {
        testIO( new VOTableWriter() );
        testIO( new FitsTableWriter() );
    }

    public void testIO( StarTableWriter handler ) throws IOException {
        TheorySet tset0 = new TestData( 9876543L ).getTheorySet( 10, 1000 );
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new ModelTableTheoryWriter().write( tset0, handler, out );
        out.close();
        TheorySet tset1 =
            new ModelTableTheoryReader()
           .readTheories( new ByteArrayDataSource( "data",
                                                   out.toByteArray() ) );
        assertTheorySetEquals( tset0, tset1 );
    }

    public void assertTheorySetEquals( TheorySet t0, TheorySet t1 ) {
        assertEquals( t0.getMetadataX(), t1.getMetadataX() );
        assertEquals( t0.getMetadataY(), t1.getMetadataY() );
        assertEquals( t0.getTheoryCount(), t1.getTheoryCount() );
        for ( int ith = 0; ith < t0.getTheoryCount(); ith++ ) {
            assertTheoryEquals( t0.getTheory( ith ), t1.getTheory( ith ) );
        }
        assertMetadataTableEquals( t0.getMetadataTable(),
                                   t1.getMetadataTable() );
    }
}
