package fit.test;

import fit.framework.Theory;
import fit.util.FitUtils;
import uk.ac.starlink.util.TestCase;

public class UtilsTest extends TestCase {

    public UtilsTest( String name ) {
        super( name );
    }

    public void testFibonacciTheory() {
        Theory fib10 = TestUtils.getFibonacciTheory( 10 );
        assertArrayEquals( new double[] { 0, 1, 2, 3, 4, 5, 6,  7,  8,  9, },
                           FitUtils.getXs( fib10 ) );
        assertArrayEquals( new double[] { 0, 1, 1, 2, 3, 5, 8, 13, 21, 34, },
                           FitUtils.getYs( fib10 ) );
    }
 
    public void testCeiling() {
        Theory fib10 = TestUtils.getFibonacciTheory( 10 );
        assertEquals( 1, FitUtils.getCeilingIndex( fib10, 0.5 ) );
        assertEquals( 0, FitUtils.getCeilingIndex( fib10, -99 ) );
        assertEquals( 6, FitUtils.getCeilingIndex( fib10, 6.0 ) );
        assertEquals( 6, FitUtils.getCeilingIndex( fib10, 5.9 ) );
        assertEquals( 7, FitUtils.getCeilingIndex( fib10, 6.1 ) );
        assertEquals( 9, FitUtils.getCeilingIndex( fib10, 9.0 ) );
        assertEquals( 10, FitUtils.getCeilingIndex( fib10, 99.0 ) );
    }

    public void testNumber() {
        assertEquals( Math.PI, FitUtils.getNumber( new Float( 3.14 ) ), 1e-2 );
        assertEquals( 23, (int) FitUtils.getNumber( new Long( 23L ) ) );
    }

}
