package fit.framework;

/**
 * Contains an ordered set of (x,y) points presumed to represent a 
 * theoretical function y(x).
 * The X coordinates are strictly monotonic increasing.
 *
 * @author   Mark Taylor
 * @since    13 Oct 2006
 */
public interface Theory {

    /**
     * Returns an identifier for this object.
     */
    String getName();

    /**
     * Returns the number of points in this sequence.
     *
     * @return   number of points
     */
    int getCount();

    /**
     * Returns the X coordinate for a given index.
     *
     * @param   i  index
     * @return  i'th X coordinate
     */
    double getX( int i );

    /**
     * Returns the Y coordinate for a given index.
     *
     * @param   i  index
     * @return  i'th Y coordinate
     */
    double getY( int i );

    /**
     * Returns the index of the point with the largest X coordinate which
     * is less than or equal to a given value.
     * Therefore if <code>x</code> is greater than the highest X value 
     * in this sequence, the result is <code>getCount()-1</code>.
     * As a special case, if <code>x</code> is smaller than the lowest
     * X value, the result is -1.
     * 
     * @param  x  X coordinate to locate
     * @return  largest index <code>i</code>
     *          for which <code>getX(i)&lt;=x</code>
     */
    int getFloorIndex( double x );
}
