package fit.gui;

import fit.framework.MetadataTable;
import fit.framework.ObservationSet;

/**
 * TableModel implementation which displays an 
 * {@link fit.framework.ObservationSet}.
 *
 * @author   Mark Taylor
 * @since    31 Oct 2006
 */
public class ObservationSetTableModel extends ColumnsTableModel {

    private final ObservationSet obsSet_;

    /**
     * Constructor.
     *
     * @param  obsSet  observation set to display
     */
    public ObservationSetTableModel( ObservationSet obsSet ) {
        obsSet_ = obsSet;
        MetadataTable metaTable = obsSet.getMetadataTable();
        setColDefs( metaTable == null 
                        ? new ColDef[] { ColUtils.getIndexColDef() }
                        : ColUtils.getColDefs( metaTable ) );
    }

    public int getRowCount() {
        return obsSet_.getObsCount();
    }

    /**
     * Returns the observation set displayed by this table.
     *
     * @return  observation set
     */
    public ObservationSet getObservationSet() {
        return obsSet_;
    }
}
