package fit.test;

import fit.formats.GalaxevTheoryReader;
import fit.framework.MetadataTable;
import fit.framework.Theory;
import fit.framework.TheorySet;
import fit.util.FitUtils;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import uk.ac.starlink.util.DataSource;

public class GalaxevTest extends TestCase {

    public static final String TEST_RESOURCE = "galaxev.dat";

    public GalaxevTest( String name ) {
        super( name );
    }

    public void testRead() throws IOException {
        URL url = getClass().getResource( TEST_RESOURCE );
        TheorySet tset = new GalaxevTheoryReader()
                        .readTheories( DataSource.makeDataSource( url ) );

        int nth = tset.getTheoryCount();
        assertEquals( 24, nth );
        for ( int ith = 0; ith < nth; ith++ ) {
            Theory th = tset.getTheory( ith );
            assertEquals( 100, th.getCount() );
            assertEquals( -1, th.getFloorIndex( 90 ) );
            assertEquals( 0, th.getFloorIndex( 92 ) );
        }
        assertEquals( 685, tset.getTheory( 22 ).getX( 99 ), 1e-06 );
        assertEquals( 1.656e-16, tset.getTheory( 22 ).getY( 99 ), 1e-22 );

        MetadataTable meta = tset.getMetadataTable();
        int ageIndex = FitUtils.getColumnIndex( meta, "Age" );
        assertEquals( 0, ageIndex );
        assertEquals( 4.042e8,
                      FitUtils.getNumber( meta.getValueAt( 22, ageIndex ) ),
                      1e-1 );
    }
}
