package fit.util;

import fit.framework.Interpolator;

/**
 * Factory for Interpolator objects.
 *
 * @author   Mark Taylor
 * @since    7 Nov 2006
 */
public interface InterpolatorFactory {

    /**
     * Returns an interpolator for a given X point.
     *
     * @param  x  X value
     * @param  xerr   nominal error on X value
     */
    Interpolator getInterpolator( double x, double xerr );
}
